/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.type.MemberType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.rel.MemberReader;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.util.Util;

public class RelMemberImpl
extends OLAPElementBase
implements Member {
    private static final long serialVersionUID = 7785639635875268662L;
    int ordinal;
    byte memberType;
    RelLevelImpl level;
    Member parent;
    String parentUniqueName;
    protected transient String uniqueName;

    public RelMemberImpl(RelMemberImpl parent) {
        this.parent = parent;
        this.memberType = 1;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public int getDepth() {
        return this.level.getDepth();
    }

    @Override
    public Dimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.level.getHierarchy();
    }

    @Override
    public Member getParentMember() {
        return this.parent;
    }

    @Override
    public String getParentUniqueName() {
        if (this.parentUniqueName == null && this.parent != null) {
            this.parentUniqueName = this.parent.getUniqueName();
        }
        return this.parentUniqueName;
    }

    @Override
    public IMemberList getChildMembers() {
        SchemaReader schemaReader = this.level.hie.getSchemaReader();
        try {
            return schemaReader.getMemberChildren(this);
        }
        catch (OLAPException e) {
            return IMemberList.EMPTY;
        }
    }

    @Override
    public IMemberList getAncestorMembers() {
        IMemberList list = DefaultListFactory.instance.createMemberList();
        for (Member parentMember = this.getParentMember(); parentMember != null; parentMember = parentMember.getParentMember()) {
            list.add(parentMember);
        }
        return list;
    }

    @Override
    public boolean isNull() {
        return (this.memberType & 0x10) == 16;
    }

    @Override
    public boolean isAll() {
        return (this.memberType & 8) == 8;
    }

    @Override
    public boolean isMeasure() {
        return (this.memberType & 2) == 2;
    }

    @Override
    public boolean isLeaf() {
        if (this.isCalculated()) {
            return true;
        }
        if (this.level.getDimension().isParentChildrenDimension()) {
            IMemberList children = this.getChildMembers();
            return children == null || children.isEmpty();
        }
        return this.level.child == null;
    }

    @Override
    public boolean isCalculated() {
        return false;
    }

    @Override
    public boolean isCalculatedInSchema() {
        return false;
    }

    public int getSolveOrder() {
        return 0;
    }

    @Override
    public Object getKey() {
        return this.getProperty("key");
    }

    void setKey(Object key) {
        this.setProperty("key", key);
    }

    @Override
    public byte getMemberType() {
        return this.memberType;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int getDataType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = this.parent == null ? Util.makeFqName(this.getHierarchy(), this.getName()) : Util.makeFqName(this.parent, this.getName());
        }
        return this.uniqueName;
    }

    public Type getExpType() {
        return MemberType.forMember(this);
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        RelHierarchyImpl hierarchy = this.level.hie;
        MemberReader reader = hierarchy.memberReader;
        String[] uniqueNameParts = Util.explode(this, name);
        return reader.lookupMember(uniqueNameParts);
    }

    public int getCategory() {
        return 6;
    }

    @Override
    public Object[] getChildren() {
        IMemberList list = this.getChildMembers();
        return list.toArray(new Member[0]);
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public String quoteKeyForSql() {
        Object key = this.getKey();
        if (key instanceof String) {
            return Util.singleQuoteForSql(key.toString());
        }
        return key.toString();
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public boolean isMeasureProperty() {
        return (this.memberType & 0x20) == 32;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null && this.isAll()) {
            return this.getHierarchy().getAllMemberName();
        }
        return name;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            if (this.isAll()) {
                this.caption = this.getHierarchy().getAllMemberCaption();
            } else if (!this.isCalculated() && !this.isCalculatedInSchema() && !this.level.isInner() && this.level.getDimension().isTimeDimension()) {
                this.caption = Util.fixTimeMemberCaption(this);
                if (this.level.levelType == 4 || this.level.levelType == 3) {
                    String pname = null;
                    Member p = this;
                    while ((p = this.getParentMember()) != null) {
                        if (p.getLevel().getLevelType() != 2) continue;
                        pname = p.getCaption();
                        break;
                    }
                    if (pname != null) {
                        this.caption = pname + this.caption;
                    }
                } else if (this.level.levelType == 7) {
                    String pname = null;
                    Member p = this;
                    while ((p = this.getParentMember()) != null) {
                        byte levelType = p.getLevel().getLevelType();
                        if (levelType != 2 && levelType != 4 && levelType != 3) continue;
                        pname = p.getCaption();
                        break;
                    }
                    if (pname != null) {
                        this.caption = pname + this.caption;
                    }
                }
            } else {
                this.caption = this.getName();
            }
        }
        return this.caption;
    }

    @Override
    public Exp getExpression() throws OLAPException {
        if (this.isAll() && this.getDimension().isParentChildrenDimension()) {
            return this.level.hie.getAllMemberAggregateExp();
        }
        return null;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    public void setVisible(boolean b) {
        this.setProperty("visible", Boolean.valueOf(b).toString());
    }

    @Override
    public boolean isVisible() {
        Object o = this.getProperty("visible");
        if (o != null && "false".equalsIgnoreCase(o.toString())) {
            return false;
        }
        Member parent = this.getParentMember();
        if (parent == null) {
            return true;
        }
        return this.getParentMember().isVisible();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RelMemberImpl)) {
            return false;
        }
        RelMemberImpl m2 = (RelMemberImpl)o;
        return this.getUniqueName().equals(m2.getUniqueName());
    }

    public int hashCode() {
        return this.getUniqueName().hashCode();
    }
}

