/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.remoting;

import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.Lexer;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MdxResult;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.parser;
import com.kingdee.bos.olap.remoting.RemoteException;
import com.kingdee.bos.olap.remoting.RemoteInvoke;
import java.io.StringReader;
import java.util.Locale;
import java_cup.runtime.Symbol;

public class RemoteConnection
implements Connection {
    private RemoteInvoke invoker;
    private SchemaReader sr;
    private String defaultCubeName;

    public RemoteConnection(RemoteInvoke remoteInvoke, boolean init) throws OLAPException {
        this.invoker = remoteInvoke;
        if (init) {
            this.init();
        }
    }

    public RemoteConnection(RemoteInvoke remoteInvoke) throws OLAPException {
        this.invoker = remoteInvoke;
        this.init();
    }

    public void init() throws OLAPException {
        try {
            this.sr = (SchemaReader)this.invoker.invoke("getRemoteSchemaReader", new Class[0], new Object[0]);
            this.defaultCubeName = (String)this.invoker.invoke("getDefaultCubeName", new Class[0], new Object[0]);
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OLAPException) {
                throw (OLAPException)cause;
            }
            if (cause.getCause() != null && cause.getCause() instanceof OLAPException) {
                throw (OLAPException)cause.getCause();
            }
            throw new OLAPException(cause);
        }
    }

    public void setSr(SchemaReader sr) {
        this.sr = sr;
    }

    public void setDefaultCubeName(String defaultCubeName) {
        this.defaultCubeName = defaultCubeName;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.sr;
    }

    @Override
    public MdxResult executeMdxQuery(MdxQuery query) throws OLAPException {
        throw new UnsupportedOperationException("Unsupported operation for remote invoke,please use method executeMdxQuery(String mdx) instead.");
    }

    @Override
    public MdxResult executeMdxQuery(String mdx) throws OLAPException {
        try {
            MdxResult result = (MdxResult)this.invoker.invoke("executeMdxQuery", new Class[]{String.class}, new Object[]{mdx});
            return result;
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            while (cause.getCause() != null) {
                if (!((cause = cause.getCause()) instanceof OLAPException)) continue;
                throw (OLAPException)cause;
            }
            cause = e.getCause();
            throw new OLAPException(cause.getMessage(), cause);
        }
    }

    @Override
    public MdxQuery parseQuery(String mdx) throws OLAPException {
        try {
            StringReader reader = new StringReader(mdx);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            if (!(parse_tree.value instanceof MdxQuery)) {
                throw new Exception("MDX\u8bed\u6cd5\u9519\u8bef!");
            }
            MdxQuery query = (MdxQuery)parse_tree.value;
            query.afterParse(this);
            return query;
        }
        catch (OLAPException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw new OLAPException("MDX\u8bed\u6cd5\u9519\u8bef,\u4e0d\u6b63\u786e\u7684\u6570\u503c!\n\r" + e.getMessage());
        }
        catch (Exception e) {
            throw new OLAPException(e);
        }
    }

    @Override
    public void close() throws OLAPException {
        try {
            this.invoker.invoke("close", new Class[0], new Object[0]);
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OLAPException) {
                throw (OLAPException)cause;
            }
            throw new OLAPException(cause);
        }
    }

    @Override
    public String getDefaultCubeName() {
        return this.defaultCubeName;
    }

    @Override
    public boolean isRolap() {
        return false;
    }

    @Override
    public SchemaReader getRemoteSchemaReader() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Exp parseExpression(String expression) throws OLAPException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Locale getLocale() {
        return null;
    }

    @Override
    public void setLocale(Locale locale) {
    }
}

