/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.ui;

import com.kingdee.bos.ctrl.print.PropertyConfig;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.ui.AbstractStartLocationModel;
import com.kingdee.bos.ctrl.print.config.ui.PaperAdjustModel;
import java.util.StringTokenizer;

public class PaperStartLocationModel
extends AbstractStartLocationModel {
    public PaperStartLocationModel() {
        this.load();
    }

    private void load() {
        String config = PropertyConfig.getPaper_Location();
        this.startContent.clear();
        if (config != null && !config.equals("")) {
            StringTokenizer st = new StringTokenizer(config, ":");
            while (st.hasMoreTokens()) {
                String oneConfig = st.nextToken();
                StringTokenizer stOne = new StringTokenizer(oneConfig, ",");
                String key = stOne.nextToken();
                key = key.replaceAll(PaperAdjustModel.REPLACER, ":");
                float x = Float.parseFloat(stOne.nextToken());
                float y = Float.parseFloat(stOne.nextToken());
                this.startContent.put(key, new float[]{x, y});
            }
        }
    }

    @Override
    public void save() {
        PropertyConfig.setPaper_Location(this.toSaveString());
    }

    private String toSaveString() {
        StringBuffer sb = new StringBuffer();
        for (String printer : this.startContent.keySet()) {
            float[] values = (float[])this.startContent.get(printer);
            float x = values[0];
            float y = values[1];
            if (x == 0.0f && y == 0.0f) continue;
            printer = printer.replaceAll(":", PaperAdjustModel.REPLACER);
            sb.append(printer).append(",").append(x).append(",").append(y);
            sb.append(":");
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return null;
    }

    @Override
    public void set(IConfigModel from) {
    }

    @Override
    public void setDefault() {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public void installManager(PrintJobConfig manager) {
    }
}

