/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.control;

import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.PropertyConfig;
import com.kingdee.bos.ctrl.print.config.attribute.PageRangeReverse;
import com.kingdee.bos.ctrl.print.control.CtrlPageable;
import com.kingdee.bos.ctrl.print.control.CtrlPrintable;
import com.kingdee.bos.ctrl.print.control.CtrlTestPrintable;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.resource.Resources2;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.print.util.MediaUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ControlPrint {
    public static int NORMAL_PRINT = 0;
    public static int TEST_SINGLE = 1;
    public static int TEST_MULTI = 2;
    final KDPrinter printer;
    boolean isCancel = false;
    private JDialog printingPrompt;
    private JLabel promptPanel;
    private int pageCount;
    private PrintRequestAttributeSet attributeSet;

    public ControlPrint(KDPrinter ctrlprint) {
        this.printer = ctrlprint;
    }

    public void print(IPrintJob printJob) {
        if (!this.canPaint(printJob)) {
            this.printer.prompt(Resources.getMsg("prompt.nocontent"));
            return;
        }
        this.isCancel = false;
        this.doPrint(printJob, NORMAL_PRINT, 0);
    }

    public boolean checkPrintService(PrintService printService) {
        if (printService == null) {
            this.printer.prompt(Resources.getMsg("prompt.noprinter"));
            return true;
        }
        if (PropertyConfig.isUseOpenPrinterDll() && !MediaUtil.isPrinterCanUse(printService.getName())) {
            this.printer.prompt(Resources.getMsg("prompt.printer.error"));
            return true;
        }
        return false;
    }

    private DocPrintJob getKDPrintJob(PrintService service) {
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.bos.ctrl.print.win32.PrintJobFactory");
        }
        catch (ClassNotFoundException e) {
            cls = null;
        }
        if (cls == null) {
            return null;
        }
        Method mtd = null;
        try {
            mtd = cls.getMethod("createPrintJob", PrintService.class);
        }
        catch (SecurityException e) {
            mtd = null;
        }
        catch (NoSuchMethodException e) {
            mtd = null;
        }
        if (mtd != null) {
            try {
                return (DocPrintJob)mtd.invoke(null, service);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void doPrint(IPrintJob mulContent, int isTestPrint, int copies) {
        PrintRequestAttributeSet praset;
        PrintService printService = this.printer.getPrintService();
        if (this.checkPrintService(printService)) {
            return;
        }
        if (isTestPrint == NORMAL_PRINT) {
            this.printer.firePrintListener();
        }
        if (this.isCancel()) {
            this.updatePrintingPrompt(1, -1);
            return;
        }
        DocPrintJob docPrintJob = this.getDocPrintJob(printService);
        CtrlPrintable defPrintable = this.configDefaultPrintable(isTestPrint, copies);
        CtrlPageable pageable = new CtrlPageable(this.printer, mulContent);
        this.pageCount = isTestPrint != NORMAL_PRINT ? copies : mulContent.getPageCount();
        pageable.setNumberOfPages(this.pageCount);
        pageable.setDefaultPrintable(defPrintable);
        DocFlavor docFlavor = (DocFlavor)mulContent.getContentType();
        SimpleDoc doc = new SimpleDoc(pageable, docFlavor, null);
        this.attributeSet = praset = this.printer.getPrintConfig().buildPrintRequAttrSet();
        PageRangeReverse prr = (PageRangeReverse)praset.get(PageRangeReverse.class);
        if (prr != null && prr.isReverse()) {
            PageRanges nowRange = (PageRanges)praset.get(PageRanges.class);
            ArrayList printPage = KDPrinterUtils.getPrintPage(this.printer.getPrintJob().getPageCount(), nowRange);
            prr.setPrintPage(printPage);
        }
        this.callPrint(docPrintJob, doc, praset);
        this.showPrintingPrompt();
    }

    private DocPrintJob getDocPrintJob(PrintService printService) {
        DocPrintJob docPrintJob = null;
        String version = System.getProperty("java.version");
        boolean isNewVersion = false;
        if ("1.5.0".compareTo(version) <= 0) {
            isNewVersion = true;
        }
        String printerName = this.printer.getPrintConfig().getPrintService().getName();
        boolean enableAdjust = this.printer.getPrintConfig().getAdjustor().isEnableAdjust(printerName);
        if (enableAdjust && isNewVersion) {
            docPrintJob = this.getKDPrintJob(printService);
        }
        if (docPrintJob == null) {
            docPrintJob = printService.createPrintJob();
        }
        if (docPrintJob == null) {
            throw new NullPointerException("The Exception is thrown by the Print Framework, please try to print again. If the exceptoin happens a second time, please check if the Printer has been installed on your computer already.");
        }
        return docPrintJob;
    }

    private void callPrint(final DocPrintJob docPrintJob, final Doc doc, final PrintRequestAttributeSet praset) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    docPrintJob.print(doc, praset);
                    ControlPrint.this.updatePrintingPrompt(1, -1);
                    ControlPrint.this.printer.getPrintPreview().update();
                }
                catch (Throwable e) {
                    ControlPrint.this.updatePrintingPrompt(1, -1);
                    e.printStackTrace();
                    ControlPrint.this.printer.prompt(Resources2.getMsg("printer_interrupt"));
                }
                finally {
                    if (!ControlPrint.this.printer.getPrintPreview().isPreviewing() && ControlPrint.this.printer.isPrintComplete()) {
                        ControlPrint.this.printer.getPrintConfig().getModel().reset();
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    public void doPrintTest() {
        this.isCancel = false;
        this.doPrint(this.printer.getPrintJob(), TEST_SINGLE, 1);
    }

    public void doMultiPaperPrintTest(int copies) {
        this.isCancel = false;
        this.doPrint(this.printer.getPrintJob(), TEST_MULTI, copies);
    }

    protected boolean canPaint(IPrintJob printJob) {
        if (printJob == null) {
            return false;
        }
        return printJob.getTaskCount() > 0;
    }

    private CtrlPrintable configDefaultPrintable(int isTestPrint, int copies) {
        if (isTestPrint == NORMAL_PRINT) {
            return new CtrlPrintable(this, this.printer);
        }
        CtrlTestPrintable printable = new CtrlTestPrintable(this, this.printer);
        if (isTestPrint == TEST_MULTI) {
            printable.setTestType(CtrlTestPrintable.TEST_MULTI);
        }
        printable.setCopies(copies);
        return printable;
    }

    public static DocPrintJob createPrintJob(PrintService ps) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return ps.createPrintJob();
    }

    public Paper getPaper(int index) {
        Paper paper = this.printer.getPrintJob().getPaper(index);
        if (paper != null && this.printer.isDynamicPaper()) {
            KDPrinterUtils.adjustPaperBounds(paper);
        }
        return paper;
    }

    public KDPrinter getJob() {
        return this.printer;
    }

    private void showPrintingPrompt() {
        Component parent = null;
        parent = this.printer.getPrintPreview().isPreviewing() ? this.printer.getPrintPreview().getPreviewComponent() : this.printer.getParentWindow();
        Window temp = null;
        if (parent instanceof Window) {
            temp = (Window)parent;
        } else if (parent != null) {
            temp = SwingUtilities.getWindowAncestor(parent);
        }
        if (temp instanceof Frame) {
            this.printingPrompt = new KDDialog((Frame)temp, Resources.getMsg("dialog.printtitle"), true);
        } else if (temp instanceof Dialog) {
            this.printingPrompt = new KDDialog((Dialog)temp, Resources.getMsg("dialog.printtitle"), true);
        }
        if (this.printingPrompt != null) {
            this.printingPrompt.getContentPane().setLayout(null);
            this.promptPanel = new KDLabel(Resources.getMsg("prompt.printing"));
            this.promptPanel.setBounds(55, 10, 190, 20);
            this.printingPrompt.getContentPane().add(this.promptPanel);
            KDButton cancelButton = new KDButton(Resources.getMsg("button.cancel"));
            cancelButton.setBounds(95, 40, 40, 30);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPrint.this.cancel();
                }
            });
            this.printingPrompt.getContentPane().add((Component)cancelButton);
            this.printingPrompt.setSize(280, 130);
            CtrlSwingUtilities.centerWindow((Window)this.printingPrompt);
            this.printingPrompt.setVisible(true);
        }
    }

    public void updatePrintingPrompt(int res, int pageIndex) {
        if (this.printingPrompt != null && this.promptPanel != null) {
            if (res == 0) {
                String strpage = Resources.getMsg("label.strpage");
                this.promptPanel.setText(Resources.getMsg("prompt.printing") + Resources.getMsg("label.strdi") + (pageIndex + 1) + " " + strpage + " (" + Resources.getMsg("label.strtotal") + " " + this.pageCount + " " + strpage + ")");
                this.promptPanel.invalidate();
            } else if (this.printingPrompt != null) {
                this.printingPrompt.dispose();
                this.printingPrompt = null;
                this.promptPanel = null;
            }
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void cancel() {
        this.isCancel = true;
    }

    public Paper getTestPaper(boolean testType) {
        return this.printer.getPrintJob().getTestPaper(testType);
    }

    public PrintRequestAttributeSet getAttribute() {
        return this.attributeSet;
    }
}

