/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.extend;

import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.extendui.TablePrintSetupModel;
import com.kingdee.bos.ctrl.print.config.ui.IDialogActionListener;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupUI2;
import com.kingdee.bos.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.bos.ctrl.print.extend.IMultiPrintJobProvider;
import com.kingdee.bos.ctrl.print.extend.JobChangerListener;
import com.kingdee.bos.ctrl.print.printjob.AbstractPrintJob;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.resource.Resources;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class MultiPrintJobManager
implements IPrintActionListener,
JobChangerListener {
    IMultiPrintJobProvider jobProvider;
    KDPrinter printer;
    PrintConfigModel printmodel;
    String configName;
    String printSetupModeName = Resources.getMsg("tree.print");
    Class pageSetupUIClass;
    protected Class headfootUI;
    Map jobConfigMap;
    Map jobsMap;

    public MultiPrintJobManager(IMultiPrintJobProvider jobProvider) {
        this.jobProvider = jobProvider;
        this.jobProvider.setJobChangeListener(this);
        this.printmodel = jobProvider.createPrintConfigModel();
        this.configName = jobProvider.getPageSetupConfigName();
        this.pageSetupUIClass = jobProvider.getPageSetupUIClass();
        this.jobConfigMap = new HashMap();
        this.jobsMap = new HashMap();
        this.printer = new KDPrinter();
        this.printer.setParentWindow(jobProvider.getParentWindow());
        this.reset();
    }

    public void setParent(Component parent) {
        this.printer.setParentWindow(parent);
    }

    public void setPrintAllSheet(boolean isAll) {
        if (isAll) {
            ((TablePrintSetupModel)this.printmodel).setPrintContentType(1);
        } else {
            ((TablePrintSetupModel)this.printmodel).setPrintContentType(2);
        }
    }

    public void clear() {
        this.reset();
        this.jobConfigMap.clear();
        this.jobsMap.clear();
    }

    private void reset() {
        this.printer.clear();
        this.printer.setParentWindow(this.printer.getParentWindow());
        this.printer.unRegisterConfigUI(Resources.getMsg("tree.page"));
        this.printer.registerConfigUI(Resources.getMsg("tree.page"), PageSetupUI2.class, 0);
        if (this.headfootUI != null) {
            this.printer.unRegisterConfigUI(Resources.getMsg("tree.headerfooter"));
            this.printer.registerConfigUI(Resources.getMsg("tree.headerfooter"), this.headfootUI, 1);
        }
        this.printer.registerConfigUI(this.configName, this.jobProvider.getPageSetupUIClass(), 2);
        this.printer.setPrintPanel(this.jobProvider.getPrintSetupUIClass(), this.printmodel);
        this.printer.removePrintActionListener(this);
        this.printer.addPrintActionListener(this);
    }

    public void setHeadFootUI(Class ui) {
        this.headfootUI = ui;
        if (this.headfootUI != null) {
            this.printer.unRegisterConfigUI(Resources.getMsg("tree.headerfooter"));
            this.printer.registerConfigUI(Resources.getMsg("tree.headerfooter"), this.headfootUI, 1);
        }
    }

    public KDPrinter getPrinter() {
        return this.printer;
    }

    public int print() {
        return this.printer.print2();
    }

    public void printDirect() {
        this.printer.printDirect();
    }

    public void printPreview() {
        this.printer.printPreview();
    }

    public void pageDialog() {
        IPrintJob job = null;
        List selectJobs = this.jobProvider.getSelectJobs();
        if (selectJobs.size() > 0) {
            job = this.getPrintJob((String)selectJobs.get(0));
        }
        if (job instanceof AbstractPrintJob) {
            ((AbstractPrintJob)job).pageDialog(this.jobProvider.getParentWindow(), false, new IDialogActionListener(){

                @Override
                public void approve() {
                    IPrintJob job = null;
                    List selectJobs = MultiPrintJobManager.this.jobProvider.getSelectJobs();
                    if (selectJobs.size() > 0) {
                        job = MultiPrintJobManager.this.getPrintJob((String)selectJobs.get(0));
                    }
                    job.checkChange();
                    int length = selectJobs.size();
                    for (int i = 1; i < length; ++i) {
                        String jobname = (String)selectJobs.get(i);
                        IPrintJob tojob = (IPrintJob)MultiPrintJobManager.this.jobsMap.get(jobname);
                        if (tojob == null) {
                            tojob = MultiPrintJobManager.this.getPrintJob(jobname);
                        }
                        if (tojob == job) continue;
                        tojob.setPageConfig(job);
                    }
                }

                @Override
                public void preview() {
                    IPrintJob job = null;
                    List selectJobs = MultiPrintJobManager.this.jobProvider.getSelectJobs();
                    if (selectJobs.size() > 0) {
                        job = MultiPrintJobManager.this.getPrintJob((String)selectJobs.get(0));
                    }
                    job.getPrinter().getPrintConfig().getModel().reset();
                    int length = selectJobs.size();
                    for (int i = 1; i < length; ++i) {
                        String jobname = (String)selectJobs.get(i);
                        IPrintJob tojob = (IPrintJob)MultiPrintJobManager.this.jobsMap.get(jobname);
                        if (tojob == null) {
                            tojob = MultiPrintJobManager.this.getPrintJob(jobname);
                        }
                        if (tojob == job) continue;
                        tojob.setPageConfig(job);
                    }
                    MultiPrintJobManager.this.printPreview();
                }
            });
        } else {
            int status = job.pageDialog(this.jobProvider.getParentWindow(), false);
            if (status == 1 || status == 3) {
                int length = selectJobs.size();
                for (int i = 1; i < length; ++i) {
                    String jobname = (String)selectJobs.get(i);
                    IPrintJob tojob = (IPrintJob)this.jobsMap.get(jobname);
                    if (tojob == null) {
                        tojob = this.getPrintJob(jobname);
                    }
                    if (tojob == job) continue;
                    tojob.setPageConfig(job);
                }
                if (status == 3) {
                    this.printPreview();
                }
            }
        }
    }

    public IPrintJob getPrintJob(String jobname) {
        IPrintJob job = null;
        job = !this.jobsMap.containsKey(jobname) ? this.createPrintJob(jobname) : (IPrintJob)this.jobsMap.get(jobname);
        job.clear();
        IConfigModel model = this.getConfigModel(job.getID());
        job.setPrinter(this.getPrinter());
        job.setParent(this.getPrinter().getPrintJob());
        job.getConfig().setConfig(this.configName, model);
        job.getConfig().setConfig(this.printSetupModeName, this.printmodel);
        job.addBeforePaginationListener(this.jobProvider.getBeforePaginationListener());
        return job;
    }

    public void fromXmlElement(Element e) {
        if (e == null) {
            return;
        }
        this.createAllPrintJobs();
        this.printer.getPrintConfig().fromXmlElement(e);
    }

    public Element toXmlElement() {
        this.createPrintJobs();
        return this.printer.getPrintConfig().toXmlElement();
    }

    private IPrintJob createPrintJob(String jobname) {
        IPrintJob job = null;
        job = this.jobProvider.createPrintJob(jobname);
        if (job != null) {
            job.setPrinter(this.printer);
            job.setParent(this.getPrinter().getPrintJob());
            IConfigModel model = this.getConfigModel(job.getID());
            job.getConfig().setConfig(this.configName, model);
            this.jobProvider.createHeaderFooter(job, jobname);
            job.setVariantParser(this.jobProvider.getVariantParser(jobname));
            this.jobsMap.put(job.getID(), job);
        }
        return job;
    }

    private IConfigModel getConfigModel(String id) {
        IConfigModel model = null;
        if (this.jobConfigMap.containsKey(id)) {
            model = (IConfigModel)this.jobConfigMap.get(id);
        } else {
            model = this.jobProvider.createJobConfigModel();
            this.jobConfigMap.put(id, model);
        }
        return model;
    }

    public IConfigModel getTableSetupModel(String sheetID) {
        IConfigModel model = this.getPrinter().getPrintConfig().getJobConfig(sheetID).getConfig(this.configName);
        return model;
    }

    @Override
    public void beforePrintOrPreview() {
        this.createPrintJobs();
    }

    @Override
    public void beforePreview() {
    }

    public void createPrintJobs() {
        this.createPrintJobs2(false);
    }

    public void createPrintJobs2(boolean isall) {
        block4: {
            int printType;
            block3: {
                this.reset();
                int jobcount = this.jobProvider.getJobCount();
                printType = 2;
                if (this.printmodel instanceof TablePrintSetupModel) {
                    printType = ((TablePrintSetupModel)this.printmodel).getPrintContentType();
                }
                if (printType != 1) break block3;
                for (int i = 0; i < jobcount; ++i) {
                    String jobname = this.jobProvider.getJobName(i);
                    this.addJob(this.printer, jobname);
                }
                break block4;
            }
            if (printType != 2 && printType != 0) break block4;
            List list = null;
            list = isall ? this.jobProvider.getAllJobs() : this.jobProvider.getSelectJobs();
            int length = list.size();
            for (int i = 0; i < length; ++i) {
                String jobname = (String)list.get(i);
                this.addJob(this.printer, jobname);
            }
        }
    }

    public void createAllPrintJobs() {
        this.createPrintJobs2(true);
    }

    private void addJob(KDPrinter ctrlPrint, String jobname) {
        IPrintJob job = this.getPrintJob(jobname);
        ctrlPrint.addPrintJob(job);
    }

    @Override
    public void jobDeleted(String jobname) {
        this.jobConfigMap.remove(jobname);
        this.jobsMap.remove(jobname);
    }

    @Override
    public void jobRenamed(String oldName, String newName) {
        IPrintJob job;
        Object model = this.jobConfigMap.get(oldName);
        if (model != null) {
            this.jobConfigMap.remove(oldName);
            this.jobConfigMap.put(newName, model);
        }
        if ((job = (IPrintJob)this.jobsMap.get(oldName)) != null) {
            this.jobsMap.remove(oldName);
            this.jobsMap.put(newName, job);
            job.setID(newName);
        }
    }

    @Override
    public void jobDeletedAll() {
        this.jobConfigMap.clear();
        this.jobsMap.clear();
        this.reset();
    }

    @Override
    public void closePreview() {
    }

    @Override
    public void beforePrint() {
    }
}

