/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.io.AbstractExport;
import com.kingdee.bos.ctrl.print.io.KDFontMapper;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.xls.R1PrintV2XExporter;
import com.kingdee.bos.ctrl.print.xls.output.OutputHelper;
import com.kingdee.bos.ctrl.print.xls.widget.XlsPaper;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.server.ExportException;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsExport2OS
extends AbstractExport {
    private int _horIndetion = 10;
    private int _verIndetion = 5;
    private boolean _inValid = false;
    private OutputStream _os;
    private R1PrintV2XExporter _exporter = null;
    private OutputHelper _helper;
    private Workbook _wb;
    private Logger _log = LogUtil.getLogger(this.getClass());
    public static KDFontMapper DEFAULT_FONTMAPPER = new KDFontMapper();

    public XlsExport2OS(OutputStream out) {
        this._wb = new HSSFWorkbook();
        this._helper = new OutputHelper(this._wb);
        this._os = out;
    }

    @Override
    public void begin(String fileNamePre, KDPrinter printer) {
    }

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        if (this._inValid) {
            return;
        }
        try {
            this._exporter = new R1PrintV2XExporter();
        }
        catch (ExportException e) {
            this._log.error((Object)"\u521d\u59cb\u5316\u6587\u4ef6\u4e22\u5931", (Throwable)e);
        }
        XlsPaper node = (XlsPaper)this._exporter.translate(paper, null);
        this._helper.nextPaper(node, this._horIndetion, this._verIndetion);
    }

    @Override
    public void end() {
        if (this._inValid) {
            return;
        }
        try {
            this._helper.endOutput(this._horIndetion, this._verIndetion);
            this._wb.write(this._os);
            this._os.flush();
            this._os.close();
            this._wb = null;
            this._helper.clearStyleMap();
            this._log.info((Object)("\u5bfc\u51fa\u7ed3\u675f\u65f6\u95f4\uff1a" + System.currentTimeMillis() + "ms"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void export(String fileNamePre, KDPrinter printer) {
        printer.getPrintJob().getPageCount();
        super.export(fileNamePre, printer);
    }
}

