/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.preview;

import com.kingdee.bos.ctrl.common.editor.DefaultCellEditor;
import com.kingdee.bos.ctrl.common.editor.ICellEditor;
import com.kingdee.bos.ctrl.common.editor.ICellEditorListener;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.StyleDesigner;
import com.kingdee.bos.ctrl.print.preview.OnePaperUI;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.PainterCell;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class KDPEditManager
implements ICellEditorListener {
    public static final int EDIT_SUCCEED = 0;
    public static final int STOP_LAST_EDITOR_ERROR = 1;
    public static final int EDITOR_NOT_FOUND = 4;
    public static final int EDITOR_AUTO_CANCEL = 5;
    public static final int USER_CANCEL = 6;
    public static final int STOP_AND_NO_JUMP = 7;
    private OnePaperUI onePaperUI;
    private boolean editing = false;
    Point2D.Float position;
    PainterCell labelCell;
    ICellEditor editor;
    String oldValue;
    FocusListener editorFocusListener;
    KeyListener editorKeyListener;
    private boolean isAllowBlankCharacter = true;

    public KDPEditManager() {
    }

    public KDPEditManager(Paper paper) {
    }

    private boolean isEditing() {
        return this.editing;
    }

    private KDTextField getTextField() {
        KDTextField textField = new KDTextField();
        return textField;
    }

    public boolean selectCellAt(int x, int y, Object object) {
        this.onePaperUI.setSelectRect(null);
        this.labelCell = null;
        this.position = new Point2D.Float();
        this.labelCell = this.onePaperUI.getPainterByPosition(x, y, this.position);
        if (this.labelCell == null) {
            return false;
        }
        if (!this.labelCell.isEditable()) {
            return false;
        }
        this.updateSelectRect((int)((double)this.position.x + 0.5), (int)((double)this.position.y + 0.5));
        return true;
    }

    private void updateSelectRect(int x, int y) {
        Rectangle2D.Float rect = this.labelCell.getPainterBounds();
        int width = (int)((double)(rect.width - 1.0f) + 0.5);
        int height = (int)((double)(rect.height - 1.0f) + 0.5);
        Rectangle rece = new Rectangle(x, y, width, height);
        this.onePaperUI.setSelectRect(rece);
    }

    public void editCell(LabelCell editCell) {
        boolean isBlackWhite;
        if (editCell == null || !editCell.isEditable()) {
            return;
        }
        if (this.editor == null) {
            KDTextField textField = this.getTextField();
            DefaultCellEditor numberEditor = new DefaultCellEditor((JTextField)textField);
            this.editor = numberEditor;
        }
        String value = editCell.getText();
        this.editing = true;
        this.editor.addCellEditorListener((ICellEditorListener)this);
        this.oldValue = value;
        Component comp = this.editor.prepareComponent((Object)value, (Object)this.onePaperUI, editCell.getStyle(), null);
        if (editCell instanceof StyleCell && (isBlackWhite = ((StyleCell)editCell).isBlackWhite())) {
            comp.setBackground(null);
        }
        if (this.editor.isDisplayable()) {
            Rectangle2D.Float rect = editCell.getPainterBounds();
            rect.x = this.position.x + 1.0f;
            rect.y = this.position.y + 1.0f;
            rect.width -= 2.0f;
            rect.height -= 2.0f;
            int x = (int)((double)rect.x + 0.5);
            int y = (int)((double)rect.y + 0.5);
            int width = (int)((double)rect.width + 0.5);
            int height = (int)((double)rect.height + 0.5);
            this.editor.setBounds(x, y, width, height);
            this.onePaperUI.setLayout(null);
            this.onePaperUI.add(comp);
            comp.setFocusTraversalKeysEnabled(false);
            Component focusComp = this.editor.getFocusComponent();
            if (focusComp != null) {
                focusComp.requestFocusInWindow();
                focusComp.addFocusListener(this.getEditorFocusListener());
                focusComp.addKeyListener(this.getEditorKeyListener());
            }
            comp.validate();
            this.onePaperUI.repaint();
        } else {
            this.stopEditing();
        }
    }

    public void editCellAt(int xCoor, int yCoor, EventObject anEvent) {
        Point2D.Float position = new Point2D.Float();
        this.labelCell = this.onePaperUI.getPainterByPosition(xCoor, yCoor, position);
        if (this.labelCell instanceof LabelCell) {
            this.editCell((LabelCell)this.labelCell);
        } else if (this.labelCell instanceof ImageCell) {
            this.editImageCell((ImageCell)this.labelCell);
        }
    }

    public int editImageCell(ImageCell editCell) {
        String[] accepts = new String[]{"jpg", "jpeg", "gif", "png"};
        Image image = KDPrinterUtils.openImageFileChooser((JComponent)((Object)this.onePaperUI), accepts);
        if (image != null) {
            editCell.setImage(image);
            this.onePaperUI.getPreviewUI().setPageModified(true);
        }
        this.stopEditing();
        return 0;
    }

    public void editingStopped() {
    }

    public void editingCanceled() {
    }

    public void editingChanged() {
    }

    public int stopEditing() {
        if (this.isEditing()) {
            if (this.labelCell == null) {
                return 0;
            }
            if (this.labelCell instanceof LabelCell) {
                String s;
                LabelCell editCell = (LabelCell)this.labelCell;
                String oldValue = editCell.getText();
                Object newValue = this.editor.getValue();
                if (!this.isAllowBlankCharacter() && newValue != null && (s = newValue.toString().trim()).length() == 0) {
                    newValue = s;
                }
                this.editing = false;
                if (oldValue != null && newValue == null || oldValue == null && newValue == null || oldValue != null && newValue != null && !newValue.equals(oldValue)) {
                    this.onePaperUI.getPreviewUI().setPageModified(true);
                }
                this.commitValue(editCell, newValue);
                this.removeEditor();
                this.clearUp();
            }
        }
        this.clearUp();
        return 0;
    }

    public boolean isSelectCell() {
        return this.labelCell != null;
    }

    void closeEditor() {
        Component editComponent;
        if (this.stopEditing() == 6 && (editComponent = this.getEditorComponent()) != null) {
            editComponent.requestFocusInWindow();
        }
    }

    public Component getEditorComponent() {
        if (this.editor != null) {
            return this.editor.getComponent();
        }
        return null;
    }

    private void clearUp() {
        if (this.editor != null) {
            this.editor.removeCellEditorListener((ICellEditorListener)this);
            this.editor = null;
        }
        this.editing = false;
    }

    private void removeEditor() {
        Component comp = this.getEditorComponent();
        if (comp != null) {
            comp.removeFocusListener(this.getEditorFocusListener());
            comp.removeKeyListener(this.getEditorKeyListener());
            this.editor.releaseComponent();
            this.onePaperUI.remove(comp);
            this.onePaperUI.repaint();
        }
    }

    public FocusListener getEditorFocusListener() {
        if (this.editorFocusListener == null) {
            this.editorFocusListener = new EditorFocusListener();
        }
        return this.editorFocusListener;
    }

    public KeyListener getEditorKeyListener() {
        if (this.editorKeyListener == null) {
            this.editorKeyListener = new EditorKeyListener();
        }
        return this.editorKeyListener;
    }

    public boolean isAllowBlankCharacter() {
        return this.isAllowBlankCharacter;
    }

    public void setAllowBlankCharacter(boolean isAllow) {
        this.isAllowBlankCharacter = isAllow;
    }

    private void commitValue(LabelCell editCell, Object value) {
        if (value == null) {
            editCell.setText(null);
        } else {
            editCell.setText((String)value);
        }
    }

    public void cancelEditing() {
        if (this.isEditing()) {
            this.removeEditor();
            this.clearUp();
        }
    }

    public void setOnePaneUI(OnePaperUI onePaperUI) {
        this.onePaperUI = onePaperUI;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public void moveCell(int mx, int my) {
        Paper paper = this.onePaperUI.getPaper();
        Page canvas = paper.getBody();
        Point2D.Float location = canvas.getPainterLocation();
        float px = (float)mx - location.x;
        float py = (float)my - location.y;
        this.labelCell.setPainterLocation(px, py);
        if (this.labelCell.getParent() != canvas) {
            canvas.addPainter(this.labelCell);
        }
        this.updateSelectRect(mx, my);
    }

    public void resizeCell(Rectangle resizeRect) {
        this.moveCell(resizeRect.x, resizeRect.y);
        this.labelCell.setWidth(resizeRect.width);
        this.labelCell.setHeight(resizeRect.height);
        this.updateSelectRect(resizeRect.x, resizeRect.y);
    }

    public void deleteCell() {
        if (this.labelCell != null) {
            this.labelCell.getParent().removePainter(this.labelCell);
            this.labelCell = null;
            this.onePaperUI.setSelectRect(null);
        }
    }

    public void styleSetup(String title) {
        if (this.labelCell == null) {
            return;
        }
        Frame f = JOptionPane.getFrameForComponent((Component)((Object)this.onePaperUI));
        StyleDesigner sd = new StyleDesigner(f, true);
        int showPanel = 15;
        sd.setShowPanel(showPanel);
        sd.setSA(Styles.getSA((ShareStyleAttributes)this.labelCell.getStyle()));
        sd.setTitle(title);
        sd.setLocationRelativeTo(null);
        sd.show();
        if (sd.isChanged()) {
            this.labelCell.setStyle(Styles.getStyle((ShareStyleAttributes)sd.getSA()));
        }
        sd.dispose();
    }

    public void createNewTextCell(int x, int y) {
        Paper paper = this.onePaperUI.getPaper();
        Page canvas = paper.getBody();
        Point2D.Float location = canvas.getPainterLocation();
        float px = (float)x - location.x;
        float py = (float)y - location.y;
        StyleCell newCell = new StyleCell();
        newCell.setPainterBounds(px, py, 60.0f, 20.0f);
        this.labelCell = newCell;
        canvas.addPainter(this.labelCell);
        this.updateSelectRect(x, y);
        this.position = new Point2D.Float(x, y);
        this.editCell(newCell);
    }

    public void createImageCell(int x, int y) {
        Paper paper = this.onePaperUI.getPaper();
        this.labelCell = null;
        ImageCell newCell = new ImageCell();
        newCell.setStyle(Styles.getDefaultStyle());
        this.editImageCell(newCell);
        if (newCell.getImage() != null) {
            this.labelCell = newCell;
            this.position = new Point2D.Float(x, y);
            Page canvas = paper.getBody();
            Point2D.Float location = canvas.getPainterLocation();
            float px = (float)x - location.x;
            float py = (float)y - location.y;
            newCell.setPainterBounds(px, py, 60.0f, 60.0f);
            canvas.addPainter(this.labelCell);
            int width = newCell.getImage().getWidth(null);
            int height = newCell.getImage().getHeight(null);
            newCell.setWidth(width);
            newCell.setHeight(height);
            this.updateSelectRect(x, y);
        }
        this.onePaperUI.repaint();
    }

    class EditorKeyListener
    implements KeyListener {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 10) {
                KDPEditManager.this.closeEditor();
                KDPEditManager.this.onePaperUI.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class EditorFocusListener
    implements FocusListener {
        EditorFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            for (Component c = e.getOppositeComponent(); c != null; c = c.getParent()) {
                if (c == KDPEditManager.this.onePaperUI) {
                    return;
                }
                if (!(c instanceof Window) && (!(c instanceof Applet) || c.getParent() != null)) continue;
                if (c != SwingUtilities.getRoot((Component)((Object)KDPEditManager.this.onePaperUI))) break;
                KDPEditManager.this.closeEditor();
                break;
            }
        }
    }
}

