/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.view;

import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import com.kingdee.bos.ctrl.print.ui.component.TableCell;
import com.kingdee.bos.ctrl.print.ui.view.BasicPainterView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.Iterator;

public class TableCellView
extends BasicPainterView {
    protected static TableCellView tableUI = new TableCellView();

    public static BasicPainterView createPainterView() {
        return tableUI;
    }

    @Override
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        super.paint(g, painter, graInfo);
        TableCell tableCanvas = (TableCell)painter;
        int columnCount = tableCanvas.getcolumnCount();
        int rowCount = tableCanvas.getRowCount();
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        if (tableCanvas.isGrid()) {
            int i;
            x2 = x1 + tableCanvas.getWidth() - 1.0f;
            ((Graphics2D)g).draw(new Line2D.Float(x1, y1, x2, y1));
            for (i = 0; i < rowCount; ++i) {
                y1 = y1 + tableCanvas.getRowHeight(i) + 1.0f;
                ((Graphics2D)g).draw(new Line2D.Float(x1, y1, x2, y1));
            }
            x1 = 0.0f;
            y1 = 0.0f;
            x2 = 0.0f;
            y2 = 0.0f + tableCanvas.getHeight() - 1.0f;
            ((Graphics2D)g).draw(new Line2D.Float(x1, y1, x1, y2));
            for (i = 0; i < columnCount; ++i) {
                x1 = x1 + tableCanvas.getColumnWidth(i) + 1.0f;
                ((Graphics2D)g).draw(new Line2D.Float(x1, y1, x1, y2));
            }
            TableCell.Merges merges = tableCanvas.getMerges();
            Iterator iter = merges.iterator();
            Color backGround = tableCanvas.getBackGround();
            if (backGround == null) {
                backGround = Color.WHITE;
            }
            Color forceColor = g.getColor();
            g.setColor(backGround);
            while (iter.hasNext()) {
                float lineY1;
                float lineX1;
                TableCell.MergeBlock block = (TableCell.MergeBlock)iter.next();
                int row = block.getRow();
                int col = block.getCol();
                int row2 = block.getRow2();
                int col2 = block.getCol2();
                for (int iRow = row; iRow < row2; ++iRow) {
                    lineX1 = this.getColXPosition(tableCanvas, col) + 1.0f;
                    lineY1 = this.getRowYPosition(tableCanvas, iRow + 1);
                    float lineX2 = this.getColXPosition(tableCanvas, col2 + 1) - 1.0f;
                    ((Graphics2D)g).draw(new Line2D.Float(lineX1, lineY1, lineX2, lineY1));
                }
                for (int iCol = col; iCol < col2; ++iCol) {
                    lineX1 = this.getColXPosition(tableCanvas, iCol + 1);
                    lineY1 = this.getRowYPosition(tableCanvas, row) + 1.0f;
                    float lineY2 = this.getRowYPosition(tableCanvas, row2 + 1) - 1.0f;
                    ((Graphics2D)g).draw(new Line2D.Float(lineX1, lineY1, lineX1, lineY2));
                }
            }
            g.setColor(forceColor);
        }
        float childX = 1.0f;
        float childY = 1.0f;
        for (int i = 0; i < rowCount; ++i) {
            childX = 1.0f;
            float childHeight = tableCanvas.getRowHeight(i);
            for (int j = 0; j < columnCount; ++j) {
                float childWidth = tableCanvas.getColumnWidth(j);
                StyleCell cell = tableCanvas.getCell(i, j);
                if (cell != null) {
                    TableCell.MergeBlock block = tableCanvas.getMerge(i, j);
                    if (block == null) {
                        cell.setPainterBounds(childX, childY, childWidth, childHeight);
                    } else {
                        int row = block.getRow();
                        int col = block.getCol();
                        int row2 = block.getRow2();
                        int col2 = block.getCol2();
                        float lineX1 = this.getColXPosition(tableCanvas, col);
                        float lineY1 = this.getRowYPosition(tableCanvas, row);
                        float lineX2 = this.getColXPosition(tableCanvas, col2 + 1);
                        float lineY2 = this.getRowYPosition(tableCanvas, row2 + 1);
                        cell.setPainterBounds(lineX1 + 1.0f, lineY1 + 1.0f, lineX2 - lineX1 - 1.0f, lineY2 - lineY1 - 1.0f);
                    }
                    painter.addPainter(cell);
                }
                childX = childX + tableCanvas.getColumnWidth(j) + 1.0f;
            }
            childY = childY + tableCanvas.getRowHeight(i) + 1.0f;
        }
    }

    private float getRowYPosition(TableCell table, int rowIndex) {
        float rowY = 0.0f;
        for (int i = 0; i < rowIndex; ++i) {
            rowY = rowY + table.getRowHeight(i) + 1.0f;
        }
        return rowY;
    }

    private float getColXPosition(TableCell table, int colIndex) {
        float colX = 0.0f;
        for (int i = 0; i < colIndex; ++i) {
            colX = colX + table.getColumnWidth(i) + 1.0f;
        }
        return colX;
    }
}

