/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.xls;

import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.xls.R1PrintV2XExporter;
import com.kingdee.bos.ctrl.print.xls.widget.IXlsNode;
import java.util.List;

public abstract class AR1PNode_V2X {
    private R1PrintV2XExporter _exporter;
    private IPainter _node;

    public void setExporter(R1PrintV2XExporter exporter) {
        this._exporter = exporter;
    }

    public R1PrintV2XExporter getExporter() {
        return this._exporter;
    }

    public void setNode(IPainter node) {
        this._node = node;
    }

    public IPainter getNode() {
        return this._node;
    }

    public IXlsNode export(IXlsNode parent) {
        IXlsNode xlsObj = this.createXlsNode();
        xlsObj.setParent(parent);
        this.exportCommon(this.getNode(), xlsObj);
        this.exportSpecial(this.getNode(), xlsObj);
        return xlsObj;
    }

    private void exportCommon(IPainter painter, IXlsNode xlsObj) {
        xlsObj.setBounds(painter.getX(), painter.getY(), painter.getWidth(), painter.getHeight());
        xlsObj.setStyle(painter.getStyle());
        xlsObj.setBackGround(painter.getBackGround());
        xlsObj.setLayer(painter.getLayer());
        xlsObj.setId(painter.getPainterKey());
    }

    protected void exportChildren(IPainter painter, IXlsNode xlsObj) {
        List children = painter.getAllPainter();
        if (children != null) {
            for (IPainter child : children) {
                if (child instanceof Canvas && ((Canvas)child).getAllPainter() != null && ((Canvas)child).getAllPainter().isEmpty()) {
                    LabelCell cell = new LabelCell();
                    cell.setStyle(child.getStyle());
                    cell.setPainterBounds(child.getX(), child.getY(), child.getWidth(), child.getHeight());
                    cell.setLayer(50);
                    cell.setParent(child);
                    xlsObj.addNode(this.getExporter().translate(cell, xlsObj));
                    continue;
                }
                IXlsNode node = this.getExporter().translate(child, xlsObj);
                if (child instanceof Canvas && child.getParent() instanceof Page) continue;
                xlsObj.addNode(node);
            }
        }
    }

    protected abstract void exportSpecial(IPainter var1, IXlsNode var2);

    protected abstract IXlsNode createXlsNode();
}

