/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.modal;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.kdf.expr.Parser;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParamUtil {
    public static final String SPLIT_TEXT = "@";
    public static final char SPLIT_CHAR = "@".charAt(0);
    public static final String ARG_CONTEXT = "CONTEXT";
    public static final String ARG_FIELDS = "FIELDS";
    public static final String ARG_FILTER = "FILTER";
    public static final String ARG_ORDER = "ORDER";

    public static String makeKey(String name, String ns) {
        return name + SPLIT_TEXT + ns;
    }

    public static String getSuffix(String key) {
        int m = key.indexOf(SPLIT_CHAR);
        return m != -1 ? key.substring(m) : null;
    }

    public static void mergeParameters(List out, List in, String ns) {
        if (out == null || in == null) {
            return;
        }
        int z = in.size();
        for (int i = 0; i < z; ++i) {
            Parameter p = (Parameter)in.get(i);
            p.setName(ns != null ? ParamUtil.makeKey(p.getName(), ns) : p.getName());
            out.add(p);
        }
    }

    public static HashMap makeDefaultArgs(List ps) {
        if (ps == null) {
            return null;
        }
        HashMap<String, String> args = new HashMap<String, String>();
        int z = ps.size();
        for (int i = 0; i < z; ++i) {
            Parameter p = (Parameter)ps.get(i);
            args.put(p.getName(), p.getDefaultValue());
        }
        return args;
    }

    public static HashMap makeDefaultArgs2(List ps) {
        if (ps == null) {
            return null;
        }
        HashMap<String, String> args = new HashMap<String, String>();
        int z = ps.size();
        for (int i = 0; i < z; ++i) {
            Parameter p = (Parameter)ps.get(i);
            String defaultValue = p.getDefaultValue();
            if (defaultValue == null) {
                if (p.getDataType() == DataType.STRING) {
                    defaultValue = "";
                } else if (DataType.isNumberType((DataType)p.getDataType())) {
                    defaultValue = "0";
                } else if (p.getDataType() == DataType.DATETIME) {
                    defaultValue = "1979-08-08";
                }
            }
            args.put(p.getName(), defaultValue);
        }
        return args;
    }

    public static void mergeArgs(Map out, String ns, Map in) {
        if (ns == null) {
            MapUtil.add((Map)out, (Map)in);
        } else {
            MapUtil.addKeySuffix((Map)in, (String)(SPLIT_CHAR + ns), (Map)out);
        }
    }

    public static HashMap splitArgs(Map in) {
        HashMap out = new HashMap();
        if (in != null) {
            for (Map.Entry ent : in.entrySet()) {
                HashMap nsArgs;
                String key = (String)ent.getKey();
                String ns = null;
                int m = key.indexOf(SPLIT_CHAR);
                if (m != -1) {
                    ns = key.substring(m + 1);
                    key = key.substring(0, m);
                }
                if ((nsArgs = (HashMap)out.get(ns)) == null) {
                    nsArgs = new HashMap();
                    out.put(ns, nsArgs);
                }
                nsArgs.put(key, ent.getValue());
            }
        }
        return out;
    }

    public static int indexOfParameter(List ps, String name) {
        if (ps == null || name == null) {
            return -1;
        }
        int z = ps.size();
        for (int i = 0; i < z; ++i) {
            Parameter p = (Parameter)ps.get(i);
            if (!name.equals(p.getName())) continue;
            return i;
        }
        return -1;
    }

    public static Parameter getParameter(List ps, String name) {
        int i = ParamUtil.indexOfParameter(ps, name);
        return i != -1 ? (Parameter)ps.get(i) : null;
    }

    public static void makeExecArgs(HashMap execArgs, HashMap args) {
        if (args == null || execArgs == null) {
            return;
        }
        for (Map.Entry ent : execArgs.entrySet()) {
            String expr;
            Object execVal = ent.getValue();
            if (!(execVal instanceof String) || (expr = (String)execVal).length() <= 1 || SPLIT_CHAR != expr.charAt(0)) continue;
            String argKey = expr.substring(1);
            ent.setValue(args.get(argKey));
        }
    }

    public static String makeArgName(String name, Class cls) {
        return name + SPLIT_TEXT + cls.getName();
    }

    public static HashMap parseArgsScript(Map argsWithScript, Parser psr) {
        HashMap args = new HashMap();
        if (argsWithScript != null) {
            for (Map.Entry ent : argsWithScript.entrySet()) {
                String val = (String)ent.getValue();
                if (val.startsWith("@=")) {
                    psr.prepare(null, val.substring(2));
                    Variant var = psr.parse();
                    if (var.getVt() != 16) {
                        val = var.toString();
                    }
                }
                args.put(ent.getKey(), val);
            }
        }
        return args;
    }

    public static List params2MetaFields(Parameter[] ps) {
        ArrayList<MetaField> mfs = new ArrayList<MetaField>(ps.length);
        for (int i = 0; i < ps.length; ++i) {
            mfs.add(ParamUtil.param2MetaField(ps[i]));
        }
        return mfs;
    }

    public static List params2MetaFields(List ps) {
        int z = ps.size();
        ArrayList<MetaField> mfs = new ArrayList<MetaField>(z);
        for (int i = 0; i < z; ++i) {
            mfs.add(ParamUtil.param2MetaField((Parameter)ps.get(i)));
        }
        return mfs;
    }

    public static MetaField param2MetaField(Parameter p) {
        MetaField mf = new MetaField();
        mf.copy((IDefObj)p);
        mf.setType(p.getDataType());
        return mf;
    }

    public static List fullCopyParameters(List ps) {
        ArrayList<Parameter> newPs = new ArrayList<Parameter>();
        for (int i = 0; i < ps.size(); ++i) {
            Parameter p = new Parameter();
            p.copy((Parameter)ps.get(i));
            newPs.add(p);
        }
        return newPs;
    }

    public static boolean isDataViewParam(Parameter p) {
        return p != null && "true".equals(p.getProperty(Parameter.P_isDataView.getName())) && p.getDataType().equals(DataType.STRING);
    }

    public static void setAsDataViewParameter(Parameter p, String source) {
        p.setProperty(Parameter.P_isDataView.getName(), (Object)"true");
        p.setProperty(Parameter.P_dataURI.getName(), (Object)source);
        p.setDataType(DataType.STRING);
    }

    public static boolean tryResetDataViewURI(Parameter p, String source) {
        String dataURI;
        if (ParamUtil.isDataViewParam(p) && (dataURI = (String)p.getProperty(Parameter.P_dataURI.getName())) == null) {
            p.setProperty(Parameter.P_dataURI.getName(), (Object)source);
            return true;
        }
        return false;
    }

    public static List getNullParameters(List ps, Map args) {
        if (args == null) {
            return ps;
        }
        ArrayList<Parameter> psNull = null;
        int z = ps.size();
        for (int i = 0; i < z; ++i) {
            Object argVal;
            Parameter p = (Parameter)ps.get(i);
            if (p.isAllowNull() || (!((argVal = args.get(p.getName())) instanceof String) ? argVal != null : ((String)argVal).length() > 0)) continue;
            if (psNull == null) {
                psNull = new ArrayList<Parameter>();
            }
            psNull.add(p);
        }
        return psNull;
    }

    public static final Parameter getMainDataView(List ps) {
        Parameter mainP = null;
        int z = ps.size();
        for (int i = 0; i < z; ++i) {
            Parameter p = (Parameter)ps.get(i);
            if (!"true".equals(p.getProperty(Parameter.P_isDataView.getName())) || StringUtil.isEmptyString((String)((String)p.getProperty(Parameter.P_dataURI.getName())))) continue;
            if ("true".equals(p.getProperty(Parameter.P_isMainData.getName()))) {
                mainP = p;
                break;
            }
            if (mainP != null) continue;
            mainP = p;
        }
        return mainP;
    }
}

