/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset;

import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WrappedResultSet
implements ResultSet {
    private ResultSet resultSet;
    private int[] columnsMap;
    private String[] usedColumns;
    private HashMap columnNamesMap;
    private ResultSetMetaData metaData;

    public static final WrappedResultSet resetMetaData(ResultSet rs, List columnList, Locale locale) throws SQLException {
        if (rs instanceof WrappedResultSet) {
            HashMap<String, Column> column_map = new HashMap<String, Column>();
            for (int i = 0; i < columnList.size(); ++i) {
                Column c = (Column)((Object)columnList.get(i));
                column_map.put(c.getName().toLowerCase(), c);
            }
            SimpleResultSetMetaData meta = ((WrappedResultSet)rs).getMetaDataEx();
            int count = meta.getColumnCount();
            for (int i = 0; i < count; ++i) {
                Column c = (Column)((Object)column_map.get(meta.getColumnName(i + 1).toLowerCase()));
                if (c == null) continue;
                String alias = locale == null ? c.getAlias() : c.getAlias(locale);
                meta.setColumnLabel(i + 1, alias == null ? c.getName() : alias);
            }
            return (WrappedResultSet)rs;
        }
        ResultSetMetaData meta = rs.getMetaData();
        String[] columns = new String[meta.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = meta.getColumnName(i + 1);
        }
        return WrappedResultSet.resetMetaData(WrappedResultSet.wrap(rs, columns), columnList, locale);
    }

    public static WrappedResultSet wrap(ResultSet rs, String[] usedColumns) throws SQLException {
        return new WrappedResultSet(rs, usedColumns);
    }

    private WrappedResultSet(ResultSet rs, String[] usedColumns) throws SQLException {
        this.resultSet = rs;
        if (usedColumns != null) {
            this.usedColumns = usedColumns;
            this.columnNamesMap = new HashMap();
            this.columnsMap = new int[usedColumns.length];
            SimpleResultSetMetaData meta = new SimpleResultSetMetaData();
            this.metaData = rs.getMetaData();
            for (int i = 0; i < this.columnsMap.length; ++i) {
                this.columnsMap[i] = rs.findColumn(usedColumns[i]);
                String name = this.metaData.getColumnName(this.columnsMap[i]);
                this.columnNamesMap.put(name.toLowerCase(), name);
                meta.addColumn(i + 1, name, this.metaData.getColumnType(this.columnsMap[i]));
                meta.setColumnLabel(i + 1, this.metaData.getColumnLabel(this.columnsMap[i]));
            }
            this.metaData = meta;
        }
    }

    public final ResultSet getResultSet() {
        return this.resultSet;
    }

    private int getRealColumn(int col) throws SQLException {
        if (this.columnsMap == null) {
            return col;
        }
        if (col < 1 || col > this.columnsMap.length) {
            throw new SQLException("Bad column index:" + col);
        }
        return this.columnsMap[col - 1];
    }

    private String getRealColumn(String col) throws SQLException {
        if (this.columnNamesMap == null) {
            return col;
        }
        Object name = this.columnNamesMap.get(col.toLowerCase());
        if (name == null) {
            throw new SQLException("Couldn't find column '" + col + "'");
        }
        return (String)name;
    }

    public SimpleResultSetMetaData getMetaDataEx() throws SQLException {
        return (SimpleResultSetMetaData)this.getMetaData();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.columnsMap != null ? this.metaData : this.resultSet.getMetaData();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.resultSet.absolute(row);
    }

    @Override
    public void afterLast() throws SQLException {
        this.resultSet.afterLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.resultSet.beforeFirst();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.resultSet.close();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
    }

    @Override
    public int findColumn(String col) throws SQLException {
        if (this.usedColumns != null) {
            for (int i = 0; i < this.usedColumns.length; ++i) {
                if (!this.usedColumns[i].equalsIgnoreCase(col)) continue;
                return i + 1;
            }
        }
        return this.resultSet.findColumn(this.getRealColumn(col));
    }

    @Override
    public boolean first() throws SQLException {
        return this.resultSet.first();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.resultSet.getArray(this.getRealColumn(i));
    }

    @Override
    public Array getArray(String col) throws SQLException {
        return this.resultSet.getArray(this.getRealColumn(col));
    }

    @Override
    public InputStream getAsciiStream(int col) throws SQLException {
        return this.resultSet.getAsciiStream(this.getRealColumn(col));
    }

    @Override
    public InputStream getAsciiStream(String col) throws SQLException {
        return this.resultSet.getAsciiStream(this.getRealColumn(col));
    }

    @Override
    public BigDecimal getBigDecimal(int col, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(this.getRealColumn(col), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int col) throws SQLException {
        return this.resultSet.getBigDecimal(this.getRealColumn(col));
    }

    @Override
    public BigDecimal getBigDecimal(String col, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(this.getRealColumn(col), scale);
    }

    @Override
    public BigDecimal getBigDecimal(String col) throws SQLException {
        return this.resultSet.getBigDecimal(this.getRealColumn(col));
    }

    @Override
    public InputStream getBinaryStream(int col) throws SQLException {
        return this.resultSet.getBinaryStream(this.getRealColumn(col));
    }

    @Override
    public InputStream getBinaryStream(String col) throws SQLException {
        return this.resultSet.getBinaryStream(this.getRealColumn(col));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return this.resultSet.getBlob(this.getRealColumn(i));
    }

    @Override
    public Blob getBlob(String col) throws SQLException {
        return this.resultSet.getBlob(this.getRealColumn(col));
    }

    @Override
    public boolean getBoolean(int col) throws SQLException {
        return this.resultSet.getBoolean(this.getRealColumn(col));
    }

    @Override
    public boolean getBoolean(String col) throws SQLException {
        return this.resultSet.getBoolean(this.getRealColumn(col));
    }

    @Override
    public byte getByte(int col) throws SQLException {
        return this.resultSet.getByte(this.getRealColumn(col));
    }

    @Override
    public byte getByte(String col) throws SQLException {
        return this.resultSet.getByte(this.getRealColumn(col));
    }

    @Override
    public byte[] getBytes(int col) throws SQLException {
        return this.resultSet.getBytes(this.getRealColumn(col));
    }

    @Override
    public byte[] getBytes(String col) throws SQLException {
        return this.resultSet.getBytes(this.getRealColumn(col));
    }

    @Override
    public Reader getCharacterStream(int col) throws SQLException {
        return this.resultSet.getCharacterStream(this.getRealColumn(col));
    }

    @Override
    public Reader getCharacterStream(String col) throws SQLException {
        return this.resultSet.getCharacterStream(this.getRealColumn(col));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.resultSet.getClob(this.getRealColumn(i));
    }

    @Override
    public Clob getClob(String col) throws SQLException {
        return this.resultSet.getClob(this.getRealColumn(col));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    @Override
    public Date getDate(int col, Calendar cal) throws SQLException {
        return this.resultSet.getDate(this.getRealColumn(col), cal);
    }

    @Override
    public Date getDate(int col) throws SQLException {
        return this.resultSet.getDate(this.getRealColumn(col));
    }

    @Override
    public Date getDate(String col, Calendar cal) throws SQLException {
        return this.resultSet.getDate(this.getRealColumn(col), cal);
    }

    @Override
    public Date getDate(String col) throws SQLException {
        return this.resultSet.getDate(this.getRealColumn(col));
    }

    @Override
    public double getDouble(int col) throws SQLException {
        return this.resultSet.getDouble(this.getRealColumn(col));
    }

    @Override
    public double getDouble(String col) throws SQLException {
        return this.resultSet.getDouble(this.getRealColumn(col));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    @Override
    public float getFloat(int col) throws SQLException {
        return this.resultSet.getFloat(this.getRealColumn(col));
    }

    @Override
    public float getFloat(String col) throws SQLException {
        return this.resultSet.getFloat(this.getRealColumn(col));
    }

    @Override
    public int getInt(int col) throws SQLException {
        return this.resultSet.getInt(this.getRealColumn(col));
    }

    @Override
    public int getInt(String col) throws SQLException {
        return this.resultSet.getInt(this.getRealColumn(col));
    }

    @Override
    public long getLong(int col) throws SQLException {
        return this.resultSet.getLong(this.getRealColumn(col));
    }

    @Override
    public long getLong(String col) throws SQLException {
        return this.resultSet.getLong(this.getRealColumn(col));
    }

    @Override
    public Object getObject(int col) throws SQLException {
        return this.resultSet.getObject(this.getRealColumn(col));
    }

    @Override
    public Object getObject(String col) throws SQLException {
        return this.resultSet.getObject(this.getRealColumn(col));
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.resultSet.getRef(this.getRealColumn(i));
    }

    @Override
    public Ref getRef(String col) throws SQLException {
        return this.resultSet.getRef(this.getRealColumn(col));
    }

    @Override
    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    @Override
    public short getShort(int col) throws SQLException {
        return this.resultSet.getShort(this.getRealColumn(col));
    }

    @Override
    public short getShort(String col) throws SQLException {
        return this.resultSet.getShort(this.getRealColumn(col));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    @Override
    public String getString(int col) throws SQLException {
        return this.resultSet.getString(this.getRealColumn(col));
    }

    @Override
    public String getString(String col) throws SQLException {
        return this.resultSet.getString(this.getRealColumn(col));
    }

    @Override
    public Time getTime(int col, Calendar cal) throws SQLException {
        return this.resultSet.getTime(this.getRealColumn(col), cal);
    }

    @Override
    public Time getTime(int col) throws SQLException {
        return this.resultSet.getTime(this.getRealColumn(col));
    }

    @Override
    public Time getTime(String col, Calendar cal) throws SQLException {
        return this.resultSet.getTime(this.getRealColumn(col), cal);
    }

    @Override
    public Time getTime(String col) throws SQLException {
        return this.resultSet.getTime(this.getRealColumn(col));
    }

    @Override
    public Timestamp getTimestamp(int col, Calendar cal) throws SQLException {
        return this.resultSet.getTimestamp(this.getRealColumn(col), cal);
    }

    @Override
    public Timestamp getTimestamp(int col) throws SQLException {
        return this.resultSet.getTimestamp(this.getRealColumn(col));
    }

    @Override
    public Timestamp getTimestamp(String col, Calendar cal) throws SQLException {
        return this.resultSet.getTimestamp(this.getRealColumn(col), cal);
    }

    @Override
    public Timestamp getTimestamp(String col) throws SQLException {
        return this.resultSet.getTimestamp(this.getRealColumn(col));
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSet.getType();
    }

    @Override
    public InputStream getUnicodeStream(int col) throws SQLException {
        return this.resultSet.getUnicodeStream(this.getRealColumn(col));
    }

    @Override
    public InputStream getUnicodeStream(String col) throws SQLException {
        return this.resultSet.getUnicodeStream(this.getRealColumn(col));
    }

    @Override
    public URL getURL(int col) throws SQLException {
        return this.resultSet.getURL(this.getRealColumn(col));
    }

    @Override
    public URL getURL(String col) throws SQLException {
        return this.resultSet.getURL(this.getRealColumn(col));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    @Override
    public void insertRow() throws SQLException {
        this.resultSet.insertRow();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    @Override
    public boolean last() throws SQLException {
        return this.resultSet.last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    @Override
    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    @Override
    public boolean previous() throws SQLException {
        return this.resultSet.previous();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.resultSet.relative(rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.resultSet.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.resultSet.setFetchSize(rows);
    }

    @Override
    public void updateArray(int col, Array x) throws SQLException {
        this.resultSet.updateArray(this.getRealColumn(col), x);
    }

    @Override
    public void updateArray(String col, Array x) throws SQLException {
        this.resultSet.updateArray(this.getRealColumn(col), x);
    }

    @Override
    public void updateAsciiStream(int col, InputStream x, int length) throws SQLException {
        this.resultSet.updateAsciiStream(this.getRealColumn(col), x, length);
    }

    @Override
    public void updateAsciiStream(String col, InputStream x, int length) throws SQLException {
        this.resultSet.updateAsciiStream(this.getRealColumn(col), x, length);
    }

    @Override
    public void updateBigDecimal(int col, BigDecimal x) throws SQLException {
        this.resultSet.updateBigDecimal(this.getRealColumn(col), x);
    }

    @Override
    public void updateBigDecimal(String col, BigDecimal x) throws SQLException {
        this.resultSet.updateBigDecimal(this.getRealColumn(col), x);
    }

    @Override
    public void updateBinaryStream(int col, InputStream x, int length) throws SQLException {
        this.resultSet.updateBinaryStream(this.getRealColumn(col), x, length);
    }

    @Override
    public void updateBinaryStream(String col, InputStream x, int length) throws SQLException {
        this.resultSet.updateBinaryStream(this.getRealColumn(col), x, length);
    }

    @Override
    public void updateBlob(int col, Blob x) throws SQLException {
        this.resultSet.updateBlob(this.getRealColumn(col), x);
    }

    @Override
    public void updateBlob(String col, Blob x) throws SQLException {
        this.resultSet.updateBlob(this.getRealColumn(col), x);
    }

    @Override
    public void updateBoolean(int col, boolean x) throws SQLException {
        this.resultSet.updateBoolean(this.getRealColumn(col), x);
    }

    @Override
    public void updateBoolean(String col, boolean x) throws SQLException {
        this.resultSet.updateBoolean(this.getRealColumn(col), x);
    }

    @Override
    public void updateByte(int col, byte x) throws SQLException {
        this.resultSet.updateByte(this.getRealColumn(col), x);
    }

    @Override
    public void updateByte(String col, byte x) throws SQLException {
        this.resultSet.updateByte(this.getRealColumn(col), x);
    }

    @Override
    public void updateBytes(int col, byte[] x) throws SQLException {
        this.resultSet.updateBytes(this.getRealColumn(col), x);
    }

    @Override
    public void updateBytes(String col, byte[] x) throws SQLException {
        this.resultSet.updateBytes(this.getRealColumn(col), x);
    }

    @Override
    public void updateCharacterStream(int col, Reader x, int length) throws SQLException {
        this.resultSet.updateCharacterStream(this.getRealColumn(col), x, length);
    }

    @Override
    public void updateCharacterStream(String col, Reader reader, int length) throws SQLException {
        this.resultSet.updateCharacterStream(this.getRealColumn(col), reader, length);
    }

    @Override
    public void updateClob(int col, Clob x) throws SQLException {
        this.resultSet.updateClob(this.getRealColumn(col), x);
    }

    @Override
    public void updateClob(String col, Clob x) throws SQLException {
        this.resultSet.updateClob(this.getRealColumn(col), x);
    }

    @Override
    public void updateDate(int col, Date x) throws SQLException {
        this.resultSet.updateDate(this.getRealColumn(col), x);
    }

    @Override
    public void updateDate(String col, Date x) throws SQLException {
        this.resultSet.updateDate(this.getRealColumn(col), x);
    }

    @Override
    public void updateDouble(int col, double x) throws SQLException {
        this.resultSet.updateDouble(this.getRealColumn(col), x);
    }

    @Override
    public void updateDouble(String col, double x) throws SQLException {
        this.resultSet.updateDouble(this.getRealColumn(col), x);
    }

    @Override
    public void updateFloat(int col, float x) throws SQLException {
        this.resultSet.updateFloat(this.getRealColumn(col), x);
    }

    @Override
    public void updateFloat(String col, float x) throws SQLException {
        this.resultSet.updateFloat(this.getRealColumn(col), x);
    }

    @Override
    public void updateInt(int col, int x) throws SQLException {
        this.resultSet.updateInt(this.getRealColumn(col), x);
    }

    @Override
    public void updateInt(String col, int x) throws SQLException {
        this.resultSet.updateInt(this.getRealColumn(col), x);
    }

    @Override
    public void updateLong(int col, long x) throws SQLException {
        this.resultSet.updateLong(this.getRealColumn(col), x);
    }

    @Override
    public void updateLong(String col, long x) throws SQLException {
        this.resultSet.updateLong(this.getRealColumn(col), x);
    }

    @Override
    public void updateNull(int col) throws SQLException {
        this.resultSet.updateNull(this.getRealColumn(col));
    }

    @Override
    public void updateNull(String col) throws SQLException {
        this.resultSet.updateNull(this.getRealColumn(col));
    }

    @Override
    public void updateObject(int col, Object x, int scale) throws SQLException {
        this.resultSet.updateObject(this.getRealColumn(col), x, scale);
    }

    @Override
    public void updateObject(int col, Object x) throws SQLException {
        this.resultSet.updateObject(this.getRealColumn(col), x);
    }

    @Override
    public void updateObject(String col, Object x, int scale) throws SQLException {
        this.resultSet.updateObject(this.getRealColumn(col), x, scale);
    }

    @Override
    public void updateObject(String col, Object x) throws SQLException {
        this.resultSet.updateObject(this.getRealColumn(col), x);
    }

    @Override
    public void updateRef(int col, Ref x) throws SQLException {
        this.resultSet.updateRef(this.getRealColumn(col), x);
    }

    @Override
    public void updateRef(String col, Ref x) throws SQLException {
        this.resultSet.updateRef(this.getRealColumn(col), x);
    }

    @Override
    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
    }

    @Override
    public void updateShort(int col, short x) throws SQLException {
        this.resultSet.updateShort(this.getRealColumn(col), x);
    }

    @Override
    public void updateShort(String col, short x) throws SQLException {
        this.resultSet.updateShort(this.getRealColumn(col), x);
    }

    @Override
    public void updateString(int col, String x) throws SQLException {
        this.resultSet.updateString(this.getRealColumn(col), x);
    }

    @Override
    public void updateString(String col, String x) throws SQLException {
        this.resultSet.updateString(this.getRealColumn(col), x);
    }

    @Override
    public void updateTime(int col, Time x) throws SQLException {
        this.resultSet.updateTime(this.getRealColumn(col), x);
    }

    @Override
    public void updateTime(String col, Time x) throws SQLException {
        this.resultSet.updateTime(this.getRealColumn(col), x);
    }

    @Override
    public void updateTimestamp(int col, Timestamp x) throws SQLException {
        this.resultSet.updateTimestamp(this.getRealColumn(col), x);
    }

    @Override
    public void updateTimestamp(String col, Timestamp x) throws SQLException {
        this.resultSet.updateTimestamp(this.getRealColumn(col), x);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        return null;
    }

    public Object getObject(String columnLabel, Map map) throws SQLException {
        return null;
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        return null;
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        return null;
    }

    public Object unwrap(Class iface) throws SQLException {
        return null;
    }
}

