/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.rowset;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.DataType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class SqlUtil {
    public static StringBuffer makePSql_Insert(ResultSetMetaData meta, String tableName) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(tableName).append(" VALUES(");
        int cols = meta.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            sb.append("?");
            if (i != cols - 1) {
                sb.append(",");
                continue;
            }
            sb.append(")");
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeTable(ResultSet data, String tableName, String[] pks, Connection conn) throws SQLException {
        String sql = SqlUtil.makeSql_createTable(data.getMetaData(), tableName, pks);
        Statement stmt = conn.createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)stmt);
        }
        SqlUtil.fillTable(data, tableName, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillTable(ResultSet data, String tableName, Connection conn) throws SQLException {
        ResultSetMetaData meta = data.getMetaData();
        int cols = meta.getColumnCount();
        StringBuffer sb = SqlUtil.makePSql_Insert(meta, tableName);
        PreparedStatement pstmt = conn.prepareStatement(sb.toString());
        try {
            boolean hasData = false;
            while (data.next()) {
                hasData = true;
                for (int col = 1; col <= cols; ++col) {
                    pstmt.setObject(col, data.getObject(col));
                }
                pstmt.addBatch();
            }
            if (hasData) {
                pstmt.executeBatch();
            }
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)pstmt);
        }
    }

    public static String makeSql_createTable(ResultSetMetaData meta, String tableName, String[] pks) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ");
        sb.append(tableName);
        sb.append(" (");
        int cols = meta.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String column = meta.getColumnName(i);
            int jdbcType = meta.getColumnType(i);
            sb.append(column);
            sb.append(" ");
            sb.append(SqlUtil.jdbcToHsqlType(jdbcType));
            if (-1 != CtrlUtil.Array.findStringElement((String[])pks, (String)column, (int)-1, (boolean)true)) {
                sb.append(" PRIMARY KEY");
            }
            if (i == cols) continue;
            sb.append(",");
        }
        sb.append(" );");
        return sb.toString();
    }

    public static String jdbcToHsqlType(int jdbcType) {
        DataType dtType = DataType.fromJdbcType((int)jdbcType);
        if (dtType == DataType.STRING) {
            return "NVARCHAR(1024)";
        }
        if (dtType == DataType.INTEGER || dtType == DataType.BOOLEAN || dtType == DataType.BYTE) {
            return "INTEGER";
        }
        if (dtType == DataType.SHORT) {
            return "SMALLINT";
        }
        if (dtType == DataType.DOUBLE || dtType == DataType.FLOAT || dtType == DataType.DECIMAL || dtType == DataType.LONG) {
            return " DECIMAL";
        }
        if (dtType == DataType.DATETIME) {
            return "DATETIME";
        }
        throw new UnsupportedOperationException();
    }
}

