/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.process;

import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.ProcessResource;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.ProcessWizard;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.ProcessWizardStepUIs;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.WizardContext;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.Wizard_SelectProcessor;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom2.Element;

public abstract class BasicProcessWizard
extends ProcessWizard
implements IWizardStep {
    protected JComponent mainBody;
    protected int curStep = 0;
    private String[] stepTitles;
    private String[] stepDescriptions;
    private String processorAlias = "";
    protected Element processDesc;
    private boolean setOutputs = false;

    public BasicProcessWizard(WizardContext context) {
        super(context);
    }

    public void initProcessWizardInfo(Element processDesc) {
        try {
            int i = 0;
            List steps = processDesc.getChild("steps").getChildren();
            Iterator children = steps.iterator();
            this.stepTitles = new String[steps.size()];
            this.stepDescriptions = new String[this.stepTitles.length];
            this.processorAlias = LangUtil.getAttrValue((Element)processDesc, (String)"alias");
            while (children.hasNext()) {
                Element e = (Element)children.next();
                this.stepTitles[i] = LangUtil.getAttrValue((Element)e, (String)"title");
                if (LangUtil.isEmptyValue((String)this.stepTitles[i])) {
                    this.stepTitles[i] = null;
                }
                this.stepDescriptions[i] = LangUtil.getAttrValue((Element)e, (String)"description");
                if (LangUtil.isEmptyValue((String)this.stepDescriptions[i])) {
                    this.stepDescriptions[i] = this.stepTitles[i];
                }
                ++i;
            }
            this.processDesc = processDesc;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JComponent wrapCtrl(JComponent jcmp) {
        if (JPanel.class.isInstance(jcmp) || JScrollPane.class.isInstance(jcmp)) {
            return jcmp;
        }
        if (jcmp.getParent() == null || !JScrollPane.class.isInstance(jcmp.getParent())) {
            return new KDScrollPane((Component)jcmp);
        }
        return jcmp;
    }

    @Override
    protected JComponent getMainBodyCtrl() {
        if (this.mainBody == null) {
            this.mainBody = this.wrapCtrl(this.getUIs().getUI(0));
        }
        return this.mainBody;
    }

    protected void setMainBody(JComponent cp) {
        this.mainBodyPanel.remove((Component)this.mainBody);
        this.mainBody = cp;
        this.mainBodyPanel.add((Component)this.mainBody, (Object)"Center");
        this.mainBodyPanel.validate();
        this.mainBodyPanel.repaint();
        this.validate();
        this.repaint();
    }

    public IWizardStep outThisStep(boolean isOppose) {
        ProcessWizard wizard;
        String checkMsg;
        if (!isOppose && (checkMsg = this.getUIs().checkInputValided(this.curStep)) != null) {
            if (checkMsg.length() > 0) {
                this.alert(checkMsg);
            }
            return this;
        }
        if (this.curStep == 0 && isOppose) {
            wizard = null;
            if (this.setOutputs) {
                this.context.discardOutput();
                this.setOutputs = false;
            }
        } else if (this.curStep == this.getUIs().count() - 1 && !isOppose) {
            wizard = new Wizard_SelectProcessor(this.context);
            this.context.addProcessModel(this.getModel());
            this.setOutputs = true;
        } else {
            JComponent newCp = this.getUIs().getUI(!isOppose ? (this.curStep = this.curStep + 1) : (this.curStep = this.curStep - 1));
            this.setMainBody(this.wrapCtrl(newCp));
            this.updateTitle();
            this.updateStepDesc();
            wizard = this;
        }
        this.adjustBTsText();
        return wizard;
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        super.intoThisStep(prevStep, isOppose);
        this.manager.setPreviousStepEnabled(true);
        this.manager.setFinishEnabled(false);
        this.adjustBTsText();
    }

    private void adjustBTsText() {
        boolean canFinish = this.curStep == this.getUIs().count() - 1;
        this.manager.setFinishEnabled(canFinish);
        this.manager.getNextStepButton().setText(canFinish ? ProcessResource.getString("res_25") : ProcessResource.getString("res_26"));
    }

    @Override
    protected String getStepDescription() {
        if (this.stepDescriptions == null || this.stepDescriptions[this.curStep] == null) {
            return this.processorAlias;
        }
        return this.stepDescriptions[this.curStep];
    }

    @Override
    protected String getTitle() {
        if (this.stepTitles == null || this.stepTitles[this.curStep] == null) {
            return this.processorAlias;
        }
        return this.processorAlias + "---" + this.stepTitles[this.curStep];
    }

    protected abstract ProcessWizardStepUIs getUIs();
}

