/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.process;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.reportone.data.modal.DataDef;
import com.kingdee.bos.ctrl.reportone.data.process.IDataProcessModel;
import com.kingdee.bos.ctrl.reportone.data.process.ProcessUtil;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.AbstractModelEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.DataSetSelectModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.ProcessWizard;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.WizardContext;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.add_columns.AddColumnsEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.add_columns.AddColumnsModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.adjust_columns.AdjustOCsEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.adjust_columns.AdjustOCsModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.columns_merger.ColumnsMergerEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.columns_merger.ColumnsMergerModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.crosstab.CrosstabEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.crosstab.CrosstabModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.projection_across.ProjectionAcrossEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.projection_across.ProjectionAcrossModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.rows_appending.RowsAppendingEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.rows_appending.RowsAppendingModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.rows_splitter.RowsSplitterEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.rows_splitter.RowsSplitterModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.select_data.DataSetSelectEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.simple_gt.SimpleGroupTotalEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.simple_gt.SimpleGroupTotalModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.unit_rows.UnitRowsEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.unit_rows.UnitRowsModel;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataDefEditorPanel
extends KDPanel {
    private int lastSel;
    private AbstractModelEditor lastEditor;
    private KDList stepList;
    private KDPanel bottomPanel;
    private IObjectSelector objProvider;

    public DataDefEditorPanel() {
        this.initComponents();
    }

    public void setObjProvider(IObjectSelector objProvider) {
        this.objProvider = objProvider;
    }

    public void setDataDef(DataDef dataDef) throws Exception {
        List models = ProcessUtil.xml2Models(dataDef.getDesignInfoes());
        this.setModels(models, dataDef.getParameters());
    }

    public void updateParameters(List parameters) {
        int count = this.stepList.getElementCount();
        for (int i = 0; i < count; ++i) {
            IDataProcessModel model = (IDataProcessModel)this.stepList.getElement(i);
            model.setExternalParameters(parameters);
        }
        if (this.lastEditor != null) {
            this.lastEditor.onParametersChange();
        }
    }

    public DataDef getDataDef() {
        this.lastEditor.onLostEditor();
        IDataProcessModel model0 = null;
        WizardContext context = new WizardContext();
        ArrayList<ProcessWizard> wizards = new ArrayList<ProcessWizard>();
        int count = this.stepList.getElementCount();
        for (int i = 0; i < count; ++i) {
            IDataProcessModel model = (IDataProcessModel)this.stepList.getElement(i);
            if (i == 0) {
                model0 = model;
            }
            try {
                String wizardClassStr = model.getStrArg("wizardClass");
                Class<?> wizardClass = Class.forName(wizardClassStr);
                Constructor<?> c = wizardClass.getConstructor(WizardContext.class);
                ProcessWizard wizard = (ProcessWizard)((Object)c.newInstance(context));
                wizard.setModel(model);
                wizards.add(wizard);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        DataDef dataDef = context.makeDataObject(wizards);
        dataDef.setParameters(model0.getExternalParameters());
        return dataDef;
    }

    private void setModels(List models, List externalPs) {
        this.stepList.removeAllElements();
        for (int i = 0; i < models.size(); ++i) {
            IDataProcessModel model = (IDataProcessModel)models.get(i);
            model.setExternalParameters(externalPs);
            this.stepList.addElement((Object)model);
        }
        if (models.size() > 0) {
            this.stepList.setSelectedIndex(models.size() - 1);
        }
    }

    private AbstractModelEditor createEditor(IDataProcessModel model) {
        Class<?> modelType = model.getClass();
        AbstractModelEditor editor = null;
        if (modelType == RowsSplitterModel.class) {
            editor = new RowsSplitterEditor();
        } else if (modelType == ColumnsMergerModel.class) {
            editor = new ColumnsMergerEditor();
        } else if (modelType == ProjectionAcrossModel.class) {
            editor = new ProjectionAcrossEditor();
        } else if (modelType == RowsAppendingModel.class) {
            editor = new RowsAppendingEditor();
        } else if (modelType == SimpleGroupTotalModel.class) {
            editor = new SimpleGroupTotalEditor();
        } else if (modelType == UnitRowsModel.class) {
            editor = new UnitRowsEditor();
        } else if (modelType == CrosstabModel.class) {
            editor = new CrosstabEditor();
        } else if (modelType == DataSetSelectModel.class) {
            editor = new DataSetSelectEditor();
        } else if (modelType == AdjustOCsModel.class) {
            editor = new AdjustOCsEditor();
        } else if (modelType == AddColumnsModel.class) {
            editor = new AddColumnsEditor();
        } else {
            return null;
        }
        editor.setObjProvider(this.objProvider);
        ((AbstractModelEditor)editor).setModel(model);
        return editor;
    }

    private boolean testEffect(int modelFrom) {
        IDataProcessModel previousModel = (IDataProcessModel)this.stepList.getElement(modelFrom);
        for (int i = modelFrom + 1; i < this.stepList.getElementCount(); ++i) {
            IDataProcessModel model = (IDataProcessModel)this.stepList.getElement(i);
            if (!model.testAndSetInput(previousModel.getOutput())) {
                return false;
            }
            previousModel = model;
        }
        return true;
    }

    private void switchCurrentModel(int newSel) {
        IDataProcessModel newModel;
        AbstractModelEditor processEditor;
        if (newSel == this.lastSel) {
            return;
        }
        if (this.lastSel != -1) {
            this.lastEditor.onLostEditor();
            if (!this.testEffect(this.lastSel)) {
                for (int i = this.lastSel + 1; i < this.stepList.getElementCount(); ++i) {
                    this.stepList.removeElementAt(this.stepList.getElementCount() - 1);
                }
                newSel = this.lastSel;
                this.stepList.setSelectedIndex(newSel);
                return;
            }
        }
        if ((processEditor = this.createEditor(newModel = (IDataProcessModel)this.stepList.getElement(newSel))) != null) {
            TableLayout layout = (TableLayout)this.bottomPanel.getLayout();
            if (this.lastEditor != null) {
                this.bottomPanel.remove((Component)((Object)this.lastEditor));
            }
            this.lastEditor = processEditor;
            this.bottomPanel.add((Component)((Object)this.lastEditor), (Object)layout.cell(0, 0));
            this.bottomPanel.validate();
        }
        this.lastSel = newSel;
    }

    private void initComponents() {
        this.lastSel = -1;
        this.stepList = new KDList();
        this.bottomPanel = new KDPanel();
        KDLabel label = new KDLabel(Process2Resource.getString("res_77"));
        TableLayout layout = TableLayout.split((int)3, (int)1);
        this.setLayout((LayoutManager)layout);
        layout.rowStyle(1).setHeight(-20);
        this.add((Component)label, layout.cell(0, 0));
        this.add((Component)this.stepList, layout.cell(1, 0));
        this.add((Component)this.bottomPanel, layout.cell(2, 0));
        layout.rowStyle(0).setMargin(4, 3, 3, 0);
        layout.rowStyle(1).setMargin(3, 3, 3, 8);
        layout.rowStyle(2).setPriY(1);
        TableLayout bottomLayout = TableLayout.split((int)1, (int)1);
        this.bottomPanel.setLayout((LayoutManager)bottomLayout);
        this.bottomPanel.setBorder((Border)new TitledBorder(Process2Resource.getString("res_78")));
        bottomLayout.colStyle(0).setMargin(8, 22, 8, 8);
        this.stepList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int sel = DataDefEditorPanel.this.stepList.getSelectedIndex();
                if (sel != -1) {
                    DataDefEditorPanel.this.switchCurrentModel(sel);
                }
            }
        });
    }
}

