/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosExecutor;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_KdrsUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Eas_Executor
extends BosExecutor {
    public static final Logger log = LogUtil.getPackageLogger(Eas_Executor.class);

    public Eas_Executor(Context ctx) {
        super(ctx);
    }

    private static String andFilters(String filter1, String filter2) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(filter1);
        sb.append(") AND (");
        sb.append(filter2);
        sb.append(")");
        return sb.toString();
    }

    public static EntityViewInfo newEntityViewInfo(String s) throws ParserException {
        try {
            return new EntityViewInfo(s);
        }
        catch (ParserException ex) {
            log.error((Object)("\r\nError EntityViewInfo text:" + s));
            throw ex;
        }
    }

    private static EntityViewInfo getDataView(String custom, String common) throws ParserException {
        EntityViewInfo evi = null;
        if (!StringUtil.isEmptyString((String)custom)) {
            evi = Eas_Executor.newEntityViewInfo(custom);
            if (!StringUtil.isEmptyString((String)common)) {
                EntityViewInfo evi2 = Eas_Executor.newEntityViewInfo(common);
                FilterInfo fi2 = evi2.getFilter();
                if (fi2 != null) {
                    FilterInfo fi = evi.getFilter();
                    if (fi != null) {
                        evi.setFilter(Eas_Executor.andFilters(fi.toString(), fi2.toString()));
                    } else {
                        evi.setFilter(fi2);
                    }
                }
                evi.getSorter().addObjectCollection((IObjectCollection)evi2.getSorter());
                evi.getSelector().addObjectCollection((IObjectCollection)evi2.getSelector());
            }
        } else if (!StringUtil.isEmptyString((String)common)) {
            evi = Eas_Executor.newEntityViewInfo(common);
        }
        return evi;
    }

    private static String getOrgFilter(QueryInfo qi, OrgType orgType, OrgUnitInfo org) throws BOSException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String filter2 = null;
        EntityObjectInfo eoi = (EntityObjectInfo)qi.getMainObject().get("entityRef");
        Object info = Class.forName(eoi.getObjectValueClass()).newInstance();
        if (info instanceof CoreBillBaseInfo) {
            StringBuffer sb = new StringBuffer();
            CoreBillBaseInfo cbbi = (CoreBillBaseInfo)info;
            sb.append(cbbi.getBizOrgPropertyName());
            sb.append(".id = '");
            sb.append(org.getId().toString());
            sb.append("'");
            filter2 = sb.toString();
        } else if (Eas_KdrsUtil.hasControlType(qi)) {
            IFilterInfoProducer fip = FilterInfoProducerFactory.getControlTypeFilterInfoProducer((QueryInfo)qi);
            fip.setCurrentCtrlUnit(org.getCU());
            fip.setCurrentMainBizOrgUnit(org, orgType);
            FilterInfo fi = fip.getFilterInfo();
            if (fi != null) {
                filter2 = fi.toString();
            }
        } else {
            String orgPropName;
            String orgTypeName = eoi.getExtendedProperty("OrgType");
            if (orgTypeName == null) {
                orgTypeName = orgType.getName();
            }
            if ((orgPropName = Eas_KdrsUtil.getEntityOrgPropertyName(eoi, orgTypeName)) == null && null != eoi.getPropertyByName("CU")) {
                orgPropName = "CU";
            }
            if (orgPropName != null) {
                filter2 = orgPropName + ".id = '" + org.getId().toString() + "'";
            }
        }
        return filter2;
    }

    @Override
    protected EntityViewInfo prepareDataView(HashMap args, QueryInfo qi) throws Exception {
        String argCommonDataView = (String)args.get("COMMON_DATA_VIEW");
        String argCustomDataView = (String)args.get("CUSTOM_DATA_VIEW");
        EntityViewInfo evi = Eas_Executor.getDataView(argCustomDataView, argCommonDataView);
        Map argsPub = (Map)args.get("CONTEXT");
        if (argsPub != null) {
            OrgUnitInfo org;
            String orgFilter;
            OrgType orgType = (OrgType)argsPub.get("easOrgType");
            OrgUnitCollection orgs = (OrgUnitCollection)argsPub.get("easOrgs");
            if (orgs != null && orgs.size() > 0 && !StringUtil.isEmptyString((String)(orgFilter = Eas_Executor.getOrgFilter(qi, orgType, org = orgs.get(0))))) {
                if (evi != null) {
                    String eviFilter;
                    FilterInfo fi = evi.getFilter();
                    String string = eviFilter = fi != null ? fi.toString() : null;
                    if (!StringUtil.isEmptyString((String)eviFilter)) {
                        evi.setFilter(Eas_Executor.andFilters(eviFilter, orgFilter));
                    } else {
                        evi.setFilter(orgFilter);
                    }
                } else {
                    evi = new EntityViewInfo();
                    evi.setFilter(orgFilter);
                }
            }
        }
        return evi;
    }
}

