/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance.ImportExport;
import com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance.ImportExportUI;
import com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance.ZipSpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.KdrsConfigure;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ISpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.Storage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FSSpaceProvider;
import com.kingdee.bos.ctrl.swing.KDLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ImportExportDialog
extends TypicalDialog {
    public static final Logger log = LogUtil.getPackageLogger(ImportExportDialog.class);
    private boolean isImport = true;
    private IBizContent bizContent;
    private ImportExportUI importExportUI;
    private KDLabel progressLabel;
    private File localTemporaryFolder;
    private boolean actionCanceled;
    Worker workerThread;

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table table = thisCell.splitRow(2);
        this.progressLabel = new KDLabel(" ");
        parent.add((Component)this.progressLabel, table.cell(1));
        this.importExportUI = new ImportExportUI(this.isImport);
        if (!this.isImport) {
            this.importExportUI.setSource(this.bizContent);
        }
        parent.add((Component)((Object)this.importExportUI), table.cell(0));
        table.rowStyle(0).setPriY(1);
        table.rowStyle(1).setMarginTop(3);
        this.btnOk.setText(this.getImportText());
    }

    protected void todoInit() {
    }

    public void addResouce(String resPath) {
        this.progressLabel.setText("\u6b63\u5728" + this.getImportText() + ":" + resPath);
    }

    public void setBizContent(IBizContent bizContent) {
        this.bizContent = bizContent;
    }

    public final boolean isImport() {
        return this.isImport;
    }

    public final void setImport(boolean isImport) {
        this.isImport = isImport;
    }

    String getImportText() {
        return this.isImport ? "\u5bfc\u5165" : "\u5bfc\u51fa";
    }

    static final IBizContent makeLocalContent(File file) throws IOException, KDRSException {
        Storage storage;
        ISpaceProvider provider;
        String filePath = file.getAbsolutePath();
        if (file.isFile()) {
            provider = new ZipSpaceProvider(filePath);
            storage = new Storage(provider, new ZipSpaceProvider.ZipEntryPersistentMetas(provider));
        } else {
            provider = new FSSpaceProvider(filePath);
            storage = new Storage(provider);
        }
        BizContent bizCnt = new BizContent(new StoredObjectFactory(storage, KdrsConfigure.typesConf, "category"));
        return bizCnt;
    }

    void exitDialog() {
        super.onOk();
    }

    protected void onOk() {
        this.btnOk.setEnabled(false);
        this.workerThread = new Worker();
        this.workerThread.start();
    }

    protected void onCancel() {
        if (this.workerThread == null) {
            super.onCancel();
        } else {
            this.btnOk.setEnabled(true);
            this.setActionCanceled(true);
            this.progressLabel.setText("");
            this.workerThread = null;
        }
    }

    void doAction() throws Exception {
        this.setActionCanceled(false);
        String[] pathx = this.importExportUI.getPathx();
        File file = this.importExportUI.getFile();
        ImportExport importExport = new ImportExport();
        importExport.bindDialog(this);
        if (this.isImport) {
            importExport.setSource(ImportExportDialog.makeLocalContent(file), "/EAS_Report.kdrs");
            importExport.setTarget(this.bizContent, "/EAS_Report.kdrs");
        } else {
            importExport.setSource(this.bizContent, "/EAS_Report.kdrs");
            this.localTemporaryFolder = FileUtil.createTemporaryFile((boolean)true, null);
            importExport.setTarget(ImportExportDialog.makeLocalContent(this.localTemporaryFolder), "/EAS_Report.kdrs");
        }
        importExport.execute(pathx);
        if (!this.isImport) {
            ZipSpaceProvider.zip(this.localTemporaryFolder.getAbsolutePath(), file.getAbsolutePath(), true);
        }
    }

    public ImportExportDialog() {
    }

    public ImportExportDialog(Dialog owner) {
        super(owner);
    }

    public ImportExportDialog(Frame owner) {
        super(owner);
    }

    public final ImportExportUI getImportExportUI() {
        return this.importExportUI;
    }

    public final synchronized boolean isActionCanceled() {
        return this.actionCanceled;
    }

    public final synchronized void setActionCanceled(boolean actionCanceled) {
        this.actionCanceled = actionCanceled;
    }

    class Worker
    extends Thread {
        Worker() {
        }

        @Override
        public void run() {
            try {
                ImportExportDialog.this.doAction();
                if (!ImportExportDialog.this.isActionCanceled()) {
                    WindowUtil.msgboxInfo((Object)(ImportExportDialog.this.getImportText() + "\u6210\u529f!"), (String)ImportExportDialog.this.getImportText(), (Component)((Object)ImportExportDialog.this));
                    ImportExportDialog.this.exitDialog();
                }
            }
            catch (Exception ex) {
                log.error((Object)(ImportExportDialog.this.getImportText() + "\u5931\u8d25"), (Throwable)ex);
                WindowUtil.msgboxError((Object)(ImportExportDialog.this.getImportText() + "\u5931\u8d25"), (String)ImportExportDialog.this.getImportText(), (Component)((Object)ImportExportDialog.this));
            }
        }
    }
}

