/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects;

import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.bizshare.IConnection;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.meta.MetaUtil;
import com.kingdee.bos.ctrl.data.meta.bmd.BmdMetaType;
import com.kingdee.bos.ctrl.data.meta.io.DB2Meta;
import com.kingdee.bos.ctrl.data.meta.io.IMeta2Xml;
import com.kingdee.bos.ctrl.data.meta.io.Meta2Xml;
import com.kingdee.bos.ctrl.reportone.data.framework.connection.BosConnection;
import com.kingdee.bos.ctrl.reportone.data.framework.connection.DBConnection;
import com.kingdee.bos.ctrl.reportone.data.framework.connection.DSConfig;
import com.kingdee.bos.ctrl.reportone.data.framework.connection.DSConfigIO;
import com.kingdee.bos.ctrl.reportone.data.meta.bmd.BmdMetaLibrary;
import com.kingdee.bos.ctrl.reportone.data.meta.io.Bmd2Meta;
import com.kingdee.bos.ctrl.reportone.kdrs.KdrsResource;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.IStoredDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.ITemplateSupport;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UnsupportedTypeException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.AbstractContainerObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.IContainerObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.objs.IFileObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.objs.IFolderObject;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class StoredDataSource
extends AbstractContainerObject
implements IStoredDataSource {
    public static final String OBJ_CONFIG = "config";
    public static final String OBJ_METAS = "snapshot";

    public StoredDataSource(IStorage storage, Path path, String type, StoredObjectFactory objFactory) {
        super(storage, path, type, objFactory);
    }

    public static void build(IStorage storage, Path path, HashMap attrs, StoredObjectFactory objFactory) throws KDRSException {
        storage.create(path, ResourceType.FOLDER, attrs);
        StoredDataSource tempParent = new StoredDataSource(storage, path, null, objFactory);
        try {
            tempParent.createChild(OBJ_CONFIG, IFileObject.class, null);
            tempParent.createChild(OBJ_METAS, IFolderObject.class, null);
        }
        catch (KDRSException ex) {
            new BizStorage(storage).delete(path.getPathText());
            throw ex;
        }
    }

    @Override
    public byte[] readConfig() throws KDRSException {
        return StorageUtil.readFile(this.storage, this.path.getChild(OBJ_CONFIG));
    }

    @Override
    public void writeConfig(byte[] data) throws KDRSException {
        StorageUtil.writeFile(this.storage, this.path.getChild(OBJ_CONFIG), data);
    }

    @Override
    protected String[] listChilrenNames() throws KDRSException {
        return new String[]{OBJ_METAS};
    }

    @Override
    public void updateMetadatas() throws KDRSException {
        BmdMetaLibrary ml;
        DSConfig dsCfg = DSConfigIO.loadDSConfig(this.readConfig());
        IConnection conn = dsCfg.getConnection();
        if (conn instanceof DBConnection) {
            if (dsCfg.getDesc() != null) {
                ml = Bmd2Meta.lazyLoad(dsCfg.getDesc(), new BmdMetaType[]{BmdMetaType.TABLE});
                MetaUtil.convert2DBTable((MetaPackage)ml.getRootPackage());
            } else {
                DB2Meta db2m = new DB2Meta();
                try {
                    conn.open();
                    ml = db2m.parseDataBase(((DBConnection)conn).getConnection(), dsCfg.getName());
                    conn.close();
                }
                catch (ConnectException ex) {
                    throw KDRSException.makeException(KdrsResource.getString("res_9"), ex);
                }
            }
        } else if (conn instanceof BosConnection) {
            ml = Bmd2Meta.lazyLoad(dsCfg.getDesc());
        } else {
            throw new UnsupportedTypeException(KdrsResource.getString("res_10"));
        }
        this.objFactory.load(this.path.getChild(OBJ_METAS)).reset();
        Meta2Xml.makeLibrary((MetaLibrary)ml, (IMeta2Xml)new Meta2Storage(this.objFactory, this.path.getChild(OBJ_METAS)));
    }

    public static class Meta2Storage
    implements IMeta2Xml {
        private static final Logger log = LogUtil.getPackageLogger(Meta2Storage.class);
        private StoredObjectFactory objFactory;
        private Path metasPath;
        private HashMap pkgAttrs = new HashMap();
        private HashMap clsAttrs = new HashMap();

        public Meta2Storage(StoredObjectFactory objFactory, Path metasPath) {
            this.objFactory = objFactory;
            this.metasPath = metasPath;
        }

        private String makeResPath(String path) {
            return PathUtil.makeChildPath((String)this.metasPath.getPathText(), (String)path);
        }

        private String makeResPath(MetaClass mc) {
            return this.makeResPath(mc.getFullName());
        }

        public boolean enterPackage(MetaPackage mp, MetaPackage parent) {
            String resPath = this.makeResPath(mp.getFullName());
            try {
                this.pkgAttrs.put("alias", "#1");
                String alias = mp.getAlias();
                this.pkgAttrs.put("alias.zh_CN", alias);
                this.pkgAttrs.put("alias.zh_TW", STConverter.sc2tc((String)alias));
                Path path = Path.valueOf(resPath);
                IContainerObject parentObj = (IContainerObject)this.objFactory.load(path.getParent());
                parentObj.createChild(path.getName(), IFolderObject.class, this.pkgAttrs);
                return true;
            }
            catch (Exception ex) {
                log.error((Object)ex);
                return false;
            }
        }

        public boolean savePackage(MetaPackage mp, Element xmlPkg, MetaPackage parent, Element xmlParent) {
            return true;
        }

        public boolean enterClass(MetaClass mc, MetaPackage parent) {
            return true;
        }

        public boolean saveClass(MetaClass mc, Element xmlCls, MetaPackage parent, Element xmlParent) {
            String resPath = this.makeResPath(mc);
            try {
                this.clsAttrs.put("alias", "#1");
                String alias = mc.getAlias();
                this.clsAttrs.put("alias.zh_CN", alias);
                this.clsAttrs.put("alias.zh_TW", STConverter.sc2tc((String)alias));
                Path path = Path.valueOf(resPath);
                IContainerObject parentObj = (IContainerObject)this.objFactory.load(path.getParent());
                ITemplateSupport template = (ITemplateSupport)((Object)parentObj.createChild(path.getName(), mc.getType(), this.clsAttrs));
                template.writeTemplate(XmlUtil.saveXmlBytes((Element)xmlCls));
                return true;
            }
            catch (KDRSException ex) {
                log.error((Object)ex, (Throwable)ex);
                return false;
            }
            catch (IOException ex) {
                log.error((Object)ex, (Throwable)ex);
                return false;
            }
        }

        public boolean saveField(MetaField mf, Element xmlFld, MetaClass parent, Element xmlParent) {
            xmlParent.addContent((Content)xmlFld);
            return false;
        }

        public boolean enterField(MetaField mf, MetaClass parent) {
            return false;
        }
    }
}

