/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.objectx;

import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidParameterException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.AbstractSingleObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.AbstractStoredObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.IStoredObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.TypesConfigure;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.UnsupportInterfaceException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class AbstractContainerObject
extends AbstractStoredObject {
    private static final Class[] folderObjBiuldArgTypes = new Class[]{IStorage.class, Path.class, HashMap.class, StoredObjectFactory.class};
    private static final Class[] singleObjBiuldArgTypes = new Class[]{IStorage.class, Path.class, HashMap.class};
    protected StoredObjectFactory objFactory;

    public AbstractContainerObject(IStorage storage, Path path, String type, StoredObjectFactory objFactory) {
        super(storage, path, type);
        this.objFactory = objFactory;
    }

    protected String[] listChilrenNames() throws KDRSException {
        return this.storage.listChildren(this.path);
    }

    public IStoredObject[] listChildren() throws KDRSException {
        IStoredObject[] objs;
        String[] children = this.listChilrenNames();
        if (children == null) {
            objs = new IStoredObject[]{};
        } else {
            objs = new IStoredObject[children.length];
            for (int i = 0; i < children.length; ++i) {
                objs[i] = this.objFactory.load(this.path.getChild(children[i]));
            }
        }
        return objs;
    }

    public IStoredObject createChild(String name, String type, HashMap attrs) throws KDRSException {
        if (type == null) {
            throw new InvalidParameterException("type is null!");
        }
        TypesConfigure.TypeMapping typeM = this.objFactory.getTypesConf().findByType(type);
        if (typeM == null) {
            throw new UnsupportInterfaceException("Unsupport target type:" + type);
        }
        return this.createChild(name, typeM, attrs);
    }

    public IStoredObject createChild(String name, Class cls, HashMap attrs) throws KDRSException {
        TypesConfigure typesConf = this.objFactory.getTypesConf();
        if (cls != null) {
            TypesConfigure.TypeMapping typeM = typesConf.findByType(cls);
            if (typeM == null) {
                throw new UnsupportInterfaceException("class:" + cls);
            }
            return this.createChild(name, typeM, attrs);
        }
        return this.createChild(name, this.objFactory.checkType(attrs), attrs);
    }

    public IStoredObject getChild(String name) throws KDRSException {
        return this.objFactory.load(this.path.getChild(name));
    }

    private IStoredObject createChild(String name, TypesConfigure.TypeMapping typeM, HashMap attrs) throws KDRSException {
        Class implCls = typeM.getTypeImpl();
        if (attrs == null) {
            attrs = new HashMap<String, String>();
        }
        attrs.put(this.objFactory.getTypeKey(), typeM.getType());
        boolean built = true;
        Path childPath = this.path.getChild(name);
        try {
            if (AbstractContainerObject.class.isAssignableFrom(implCls)) {
                Method method = ReflectUtil.getMethodEx((Class)implCls, (String)"build", (Class[])folderObjBiuldArgTypes);
                method.invoke(null, this.storage, childPath, attrs, this.objFactory);
            } else if (AbstractSingleObject.class.isAssignableFrom(implCls)) {
                Method method = ReflectUtil.getMethodEx((Class)implCls, (String)"build", (Class[])singleObjBiuldArgTypes);
                method.invoke(null, this.storage, childPath, attrs);
            } else {
                built = false;
            }
        }
        catch (Exception ex) {
            throw KDRSException.makeException("", ex);
        }
        if (built) {
            return this.objFactory.load(childPath, typeM);
        }
        throw new UnsupportInterfaceException("Maybe implCls is bad:" + implCls);
    }

    @Override
    public void reset() throws KDRSException {
        IStoredObject[] children = this.listChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            children[i].delete();
        }
    }
}

