/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.AbstractRuler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.RulerMark;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;

public class HRuler
extends AbstractRuler
implements IR1Ruler {
    private ComboPanel comboPanel;

    public HRuler(ComboPanel comboPanel) {
        this.comboPanel = comboPanel;
    }

    @Override
    public void drawGraduation(Graphics g) {
        double scale = this.comboPanel.getScale();
        int zeroOfMark = (int)Math.round((double)this.getZeroOfmark() * scale);
        int zeroOffset = (int)Math.round((double)this.getZeroOffset() * scale);
        int scrollOffset = Math.round(this.getScrollOffset());
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getCtrl().getFont());
        Graphics g2paper = g.create();
        g2paper.translate(zeroOfMark + zeroOffset - scrollOffset, 0);
        g2paper.setColor(Color.BLACK);
        int width = zeroOfMark - scrollOffset;
        float endGraduation = (float)((double)this.pixelToUnit(width + 1) / scale);
        int height = this.getCtrl().getHeight();
        int loopStart = width < 0 ? 0 : (int)Math.round((double)this.unitToPixel(width) * scale);
        int yUnitStart = height - 3;
        int yFiveUnitStart = height - 5;
        int yTenUnitStart = height - 7;
        g2paper.drawLine(0, height - 1, -loopStart - 1, height - 1);
        g2paper.setColor(new Color(10, 10, 10, 100));
        g2paper.fillRect(-loopStart, yTenUnitStart, loopStart, 7);
        g2paper.setColor(Color.BLACK);
        for (int j = 0; j <= (int)endGraduation; ++j) {
            int y;
            int x = (int)Math.round((double)this.unitToPixel(-j) * scale);
            int graduationType = j % 10;
            if (graduationType == 0) {
                y = yTenUnitStart;
                String str = String.valueOf(j * this.getDrawingTenUnit() / 10);
                int widthStr = fm.stringWidth(str);
                g2paper.drawString(str, x - widthStr / 2, y - 1);
            } else {
                y = graduationType == 5 ? yFiveUnitStart : yUnitStart;
            }
            g2paper.drawLine(x, y, x, height);
        }
        float startGraduation = (float)((double)this.pixelToUnit(width) / scale);
        width = this.getCtrl().getWidth() - width;
        endGraduation = (float)((double)this.pixelToUnit(width) / scale);
        loopStart = startGraduation > 0.0f ? 0 : -((int)startGraduation);
        g2paper.drawLine(-zeroOffset, height - 1, width - 1, height - 1);
        for (int i = loopStart; i <= (int)endGraduation; ++i) {
            int y;
            int x = (int)Math.round((double)this.unitToPixel(i) * scale);
            int graduationType = i % 10;
            if (graduationType == 0) {
                y = yTenUnitStart;
                String str = String.valueOf(i * this.getDrawingTenUnit() / 10);
                int widthStr = fm.stringWidth(str);
                g2paper.drawString(str, x - widthStr / 2, y - 1);
            } else {
                y = graduationType == 5 ? yFiveUnitStart : yUnitStart;
            }
            g2paper.drawLine(x, y, x, height);
        }
        g.setColor(Color.BLUE);
        RulerMark markNew = this.getMarkPosition();
        if (markNew != null) {
            int v1 = markNew.getValue1();
            int v2 = markNew.getValue2();
            v1 = (int)Math.round((double)v1 * scale);
            v2 = (int)Math.round((double)v2 * scale);
            g.drawLine(v1 += zeroOffset + zeroOfMark - scrollOffset, 0, v1, height);
            g.drawLine(v2 += zeroOffset + zeroOfMark - scrollOffset, 0, v2, height);
        }
    }
}

