/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.element;

import com.kingdee.bos.ctrl.kdf.util.style.Rect;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.properties.IRequestFill;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IDoubleClick;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IDoubleClickEditor;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.TextEditor;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.Line;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.RulerMark;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.undo.UndoHelper;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.IReportObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.operate.LineAdjustRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.AbstractR1FormObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.icon.Icons;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.mouseoperate.LabelContainerState;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.renderer.LabelContainerRenerer;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class LabelContainer
extends AbstractR1FormObject
implements IContainer,
IRequestFill,
IDoubleClick,
IMouseOperate {
    private String _labelText;
    private IReportObject _child;
    private LabelContainerState _mouseOperateState;
    private Line lastDragLine;

    public LabelContainer() {
        StyleAttributes sa = Styles.getDefaultSA();
        this.setStyleAttribute(sa);
        this.setLabelLength(Util.pixel2Lom(80));
    }

    @Override
    public int getHeightLom() {
        return Util.pixel2Lom(19);
    }

    @Override
    public void setHeightLom(int height) {
        if (height < this.getHeightLom()) {
            this.setYLom(this.getYLom() - (this.getHeightLom() - height));
        }
    }

    @Override
    public boolean isVerticalResizable() {
        return false;
    }

    public void setLabelText(String text) {
        this._labelText = text;
    }

    public String getLabelText() {
        return this._labelText;
    }

    public void setLabelLength(int length) {
        this.getStyleAttribute().setPadding(this.createNewPadding(length));
        this.layout();
    }

    public int getLabelLength() {
        return this.getStyle().getPadding().getLeft();
    }

    public int getLabelLengthPixel() {
        return Util.lom2Pixel(this.getLabelLength());
    }

    private Rect createNewPadding(int labelLegnth) {
        Rect padding = this.getStyleAttribute().getPadding();
        padding = new Rect(labelLegnth, padding.getTop(), padding.getRight(), padding.getBottom());
        return padding;
    }

    @Override
    protected IReportObjectRenderer createRenderer() {
        return new LabelContainerRenerer();
    }

    @Override
    public String getIdPrefix() {
        return "labelContainer";
    }

    @Override
    public void initTreeNode(DefaultKingdeeTreeNode node) {
        node.setCustomIcon((Icon)Icons.SEC_LABELCONTAINER);
    }

    @Override
    public String getTypePrompt() {
        return MultiLanguageUtil.getMLS("labelContainer", "");
    }

    @Override
    public void addChild(IReportObject child, String layoutParm) {
        if (child != this._child) {
            this.removeChild(this._child);
            this._child = child;
            this._child.setParent(new ElementPath(this));
        }
    }

    @Override
    public boolean isCanAddChild(Point ptAtThis) {
        return this._child == null;
    }

    @Override
    public void removeChild(IReportObject child) {
        if (this._child != null && child == this._child) {
            child.setParent(null);
            this._child = null;
        }
    }

    @Override
    public int getChildrenCount() {
        return this._child == null ? 0 : 1;
    }

    @Override
    public List getChildren() {
        ArrayList<IReportObject> children = new ArrayList<IReportObject>();
        if (this._child != null) {
            children.add(this._child);
        }
        return children;
    }

    @Override
    public int getInsetsXLom() {
        return this.getLabelLength();
    }

    @Override
    public int getInsetsYLom() {
        return 0;
    }

    @Override
    public int getInsetsWidthLom() {
        return this.getWidthLom() - this.getLabelLength();
    }

    @Override
    public int getInsetsHeightLom() {
        return this.getHeightLom();
    }

    @Override
    public Rectangle getInsetRect(String layoutParm) {
        Rectangle rect = new Rectangle(this.getInsetsXLom(), this.getInsetsYLom(), this.getInsetsWidthLom(), this.getInsetsHeightLom());
        Util.lom2Pixel(rect);
        return rect;
    }

    @Override
    public void layout() {
        if (this._child != null) {
            this._child.setXLom(0);
            this._child.setYLom(0);
            this._child.setWidthLom(this.getInsetsWidthLom());
            this._child.setHeightLom(this.getInsetsHeightLom());
            if (this._child instanceof IContainer) {
                ((IContainer)((Object)this._child)).layout();
            } else if (this._child instanceof ICompositeContainer) {
                ((ICompositeContainer)((Object)this._child)).layoutAllSubContainer();
            }
        }
    }

    @Override
    public String getLayoutParm(Point ptAtThis) {
        return null;
    }

    @Override
    public boolean isInitHFill() {
        return true;
    }

    @Override
    public boolean isInitVFill() {
        return true;
    }

    @Override
    public boolean isHFillEditable() {
        return false;
    }

    @Override
    public boolean isVFillEditable() {
        return false;
    }

    @Override
    public IDoubleClickEditor getEditor() {
        TextEditor editor = TextEditor.createInstance();
        editor.setValue(this.getLabelText());
        editor.setBindObject(this);
        return editor;
    }

    @Override
    public void setEditedValue(Object value) {
        this.setLabelText((String)value);
    }

    @Override
    public boolean isCanEdit() {
        return true;
    }

    @Override
    public Rectangle getEditorBound() {
        Rectangle rect = this.getRectAtPage();
        rect.width = this.getLabelLengthPixel();
        return rect;
    }

    @Override
    public IMouseOperateState getMouseOperateState() {
        if (this._mouseOperateState == null) {
            this._mouseOperateState = new LabelContainerState();
        }
        return this._mouseOperateState;
    }

    @Override
    public boolean mouseMoved(MouseEvent evt, Point ptAtPage) {
        Point thisAtPage = ContainerUtil.getPointAtPage(this);
        Point ptAtThis = new Point(ptAtPage);
        ptAtThis.translate(-thisAtPage.x, -thisAtPage.y);
        if (Util.isNearEnough(ptAtThis.x, this.getLabelLengthPixel(), 4)) {
            this.getMouseOperateState().setOperate(1);
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(Graphics g, MouseEvent evt, Point dragStartPoint, IR1Ruler hRuler, IR1Ruler vRuler) {
        if (((LabelContainerState)this.getMouseOperateState()).isAdjust()) {
            this.adjustLabelLength(g, dragStartPoint, evt.getPoint(), false, hRuler, vRuler);
        }
    }

    @Override
    public void mouseReleased(Graphics g, MouseEvent evt, Point dragStartPoint, UndoHelper undoHelper) {
        if (((LabelContainerState)this.getMouseOperateState()).isAdjust()) {
            undoHelper.store("\u8c03\u6574\u6807\u7b7e\u5bbd\u5ea6");
            this.adjustLabelLength(g, dragStartPoint, evt.getPoint(), true, null, null);
        }
    }

    private void adjustLabelLength(Graphics g, Point dragStartPoint, Point dragCurrentPoint, boolean isEnd, IR1Ruler hRuler, IR1Ruler vRuler) {
        Point thisAtPage = ContainerUtil.getPointAtPage(this);
        g.translate(thisAtPage.x, thisAtPage.y);
        Point delta = this.getDelta(dragStartPoint, dragCurrentPoint);
        Line line = null;
        if (!isEnd) {
            line = this.getAdjustingLine(delta);
        }
        LineAdjustRenderer rd = new LineAdjustRenderer();
        rd.draw(this, g, this.lastDragLine, line);
        this.lastDragLine = line;
        if (isEnd) {
            this.setLabelLength(Util.pixel2Lom(this.getLabelLengthPixel() + delta.x));
        }
        if (line != null && hRuler != null) {
            RulerMark hRulerMark = new RulerMark(line.getX1() + thisAtPage.x, line.getX1() + thisAtPage.x);
            hRuler.setMarkPosition(hRulerMark);
        }
    }

    private Point getDelta(Point dragStartPoint, Point dragCurrentPoint) {
        Point delta = dragCurrentPoint;
        delta.translate(-dragStartPoint.x, -dragStartPoint.y);
        if (delta.x < 0 && -delta.x > this.getLabelLengthPixel() - 10) {
            delta.x = -this.getLabelLengthPixel() + 10;
        } else if (delta.x > this.getWidth() - this.getLabelLengthPixel() - 10) {
            delta.x = this.getWidth() - this.getLabelLengthPixel() - 10;
        }
        return delta;
    }

    private Line getAdjustingLine(Point delta) {
        int x = this.getLabelLengthPixel() + delta.x;
        return new Line(x, 0, x, this.getHeight());
    }

    @Override
    public ElementPath getSelection(Point ptAtPage) {
        return null;
    }

    @Override
    public ElementPath[] getSelection(ReportSelectionModel selectionModel, ElementPath elePath) {
        return null;
    }

    @Override
    public String getType() {
        return "LabelContainer";
    }

    @Override
    protected String[] propertyPanelKeys(ICompositeObject co) {
        return new String[]{"labelContain"};
    }
}

