/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.element;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.properties.IRequestFill;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.Line;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.RulerMark;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.undo.UndoHelper;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.IReportObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.operate.LineAdjustRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.AbstractR1FormObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.icon.Icons;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.mouseoperate.SplitPaneState;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.renderer.SplitPaneRenderer;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class SplitPaneContainer
extends AbstractR1FormObject
implements IContainer,
IRequestFill,
IMouseOperate {
    public static final String CHILD_LEFT = "child1";
    public static final String CHILD_RIGHT = "child2";
    private boolean _isHSplit = true;
    private IReportObject _leftChild;
    private IReportObject _rightChild;
    private int _dividerLocation = 100;
    public static final int SPLIT_WIDTH = 8;
    private SplitPaneState _mouseOperateState;
    private Line lastDragLine;

    public void setHorizontalSplit(boolean isH) {
        this._isHSplit = isH;
    }

    public boolean isHorizontalSplit() {
        return this._isHSplit;
    }

    @Override
    public void setWidthLom(int wLom) {
        int temp;
        super.setWidthLom(wLom);
        if (this._isHSplit && (temp = this.getWidth() - 8) < this.getDividerLocation()) {
            this.setDividerLocation(temp > 0 ? temp : 0);
        }
    }

    @Override
    public void setHeightLom(int hLom) {
        int temp;
        super.setHeightLom(hLom);
        if (!this._isHSplit && (temp = this.getHeight() - 8) < this.getDividerLocation()) {
            this.setDividerLocation(temp > 0 ? temp : 0);
        }
    }

    public int getDividerLocation() {
        return this._dividerLocation;
    }

    public void setDividerLocation(int v) {
        this._dividerLocation = v;
        this.layout();
    }

    public IReportObject getLeftChild() {
        return this._leftChild;
    }

    public IReportObject getRightChild() {
        return this._rightChild;
    }

    @Override
    protected IReportObjectRenderer createRenderer() {
        return new SplitPaneRenderer();
    }

    @Override
    public String getIdPrefix() {
        return "splitPane";
    }

    @Override
    public void initTreeNode(DefaultKingdeeTreeNode node) {
        node.setCustomIcon((Icon)Icons.SEC_SPLITE);
    }

    @Override
    public String getTypePrompt() {
        return MultiLanguageUtil.getMLS("splitePane", "");
    }

    @Override
    public void addChild(IReportObject child, String layoutParm) {
        if (CHILD_LEFT == layoutParm) {
            this._leftChild = child;
            child.setParent(new ElementPath(this));
        } else if (CHILD_RIGHT == layoutParm) {
            this._rightChild = child;
            child.setParent(new ElementPath(this));
        }
    }

    @Override
    public boolean isCanAddChild(Point ptAtThis) {
        String parm = this.getLayoutParm(ptAtThis);
        if (parm == CHILD_LEFT && this._leftChild == null) {
            return true;
        }
        return parm == CHILD_RIGHT && this._rightChild == null;
    }

    @Override
    public void removeChild(IReportObject child) {
        if (child == this._leftChild) {
            this._leftChild = null;
            child.setParent(null);
        } else if (child == this._rightChild) {
            this._rightChild = null;
            child.setParent(null);
        }
    }

    @Override
    public List getChildren() {
        ArrayList<IReportObject> result = new ArrayList<IReportObject>();
        if (this._leftChild != null) {
            result.add(this._leftChild);
        }
        if (this._rightChild != null) {
            result.add(this._rightChild);
        }
        return result;
    }

    @Override
    public int getChildrenCount() {
        int c = 0;
        c += this._leftChild == null ? 0 : 1;
        return c += this._rightChild == null ? 0 : 1;
    }

    @Override
    public int getInsetsXLom() {
        return 0;
    }

    @Override
    public int getInsetsYLom() {
        return 0;
    }

    @Override
    public int getInsetsWidthLom() {
        return this.getWidthLom();
    }

    @Override
    public int getInsetsHeightLom() {
        return this.getHeightLom();
    }

    @Override
    public Rectangle getInsetRect(String layoutParm) {
        int ix = Util.lom2Pixel(this.getInsetsXLom());
        int iy = Util.lom2Pixel(this.getInsetsYLom());
        int iw = Util.lom2Pixel(this.getInsetsWidthLom());
        int ih = Util.lom2Pixel(this.getInsetsHeightLom());
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        if (CHILD_LEFT == layoutParm) {
            x = ix;
            y = iy;
            if (this._isHSplit) {
                h = ih;
                w = this._dividerLocation;
            } else {
                w = iw;
                h = this._dividerLocation;
            }
        } else if (CHILD_RIGHT == layoutParm) {
            if (this._isHSplit) {
                x = ix + this._dividerLocation + 8;
                y = iy;
                w = iw - this._dividerLocation - 8;
                h = ih;
                if (w < 0) {
                    w = 0;
                }
            } else {
                x = ix;
                y = iy + this._dividerLocation + 8;
                w = iw;
                h = ih - this._dividerLocation - 8;
                if (h < 0) {
                    h = 0;
                }
            }
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public void layout() {
        if (this._leftChild != null) {
            this._leftChild.setXLom(0);
            this._leftChild.setYLom(0);
            if (this._isHSplit) {
                this._leftChild.setWidthLom(Util.pixel2Lom(this._dividerLocation));
                this._leftChild.setHeightLom(this.getInsetsHeightLom());
            } else {
                this._leftChild.setWidthLom(this.getInsetsWidthLom());
                this._leftChild.setHeightLom(Util.pixel2Lom(this._dividerLocation));
            }
            if (this._leftChild instanceof IContainer) {
                ((IContainer)((Object)this._leftChild)).layout();
            } else if (this._leftChild instanceof ICompositeContainer) {
                ((ICompositeContainer)((Object)this._leftChild)).layoutAllSubContainer();
            }
        }
        if (this._rightChild != null) {
            if (this._isHSplit) {
                this._rightChild.setXLom(Util.pixel2Lom(this._dividerLocation + 8));
                this._rightChild.setYLom(0);
                this._rightChild.setWidthLom(this.getInsetsWidthLom() - Util.pixel2Lom(this._dividerLocation + 8));
                this._rightChild.setHeightLom(this.getInsetsHeightLom());
            } else {
                this._rightChild.setXLom(0);
                this._rightChild.setYLom(Util.pixel2Lom(this._dividerLocation + 8));
                this._rightChild.setWidthLom(this.getInsetsWidthLom());
                this._rightChild.setHeightLom(this.getInsetsHeightLom() - Util.pixel2Lom(this._dividerLocation + 8));
            }
            if (this._rightChild instanceof IContainer) {
                ((IContainer)((Object)this._rightChild)).layout();
            } else if (this._rightChild instanceof ICompositeContainer) {
                ((ICompositeContainer)((Object)this._rightChild)).layoutAllSubContainer();
            }
        }
    }

    @Override
    public String getLayoutParm(Point ptAtThis) {
        if (ptAtThis == null) {
            if (this._leftChild == null) {
                return CHILD_LEFT;
            }
            if (this._rightChild == null) {
                return CHILD_RIGHT;
            }
            return null;
        }
        int x = Util.lom2Pixel(this.getInsetsXLom());
        int y = Util.lom2Pixel(this.getInsetsYLom());
        int w = Util.lom2Pixel(this.getInsetsWidthLom());
        int h = Util.lom2Pixel(this.getInsetsHeightLom());
        if (this._isHSplit) {
            if (ptAtThis.y >= y && ptAtThis.y <= y + h) {
                if (ptAtThis.x >= x && ptAtThis.x <= x + this._dividerLocation) {
                    return CHILD_LEFT;
                }
                if (ptAtThis.x >= x + this._dividerLocation + 8 && ptAtThis.x <= x + w) {
                    return CHILD_RIGHT;
                }
            }
        } else if (ptAtThis.x >= x && ptAtThis.x <= x + w) {
            if (ptAtThis.y >= y && ptAtThis.y <= y + this._dividerLocation) {
                return CHILD_LEFT;
            }
            if (ptAtThis.y >= y + this._dividerLocation + 8 && ptAtThis.y <= y + h) {
                return CHILD_RIGHT;
            }
        }
        return null;
    }

    @Override
    public boolean isInitHFill() {
        return true;
    }

    @Override
    public boolean isInitVFill() {
        return true;
    }

    @Override
    public boolean isHFillEditable() {
        return false;
    }

    @Override
    public boolean isVFillEditable() {
        return false;
    }

    @Override
    public IMouseOperateState getMouseOperateState() {
        if (this._mouseOperateState == null) {
            this._mouseOperateState = new SplitPaneState();
        }
        return this._mouseOperateState;
    }

    @Override
    public boolean mouseMoved(MouseEvent evt, Point ptAtPage) {
        Point thisAtPage = ContainerUtil.getPointAtPage(this);
        Point ptAtThis = new Point(ptAtPage);
        ptAtThis.translate(-thisAtPage.x, -thisAtPage.y);
        if (this._isHSplit) {
            if (Util.isNearEnough(ptAtThis.x, this.getDividerLocation() + 4, 4)) {
                this.getMouseOperateState().setOperate(1);
                return true;
            }
        } else if (Util.isNearEnough(ptAtThis.y, this.getDividerLocation() + 4, 4)) {
            this.getMouseOperateState().setOperate(2);
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(Graphics g, MouseEvent evt, Point dragStartPoint, IR1Ruler hRuler, IR1Ruler vRuler) {
        if (((SplitPaneState)this.getMouseOperateState()).isHAdjust() || ((SplitPaneState)this.getMouseOperateState()).isVAdjust()) {
            this.adjustDividerLocation(g, dragStartPoint, evt.getPoint(), false, hRuler, vRuler);
        }
    }

    @Override
    public void mouseReleased(Graphics g, MouseEvent evt, Point dragStartPoint, UndoHelper undoHelper) {
        if (((SplitPaneState)this.getMouseOperateState()).isHAdjust() || ((SplitPaneState)this.getMouseOperateState()).isVAdjust()) {
            undoHelper.store("\u8c03\u6574\u5206\u9694\u6761\u4f4d\u7f6e");
            this.adjustDividerLocation(g, dragStartPoint, evt.getPoint(), true, null, null);
        }
    }

    private void adjustDividerLocation(Graphics g, Point dragStartPoint, Point dragCurrentPoint, boolean isEnd, IR1Ruler hRuler, IR1Ruler vRuler) {
        Point thisAtPage = ContainerUtil.getPointAtPage(this);
        g.translate(thisAtPage.x, thisAtPage.y);
        Point delta = this.getDelta(dragStartPoint, dragCurrentPoint);
        Line line = null;
        if (!isEnd) {
            line = this.getAdjustingLine(delta);
        }
        LineAdjustRenderer rd = new LineAdjustRenderer();
        rd.draw(this, g, this.lastDragLine, line);
        this.lastDragLine = line;
        if (isEnd) {
            this.setDividerLocation(this.getDividerLocation() + (this._isHSplit ? delta.x : delta.y));
        }
        if (line != null) {
            if (hRuler != null && this.isHorizontalSplit()) {
                RulerMark hRulerMark = new RulerMark(line.getX1() + thisAtPage.x, line.getX2() + thisAtPage.x);
                hRuler.setMarkPosition(hRulerMark);
            }
            if (vRuler != null && !this.isHorizontalSplit()) {
                RulerMark vRulerMark = new RulerMark(line.getY1() + thisAtPage.y, line.getY2() + thisAtPage.y);
                vRuler.setMarkPosition(vRulerMark);
            }
        }
    }

    private Point getDelta(Point dragStartPoint, Point dragCurrentPoint) {
        int length;
        int deltaValue;
        Point delta = dragCurrentPoint;
        delta.translate(-dragStartPoint.x, -dragStartPoint.y);
        if (this._isHSplit) {
            deltaValue = delta.x;
            length = this.getWidth() - 8 - 20;
        } else {
            deltaValue = delta.y;
            length = this.getHeight() - 8 - 20;
        }
        int newValue = this.getDividerLocation() + deltaValue;
        if (deltaValue < 0 && newValue < 0) {
            deltaValue = -this.getDividerLocation();
        } else if (newValue > length && (deltaValue = length - this.getDividerLocation()) < 0) {
            deltaValue = 0;
        }
        if (this._isHSplit) {
            delta.x = deltaValue;
        } else {
            delta.y = deltaValue;
        }
        return delta;
    }

    private Line getAdjustingLine(Point delta) {
        int halfW = 4;
        if (this._isHSplit) {
            int x = this.getDividerLocation() + delta.x + halfW;
            return new Line(x, halfW, x, this.getHeight() - halfW);
        }
        int y = this.getDividerLocation() + delta.y + halfW;
        return new Line(halfW, y, this.getWidth() - halfW, y);
    }

    @Override
    public ElementPath getSelection(Point ptAtPage) {
        return null;
    }

    @Override
    public ElementPath[] getSelection(ReportSelectionModel selectionModel, ElementPath elePath) {
        return null;
    }

    @Override
    public String getType() {
        return "SplitPane";
    }

    @Override
    protected String[] propertyPanelKeys(ICompositeObject co) {
        return new String[]{"splitPane"};
    }
}

