/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui.ResourceManager;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class CrosstabWordsStylePanel
extends KDPanel {
    private KDList itemsList;
    private KDWorkButton wbtStyle;
    private HashMap currentStyles;
    private HashMap itemAlias;
    private List listeners;

    public CrosstabWordsStylePanel(HashMap styles, HashMap itemAlias, String[] displays) {
        this.initCtrls(styles, itemAlias, displays);
    }

    public HashMap getStyles() {
        return this.currentStyles;
    }

    private void initCtrls(HashMap styles, HashMap itemAlias, String[] displays) {
        this.currentStyles = styles;
        this.itemAlias = itemAlias;
        this.wbtStyle = new KDWorkButton();
        this.wbtStyle.setIcon((Icon)ResourceManager.getImageIcon("icons/tbtn_mode.gif"));
        this.wbtStyle.setText("\u8bbe\u7f6e");
        this.wbtStyle.setToolTipText("\u8bbe\u8ba1\u6587\u5b57/\u8868\u5934\u5c5e\u6027");
        this.itemsList = new KDList();
        for (int i = 0; i < displays.length; ++i) {
            this.itemsList.addElement((Object)displays[i]);
        }
        if (this.itemsList.getElementCount() > 0) {
            this.itemsList.setSelectedIndex(0);
        }
        TableLayout layout = TableLayout.split((int)2, (int)1);
        layout.style().setMargin(10);
        layout.style().setMarginTop(25);
        this.setLayout((LayoutManager)layout);
        this.wbtStyle.setMinimumSize(new Dimension(26, 19));
        layout.rowStyle(1).setPriY(1);
        Table table = layout.cell(0, 0).split(1, 2);
        table.colStyle(0).setPriX(1);
        this.add((Component)this.wbtStyle, table.cell(0, 1));
        this.add((Component)this.itemsList, layout.cell(1, 0));
        this.initCtrls_Listeners();
    }

    private void initCtrls_Listeners() {
        this.wbtStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrosstabWordsStylePanel.this.openSytleDialog();
            }
        });
        this.itemsList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CrosstabWordsStylePanel.this.openSytleDialog();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void openSytleDialog() {
        int itemIndex = this.itemsList.getSelectedIndex();
        if (itemIndex == -1) {
            return;
        }
        String alias = (String)this.itemsList.getElement(itemIndex);
        String item = (String)this.itemAlias.get(alias);
        this.openSytleDialog(item, alias);
    }

    private void openSytleDialog(String item, String alias) {
        Frame f = JOptionPane.getFrameForComponent((Component)((Object)this));
        LazyStyleDesigner sd = new LazyStyleDesigner(f);
        sd.setPanels(new String[]{"font", "alignment", "interior", "format"});
        StyleAttributes sa = (StyleAttributes)this.currentStyles.get(item);
        sd.setSA(sa == null ? Styles.getDefaultSA() : sa);
        sd.setTitle(alias);
        sd.setLocationRelativeTo(null);
        sd.showDialog();
        boolean needFire = false;
        if (sd.isChanged()) {
            this.currentStyles.put(item, sd.getSA());
            needFire = true;
        }
        sd.dispose();
        if (needFire) {
            this.fireItemStyleChangedEvent(item);
        }
    }

    public void addItemStyleChangedListener(ItemStyleChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public boolean removeItemStyleChangedListener(ItemStyleChangedListener listener) {
        if (this.listeners != null) {
            return this.listeners.remove(listener);
        }
        return false;
    }

    private void fireItemStyleChangedEvent(String item) {
        if (this.listeners != null) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((ItemStyleChangedListener)i.next()).onStyleChanged(item);
            }
        }
    }

    public static interface ItemStyleChangedListener {
        public void onStyleChanged(String var1);
    }
}

