/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.table;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractNormalRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.DataGridUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.script.ScriptExecutor;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.datagrid.FormDataCell;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.datagrid.FormDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.table.ATableView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.table.CellScriptable;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.table.RowScriptable;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.table.TableCellTreeProccessor;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.exception.AssertException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.NameIndex;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.AGGExporter;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.RowContext;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGCol;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGRow;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGRowType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GroupingGrid;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class R1DataTable
extends ATableView
implements KDTDataRequestListener {
    private static final Logger log = LogUtil.getPackageLogger(R1DataTable.class);
    private int colCount;
    private ResultSet data;
    private GG2KDTable engine;
    private GroupingGrid schema;
    private boolean hiddenRow;
    private TableCellTreeProccessor cellTreeProccessor;

    @Override
    public void setTable(KDTable table) {
        super.setTable(table);
    }

    @Override
    public void updateView() throws SQLException {
        FormDataGrid dataGrid = (FormDataGrid)this.schema.getUserObject();
        this.engine = new GG2KDTable();
        this.engine.init(this.schema, this.data);
        this.colCount = this.schema.getColCount();
        KDTable kdt = this.getTable();
        kdt.removeColumns();
        kdt.addColumns(this.colCount);
        if (dataGrid.get_numFreezeColumn() > 0) {
            kdt.getViewManager().setFreezeView(0, dataGrid.get_numFreezeColumn());
        }
        this.cellTreeProccessor = null;
        kdt.getDataRequestManager().setDataRequestMode(1);
        kdt.getDataRequestManager().setPageRowCount(100);
        for (int i = 0; i < this.colCount; ++i) {
            AbstractColumn dsgCol = dataGrid.getColumn(i);
            IColumn kdtCol = kdt.getColumn(i);
            kdtCol.setWidth(dsgCol.getFeatWidth());
            StyleAttributes sa = kdtCol.getStyleAttributes();
            if (sa != null) {
                sa.setHided(dsgCol.isHide());
            }
            if ((sa = dsgCol.getStyleAttribute()) == null) continue;
            kdtCol.setStyleAttributes(sa);
        }
        kdt.refresh();
    }

    public final GroupingGrid getSchema() {
        return this.schema;
    }

    public final void setSchema(GroupingGrid gridSchema) {
        this.schema = gridSchema;
    }

    public ResultSet getData() {
        return this.data;
    }

    public void setData(ResultSet resultSet) {
        this.data = resultSet;
    }

    private void addFixedHeadRows(KDTable kdt) {
        int z = this.schema.getRowCount();
        for (int i = 0; i < z; ++i) {
            GGRow ggRow = this.schema.getRow(i);
            if (GGRowType.HEAD != ggRow.getType()) continue;
            IRow kdtRow = kdt.addHeadRow();
            for (int j = 0; j < this.colCount; ++j) {
                ICellValue cellValue;
                ICell kdtCell = kdtRow.getCell(j);
                GGCell ggCell = ggRow.getCell(j);
                CellUserObject uo = (CellUserObject)ggCell.getUserObject();
                StyleAttributes sa = uo.dsgCell.getStyleAttribute();
                if (sa != null) {
                    kdtCell.setStyleAttributes(sa);
                }
                if ((cellValue = uo.dsgCell.getValue()) == null) continue;
                kdtCell.setValue((Object)((Text)cellValue).getText());
            }
        }
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        log.debug((Object)e);
        int start = e.getFirstRow();
        int last = e.getLastRow();
        try {
            if (start == 0) {
                int z = this.schema.getRowCount();
                for (int i = 0; i < z; ++i) {
                    if (GGRowType.HEAD != this.schema.getRow(i).getType()) continue;
                    --start;
                }
            }
            KDTable kdt = this.getTable();
            kdt.setRefresh(false);
            int i = start;
            while (i <= last) {
                if (!this.engine.exportARow()) {
                    if (start >= 0 || i != start) break;
                    this.addFixedHeadRows(kdt);
                    break;
                }
                if (this.hiddenRow) continue;
                ++i;
            }
            KDTColumns columns = new KDTColumns(kdt);
            for (int i2 = 0; i2 < kdt.getColumnCount(); ++i2) {
                columns.addColumn(kdt.getColumn(i2).getKDTColumn());
                GGCol col = this.schema.getCol(i2);
                if (((AbstractColumn)col.getUserObject()).isFixedWidth()) continue;
                columns.autoFitColumnWidth(i2, 1);
            }
            if (this.cellTreeProccessor != null) {
                this.cellTreeProccessor.processLast();
            }
            kdt.setRefresh(true);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    public static GroupingGrid parseDataGrid(FormDataGrid dsgGrid) {
        GroupingGrid grid = new GroupingGrid();
        grid.setUserObject(dsgGrid);
        int colCount = dsgGrid.getColumnsCount();
        grid.setColCount(colCount);
        for (int j = 0; j < colCount; ++j) {
            grid.setCol(j, R1DataTable.parseCol(dsgGrid.getColumn(j)));
        }
        int headRowCount = dsgGrid.getHeadRowCount();
        int z = dsgGrid.getRowsCount();
        for (int i = 0; i < z; ++i) {
            AbstractRow dsgRow = dsgGrid.getRow(i);
            GGRow row = grid.addRow();
            R1DataTable.parseRow(dsgRow, row, dsgGrid);
            if (i >= headRowCount) continue;
            row.setType(GGRowType.HEAD);
        }
        return grid;
    }

    private static GGCol parseCol(AbstractColumn dsgCol) {
        GGCol col = new GGCol();
        col.setUserObject(dsgCol);
        return col;
    }

    private static void parseRow(AbstractRow dsgRow, GGRow row, FormDataGrid dsgGrid) {
        int c = dsgRow.getCellCount();
        row.setUserObject(dsgRow);
        row.setHidden(dsgRow.isHide());
        GGRowType rowType = null;
        if (dsgRow instanceof AbstractGroupRow) {
            rowType = GGRowType.GROUP;
            row.setGroupCol(NameIndex.valueOf(((AbstractGroupRow)dsgRow).getGroup().getAccording()));
        } else if (dsgRow instanceof AbstractNormalRow) {
            rowType = GGRowType.TOTAL;
        } else if (dsgRow instanceof AbstractDetailRow) {
            rowType = GGRowType.DETAIL;
        } else {
            throw new AssertException("\u4e0d\u652f\u6301\u7684\u884c\u7c7b\u578b\uff1a" + dsgRow);
        }
        row.setType(rowType);
        for (int j = 0; j < c; ++j) {
            FormDataCell dsgCell = (FormDataCell)dsgRow.getCell(j);
            row.setCell(j, R1DataTable.parseCell(rowType, dsgCell, dsgGrid));
        }
    }

    private static GGCell parseCell(GGRowType rowType, FormDataCell dsgCell, FormDataGrid dsgGrid) {
        GGCell cell = new GGCell();
        cell.setUserObject(dsgCell);
        ICellValue cellValue = dsgCell.getValue();
        if (cellValue != null) {
            switch (cellValue.getCellType()) {
                case 2: {
                    cell.setDataCol(R1DataTable.parseField((CellField)cellValue));
                    if (GGRowType.DETAIL == rowType) break;
                    cell.setStatType("GET");
                    break;
                }
                case 3: {
                    cell.setDataCol(R1DataTable.parseField(((StatField)cellValue).getField()));
                    cell.setStatType(R1DataTable.parseStat((StatField)cellValue));
                    break;
                }
            }
        }
        CellUserObject uo = new CellUserObject();
        uo.dsgCell = dsgCell;
        cell.setUserObject(uo);
        if (dsgCell.isExectuedMerge()) {
            uo.mergeLevel = DataGridUtil.groupField2Level(dsgGrid, dsgCell.getExectuedMergeRange());
        }
        if (dsgCell.isVirtualField()) {
            NameIndex treeCol = R1DataTable.parseField((CellField)dsgCell.getVirtualField());
            cell.setCellTreeDefine(new GGCell.GGCellTreeDefine(treeCol, dsgCell.getVirtualOption()));
        }
        return cell;
    }

    private static NameIndex parseField(Field field) {
        NameIndex columnLocation = NameIndex.valueOf(field.getName());
        return columnLocation;
    }

    private static String parseStat(StatField designStat) {
        switch (designStat.getType()) {
            case 1: {
                return "SUM";
            }
            case 2: {
                return "AVG";
            }
            case 3: {
                return "MAX";
            }
            case 4: {
                return "MIN";
            }
            case 5: {
                return "COUNT";
            }
        }
        return "GET";
    }

    class GG2KDTable
    extends AGGExporter {
        private ScriptExecutor scriptExecutor = ScriptExecutor.getInstance();
        private CellScriptable cellScriptable = new CellScriptable();
        private RowScriptable rowScriptable = new RowScriptable();

        @Override
        protected void init(GroupingGrid grid, ResultSet rows) throws SQLException {
            super.init(grid, rows);
        }

        protected void mergeKdtCell(KDTable table, IRow kdtRow, ICell kdtCell, ICell kdtCellRef) {
            if (kdtCellRef == null) {
                kdtCellRef = kdtCell;
            }
            KDTMergeBlock mb = kdtCellRef.getMergeBlock();
            KDTMergeBlock newMb = new KDTMergeBlock();
            if (mb == null) {
                newMb.setLeft(kdtCellRef.getColumnIndex());
                newMb.setTop(kdtCellRef.getRowIndex());
            } else {
                newMb = mb;
            }
            newMb.setBottom(kdtRow.getRowIndex());
            newMb.setRight(kdtCell.getColumnIndex());
            table.getMergeManager().mergeBlock(newMb);
        }

        @Override
        protected void exportARow(RowContext ctx) throws Exception {
            GGRow ggRow = ctx.getRowPattern();
            AbstractRow dsgRow = (AbstractRow)ggRow.getUserObject();
            R1DataTable.this.hiddenRow = dsgRow.isHide();
            if (R1DataTable.this.hiddenRow) {
                return;
            }
            KDTable kdt = R1DataTable.this.getTable();
            IRow kdtRow = ggRow.getType() == GGRowType.HEAD ? kdt.addHeadRow() : kdt.addRow();
            StyleAttributes sa = dsgRow.getStyleAttribute();
            if (sa != null) {
                kdtRow.setStyleAttributes(sa);
            }
            kdtRow.setHeight(dsgRow.getFeatHeight());
            boolean isDetailRow = ctx.isDetailRow();
            for (int i = 0; i < this.colCount; ++i) {
                GGCell ggCell = ggRow.getCell(i);
                if (ggCell == null) continue;
                CellUserObject cellUserObj = (CellUserObject)ggCell.getUserObject();
                ICell kdtCell = kdtRow.getCell(i);
                this.outputCellStyle(kdtCell, cellUserObj);
                Object val = this.getCellValue(ggCell, ctx);
                if (isDetailRow && cellUserObj.mergeLevel >= 0) {
                    if (ObjectUtil.equals((Object)cellUserObj.value, (Object)val)) {
                        int groupIndex = ctx.getGroupRS(cellUserObj.mergeLevel).getRow();
                        if (cellUserObj.groupIndex == groupIndex) {
                            this.mergeKdtCell(kdt, kdtRow, kdtCell, cellUserObj.kdtCellRef);
                        } else {
                            cellUserObj.groupIndex = groupIndex;
                        }
                    } else {
                        cellUserObj.groupIndex = ctx.getGroupRS(cellUserObj.mergeLevel).getRow();
                    }
                    cellUserObj.kdtCellRef = kdtCell;
                    cellUserObj.value = val;
                }
                kdtCell.setValue(val);
                if (isDetailRow && ggCell.getCellTreeDefine() != null) {
                    this.outoutCellTree(kdtCell, ggCell.getCellTreeDefine(), ctx);
                }
                this.outputCellScript(kdtCell, cellUserObj);
            }
            this.outputRowScript(kdtRow, dsgRow);
        }

        private Object getCellValue(GGCell ggCell, RowContext ctx) throws SQLException {
            CellUserObject uo = (CellUserObject)ggCell.getUserObject();
            if (ggCell.getDataCol() != null) {
                if (uo.colIndex == -1) {
                    uo.colIndex = this.findColIndex(ggCell, ctx);
                }
                return ctx.getRowRS().getObject(uo.colIndex);
            }
            ICellValue cellValue = uo.dsgCell.getValue();
            if (cellValue != null) {
                return ((Text)cellValue).getText();
            }
            return null;
        }

        private void outputCellStyle(ICell kdtCell, CellUserObject uo) throws SQLException {
            StyleAttributes sa = uo.dsgCell.getStyleAttribute();
            if (sa != null) {
                kdtCell.setStyleAttributes(sa);
            }
        }

        private void outputRowScript(IRow kdtRow, AbstractRow dsgRow) {
            String script = dsgRow.getScript();
            if (!StringUtil.isEmptyString((String)script)) {
                this.rowScriptable.setRow(kdtRow);
                try {
                    this.scriptExecutor.execute(script, this.rowScriptable, null);
                }
                catch (Exception ex) {
                    log.error((Object)("Error script:\r\n" + script), (Throwable)ex);
                }
            }
        }

        private void outputCellScript(ICell kdtCell, CellUserObject uo) throws SQLException {
            String script = uo.dsgCell.getScript();
            if (!StringUtil.isEmptyString((String)script)) {
                this.cellScriptable.setCell(kdtCell);
                try {
                    this.scriptExecutor.execute(script, this.cellScriptable, null);
                }
                catch (Exception ex) {
                    log.error((Object)("Error script:\r\n" + script), (Throwable)ex);
                }
            }
        }

        private void outoutCellTree(ICell kdtCell, GGCell.GGCellTreeDefine treeDef, RowContext ctx) throws SQLException {
            if (R1DataTable.this.cellTreeProccessor == null) {
                R1DataTable.this.cellTreeProccessor = new TableCellTreeProccessor();
                R1DataTable.this.cellTreeProccessor.setSplitStrs(treeDef.option);
            }
            R1DataTable.this.cellTreeProccessor.process(kdtCell, ctx.getRowRS().getString(treeDef.treeCol.getIndex()));
        }
    }

    private static class CellUserObject {
        int colIndex = -1;
        FormDataCell dsgCell;
        int mergeLevel = -1;
        int groupIndex = 0;
        Object value;
        ICell kdtCellRef;

        private CellUserObject() {
        }
    }
}

