/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.print.xls.AR1PNode_V2X;
import com.kingdee.bos.ctrl.print.xls.widget.IXlsNode;
import com.kingdee.bos.ctrl.print.xls.widget.XlsContainer;
import com.kingdee.bos.ctrl.print.xls.widget.XlsImageCell;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarCodeCell;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BarcodeUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;

public class BarcodeCell_V2X
extends AR1PNode_V2X {
    protected IXlsNode createXlsNode() {
        return new XlsImageCell();
    }

    protected void exportSpecial(IPainter painter, IXlsNode xlsObj) {
        BarCodeCell barcodeCell = (BarCodeCell)painter;
        Map barcodeConfig = barcodeCell.getConfig();
        Rectangle2D.Float rc = painter.getPainterBounds();
        rc = (Rectangle2D.Float)rc.clone();
        double widthLom = KDPrinterUtils.printPointToLom((double)rc.width);
        double heightLom = KDPrinterUtils.printPointToLom((double)rc.height);
        Integer barcodeDpi = (Integer)barcodeConfig.get("dpi");
        if (barcodeDpi == null) {
            barcodeDpi = 300;
        }
        int imageWidth = this.toInt(widthLom / (double)254.3f * (double)barcodeDpi.intValue());
        int imageHeight = this.toInt(heightLom / (double)254.3f * (double)barcodeDpi.intValue());
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageHeight, 5);
        Graphics2D graphics = bufferedImage.createGraphics();
        BarcodeUtils.paintBarcode(graphics, imageWidth, imageHeight, barcodeConfig);
        graphics.dispose();
        XlsImageCell xlsCell = (XlsImageCell)xlsObj;
        xlsCell.setImage((Image)bufferedImage);
        xlsCell.setScaleModel(1);
        IXlsNode parent = xlsObj.getParent();
        if (parent instanceof XlsContainer) {
            ((XlsContainer)parent).setPicContianer();
        }
    }

    private int toInt(double value) {
        return (int)Math.round(value);
    }
}

