/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Dimension;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterResolution;
import org.jdom2.Content;
import org.jdom2.Element;

public class R1PrintInfo {
    public static final String PORTRAIT = "PORTRAIT";
    public static final String LANDSCAPE = "LANDSCAPE";
    public static final String CustomPaper = "Custom";
    private String _paperName = "iso-a4";
    private String _orientation = "PORTRAIT";
    private int _paperWidth = 2100;
    private int _paperHeight = 2970;
    private int _marginLeft = 190;
    private int _marginRight = 190;
    private int _marginTop = 250;
    private int _marginBottom = 250;
    private int _headerHeight = 150;
    private int _headerMargin = 100;
    private int _footerHeight = 150;
    private int _footerMargin = 100;
    private boolean _isDynamicPaper;
    private boolean _isVerEconomizePaper;
    private boolean _isHorEconomizePaper;
    private int _verPageSpace = 0;
    private int _horPageSpace = 0;
    private PrinterResolution _printerResolution = null;
    private boolean _haveBackgroundPicture;

    public static String[] getAllPaperNames() {
        return new MyMediaSizeName().getStringTable();
    }

    public static Element toXml(R1PrintInfo printInfo) {
        Element xmlPaperName = new Element("Paper");
        Element xmlOrientation = new Element("Orientation");
        Element xmlPageMargin = new Element("PageMargin");
        Element xmlHeader = new Element("Header");
        Element xmlFooter = new Element("Footer");
        xmlPaperName.addContent(printInfo.getPaperName());
        if (printInfo.isCustomPaper()) {
            xmlPaperName.setAttribute("width", Integer.toString(printInfo.getCustomWidth()));
            xmlPaperName.setAttribute("height", Integer.toString(printInfo.getCustomHeight()));
        }
        xmlOrientation.addContent(printInfo.getOrientation());
        xmlPageMargin.setAttribute("left", Integer.toString(printInfo.getMarginLeft()));
        xmlPageMargin.setAttribute("right", Integer.toString(printInfo.getMarginRight()));
        xmlPageMargin.setAttribute("top", Integer.toString(printInfo.getMarginTop()));
        xmlPageMargin.setAttribute("bottom", Integer.toString(printInfo.getMarginBottom()));
        xmlHeader.setAttribute("height", Integer.toString(printInfo.getHeaderHeight()));
        xmlHeader.setAttribute("margin", Integer.toString(printInfo.getHeaderMargin()));
        xmlFooter.setAttribute("height", Integer.toString(printInfo.getFooterHeight()));
        xmlFooter.setAttribute("margin", Integer.toString(printInfo.getFooterMargin()));
        Element xmlDynamicPaper = new Element("DynamicPaper");
        xmlDynamicPaper.addContent(Boolean.toString(printInfo.isDynamicPaper()));
        Element xmlEconomizePaper = new Element("EconomizePaper");
        xmlEconomizePaper.setAttribute("isVerEconomizePaper", Boolean.toString(printInfo.isVerEconomizePaper()));
        if (printInfo.isVerEconomizePaper()) {
            xmlEconomizePaper.setAttribute("verSpace", Integer.toString(printInfo.getVerPageSpace()));
        } else {
            xmlEconomizePaper.setAttribute("verSpace", "0");
        }
        xmlEconomizePaper.setAttribute("isHorEconomizePaper", Boolean.toString(printInfo.isHorEconomizePaper()));
        if (printInfo.isHorEconomizePaper()) {
            xmlEconomizePaper.setAttribute("horSpace", Integer.toString(printInfo.getHorPageSpace()));
        } else {
            xmlEconomizePaper.setAttribute("horSpace", "0");
        }
        Element xmlDpi = null;
        PrinterResolution printerResolution = printInfo.getPrinterResolution();
        if (printerResolution != null) {
            xmlDpi = new Element("Dpi");
            int xDpis = printerResolution.getCrossFeedResolution(100);
            int yDpis = printerResolution.getFeedResolution(100);
            xmlDpi.setAttribute("xDpis", Integer.toString(xDpis));
            xmlDpi.setAttribute("yDpis", Integer.toString(yDpis));
        }
        Element xmlBackground = new Element("BackgroundPicture");
        xmlBackground.addContent(Boolean.toString(printInfo.getHaveBackground()));
        Element xmlPaperSetup = new Element("PaperSetup");
        Element xmlPrinterSetup = new Element("PrinterSetup");
        Element xmlPreviewSetup = new Element("PreviewSetup");
        xmlPaperSetup.addContent((Content)xmlPaperName);
        xmlPaperSetup.addContent((Content)xmlOrientation);
        xmlPaperSetup.addContent((Content)xmlPageMargin);
        xmlPaperSetup.addContent((Content)xmlHeader);
        xmlPaperSetup.addContent((Content)xmlFooter);
        xmlPrinterSetup.addContent((Content)xmlDynamicPaper);
        xmlPrinterSetup.addContent((Content)xmlEconomizePaper);
        if (xmlDpi != null) {
            xmlPrinterSetup.addContent((Content)xmlDpi);
        }
        xmlPreviewSetup.addContent((Content)xmlBackground);
        Element xmlPrintInfo = new Element("PrintInfo");
        xmlPrintInfo.addContent((Content)xmlPaperSetup);
        xmlPrintInfo.addContent((Content)xmlPrinterSetup);
        xmlPrintInfo.addContent((Content)xmlPreviewSetup);
        return xmlPrintInfo;
    }

    public static R1PrintInfo fromXml(Element xmlNode) {
        Element xmlPreviewSetup;
        Element xmlBackground;
        Element dpi;
        Element xmlEconomizePaper;
        R1PrintInfo info = new R1PrintInfo();
        Element xmlPaperSetup = xmlNode.getChild("PaperSetup");
        Element xmlPaperName = xmlPaperSetup.getChild("Paper");
        Element xmlOrientation = xmlPaperSetup.getChild("Orientation");
        Element xmlPageMargin = xmlPaperSetup.getChild("PageMargin");
        Element xmlHeader = xmlPaperSetup.getChild("Header");
        Element xmlFooter = xmlPaperSetup.getChild("Footer");
        info.setPaperName(xmlPaperName.getTextTrim());
        if (info.isCustomPaper()) {
            int w = Integer.parseInt(xmlPaperName.getAttributeValue("width"));
            int h = Integer.parseInt(xmlPaperName.getAttributeValue("height"));
            info.setCustomPaper(w, h);
        }
        if (StringUtil.equals((String)LANDSCAPE, (String)xmlOrientation.getTextTrim())) {
            info.setOrientation(LANDSCAPE);
        } else {
            info.setOrientation(PORTRAIT);
        }
        info.setMarginLeft(Integer.parseInt(xmlPageMargin.getAttributeValue("left")));
        info.setMarginRight(Integer.parseInt(xmlPageMargin.getAttributeValue("right")));
        info.setMarginTop(Integer.parseInt(xmlPageMargin.getAttributeValue("top")));
        info.setMarginBottom(Integer.parseInt(xmlPageMargin.getAttributeValue("bottom")));
        info.setHeaderHeight(Integer.parseInt(xmlHeader.getAttributeValue("height")));
        info.setHeaderMargin(Integer.parseInt(xmlHeader.getAttributeValue("margin")));
        info.setFooterHeight(Integer.parseInt(xmlFooter.getAttributeValue("height")));
        info.setFooterMargin(Integer.parseInt(xmlFooter.getAttributeValue("margin")));
        Element xmlPrinterSetup = xmlNode.getChild("PrinterSetup");
        Element xmlDynamicPaper = xmlPrinterSetup.getChild("DynamicPaper");
        if (xmlDynamicPaper != null) {
            info.setDynamicPaper(new Boolean(xmlDynamicPaper.getTextTrim()));
        }
        if ((xmlEconomizePaper = xmlPrinterSetup.getChild("EconomizePaper")) != null) {
            if ("true".equalsIgnoreCase(xmlEconomizePaper.getTextTrim())) {
                info.setVerEconomizePaper(true);
                info.setVerPageSpace(10);
            } else {
                info.setVerEconomizePaper(false);
            }
            if (xmlEconomizePaper.getAttributeValue("isVerEconomizePaper") != null) {
                info.setVerEconomizePaper(new Boolean(xmlEconomizePaper.getAttributeValue("isVerEconomizePaper")));
            }
            if (xmlEconomizePaper.getAttributeValue("verSpace") != null) {
                info.setVerPageSpace(Integer.parseInt(xmlEconomizePaper.getAttributeValue("verSpace")));
            }
            if (xmlEconomizePaper.getAttributeValue("isHorEconomizePaper") != null) {
                info.setHorEconomizePaper(new Boolean(xmlEconomizePaper.getAttributeValue("isHorEconomizePaper")));
            }
            if (xmlEconomizePaper.getAttributeValue("horSpace") != null) {
                info.setHorPageSpace(Integer.parseInt(xmlEconomizePaper.getAttributeValue("horSpace")));
            }
        }
        if ((dpi = xmlPrinterSetup.getChild("Dpi")) != null) {
            int xDpis = Integer.parseInt(dpi.getAttributeValue("xDpis"));
            int yDpis = Integer.parseInt(dpi.getAttributeValue("yDpis"));
            PrinterResolution printerResolution = new PrinterResolution(xDpis, yDpis, 100);
            info.setPrinterResolution(printerResolution);
        }
        if ((xmlBackground = (xmlPreviewSetup = xmlNode.getChild("PreviewSetup")).getChild("BackgroundPicture")) != null) {
            info.setHaveBackground(new Boolean(xmlBackground.getTextTrim()));
        }
        return info;
    }

    public static Dimension getPaperSize(String paperName) {
        MediaSizeName msn = KDPrinterUtils.getMediaSizeName((String)paperName);
        MediaSize ms = MediaSize.getMediaSizeForName(msn);
        int w = (int)ms.getX(1000) * 10;
        int h = (int)ms.getY(1000) * 10;
        return new Dimension(w, h);
    }

    public R1PrintInfo() {
    }

    public R1PrintInfo(R1PrintInfo old) {
        this._paperName = old._paperName;
        this._orientation = old._orientation;
        this._paperWidth = old._paperWidth;
        this._paperHeight = old._paperHeight;
        this._marginLeft = old._marginLeft;
        this._marginRight = old._marginRight;
        this._marginTop = old._marginTop;
        this._marginBottom = old._marginBottom;
        this._headerHeight = old._headerHeight;
        this._headerMargin = old._headerMargin;
        this._footerHeight = old._footerHeight;
        this._footerMargin = old._footerMargin;
        this._isDynamicPaper = old._isDynamicPaper;
        this._isVerEconomizePaper = old._isVerEconomizePaper;
        this._isHorEconomizePaper = old._isHorEconomizePaper;
        this._horPageSpace = old._horPageSpace;
        this._verPageSpace = old._verPageSpace;
        this._printerResolution = old._printerResolution;
        this._haveBackgroundPicture = old._haveBackgroundPicture;
    }

    public String getPaperName() {
        return this._paperName;
    }

    public void setPaperName(String name) {
        this._paperName = name;
    }

    public boolean isCustomPaper() {
        return StringUtil.equalsIgnoreCase((String)this.getPaperName(), (String)CustomPaper);
    }

    public void setCustomPaper(int width, int height) {
        this.setPaperName(CustomPaper);
        this._paperWidth = width;
        this._paperHeight = height;
    }

    public String getOrientation() {
        return this._orientation;
    }

    public void setOrientation(String orientation) {
        this._orientation = orientation;
    }

    public int getCustomWidth() {
        return this._paperWidth;
    }

    public int getCustomHeight() {
        return this._paperHeight;
    }

    public Dimension getPaperSize() {
        if (this.isCustomPaper()) {
            return new Dimension(this.getCustomWidth(), this.getCustomHeight());
        }
        return R1PrintInfo.getPaperSize(this.getPaperName());
    }

    public Dimension getPrintablePaperSize() {
        int height;
        int width;
        Dimension paperSize = this.getPaperSize();
        if (this.getOrientation() == LANDSCAPE) {
            width = paperSize.height;
            height = paperSize.width;
        } else {
            width = paperSize.width;
            height = paperSize.height;
        }
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        return new Dimension(width, height);
    }

    public Dimension getPrintableAreaSize() {
        int height;
        int width;
        Dimension paperSize = this.getPaperSize();
        if (this.getOrientation() == LANDSCAPE) {
            width = paperSize.height - this.getMarginLeft() - this.getMarginRight();
            height = paperSize.width - this.getMarginTop() - this.getMarginBottom();
        } else {
            width = paperSize.width - this.getMarginLeft() - this.getMarginRight();
            height = paperSize.height - this.getMarginTop() - this.getMarginBottom();
        }
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        return new Dimension(width, height);
    }

    public void setPrintableAreaSize(Dimension pageSize) {
        int height;
        int width;
        if (this.getOrientation() == LANDSCAPE) {
            width = pageSize.height + this.getMarginTop() + this.getMarginBottom();
            height = pageSize.width + this.getMarginLeft() + this.getMarginRight();
        } else {
            width = pageSize.width + this.getMarginLeft() + this.getMarginRight();
            height = pageSize.height + this.getMarginTop() + this.getMarginBottom();
        }
        this.setCustomPaper(width, height);
    }

    public void setMarginLeft(int marginLeft) {
        this._marginLeft = marginLeft;
    }

    public int getMarginLeft() {
        return this._marginLeft;
    }

    public void setMarginRight(int marginRight) {
        this._marginRight = marginRight;
    }

    public int getMarginRight() {
        return this._marginRight;
    }

    public void setMarginTop(int marginTop) {
        this._marginTop = marginTop;
    }

    public int getMarginTop() {
        return this._marginTop;
    }

    public void setMarginBottom(int marginBottom) {
        this._marginBottom = marginBottom;
    }

    public int getMarginBottom() {
        return this._marginBottom;
    }

    public boolean isDynamicPaper() {
        return this._isDynamicPaper;
    }

    public void setDynamicPaper(boolean isDynamicPaper) {
        this._isDynamicPaper = isDynamicPaper;
    }

    public int getHeaderHeight() {
        return this._headerHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        this._headerHeight = headerHeight;
    }

    public int getHeaderMargin() {
        return this._headerMargin;
    }

    public void setHeaderMargin(int headerMargin) {
        this._headerMargin = headerMargin;
    }

    public int getFooterHeight() {
        return this._footerHeight;
    }

    public void setFooterHeight(int footerHeight) {
        this._footerHeight = footerHeight;
    }

    public int getFooterMargin() {
        return this._footerMargin;
    }

    public void setFooterMargin(int footerMargin) {
        this._footerMargin = footerMargin;
    }

    public boolean getHaveBackground() {
        return this._haveBackgroundPicture;
    }

    public void setHaveBackground(boolean have) {
        this._haveBackgroundPicture = have;
    }

    public boolean isVerEconomizePaper() {
        return this._isVerEconomizePaper;
    }

    public void setVerEconomizePaper(boolean isVerEconomize) {
        this._isVerEconomizePaper = isVerEconomize;
    }

    public boolean isHorEconomizePaper() {
        return this._isHorEconomizePaper;
    }

    public void setHorEconomizePaper(boolean isHorEconomize) {
        this._isHorEconomizePaper = isHorEconomize;
    }

    public int getHorPageSpace() {
        return this._horPageSpace;
    }

    public void setHorPageSpace(int pageSpace) {
        this._horPageSpace = pageSpace;
    }

    public int getVerPageSpace() {
        return this._verPageSpace;
    }

    public void setVerPageSpace(int pageSpace) {
        this._verPageSpace = pageSpace;
    }

    public PrinterResolution getPrinterResolution() {
        return this._printerResolution;
    }

    public void setPrinterResolution(PrinterResolution printerResolution) {
        this._printerResolution = printerResolution;
    }

    static class MyMediaSizeName
    extends MediaSizeName {
        protected MyMediaSizeName() {
            super(0);
        }

        @Override
        public String[] getStringTable() {
            return super.getStringTable();
        }
    }
}

