/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common.currency;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.currency.ICurrencyUpperFunction;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.common.currency.CurrencyFormatInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CurrencyFormatManager {
    private static final Logger log = LogUtil.getPackageLogger(CurrencyFormatManager.class);
    private static CurrencyFormatManager instance;
    private HashMap _infos;

    public static CurrencyFormatManager shareInstance() {
        if (instance == null) {
            instance = new CurrencyFormatManager();
        }
        return instance;
    }

    private HashMap getInfos() {
        if (this._infos == null) {
            this._infos = new HashMap();
            Element root = this.loadConfigFile();
            if (root != null) {
                this.parseConfigFile(root, this._infos);
            }
        }
        return this._infos;
    }

    private Element loadConfigFile() {
        InputStream is = null;
        try {
            is = GlobalLocator.getInstance().loadResourceFile("/client/r1/print/currencyformat.xml");
        }
        catch (FileNotFoundException e) {
            log.error((Object)"\u8bfb\u53d6\u91d1\u989d\u683c\u5f0f\u5316\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\u3002 ", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"\u8bfb\u53d6\u91d1\u989d\u683c\u5f0f\u5316\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\u3002 ", (Throwable)e);
        }
        Element root = null;
        try {
            root = XmlUtil.loadXmlStream((InputStream)is);
        }
        catch (IOException e) {
            log.error((Object)"\u89e3\u6790\u91d1\u989d\u683c\u5f0f\u5316\u914d\u7f6e\u6587\u4ef6XML\u683c\u5f0f\u5f02\u5e38\u3002 ", (Throwable)e);
        }
        catch (JDOMException e) {
            log.error((Object)"\u89e3\u6790\u91d1\u989d\u683c\u5f0f\u5316\u914d\u7f6e\u6587\u4ef6XML\u683c\u5f0f\u5f02\u5e38\u3002 ", (Throwable)e);
        }
        return root;
    }

    private void parseConfigFile(Element xmlRoot, HashMap mapInfos) {
        Element nodeFuncs = xmlRoot.getChild("UpperFormatFunctions");
        Element nodeCodes = xmlRoot.getChild("Codes");
        HashMap<String, ICurrencyUpperFunction> mapFuncs = new HashMap<String, ICurrencyUpperFunction>();
        for (Element nodeFunc : nodeFuncs.getChildren()) {
            ICurrencyUpperFunction func;
            String id = nodeFunc.getAttributeValue("id");
            String funcClassName = nodeFunc.getAttributeValue("function");
            if (StringUtil.isEmptyString((String)id) || StringUtil.isEmptyString((String)funcClassName) || (func = this.createUpperFunction(funcClassName)) == null) continue;
            mapFuncs.put(id, func);
        }
        for (Element nodeCode : nodeCodes.getChildren()) {
            String id = nodeCode.getAttributeValue("id");
            String symbol = nodeCode.getAttributeValue("symbol");
            String upperPrefix = nodeCode.getAttributeValue("upperPrefix");
            String upperFunc = nodeCode.getAttributeValue("upperFunction");
            if (StringUtil.isEmptyString((String)id)) continue;
            CurrencyFormatInfo info = new CurrencyFormatInfo();
            info.setCurrencyCode(id);
            info.setSymbol(symbol);
            info.setUpperPrefix(upperPrefix);
            info.setUpperFunction((ICurrencyUpperFunction)mapFuncs.get(upperFunc));
            mapInfos.put(id, info);
        }
    }

    private ICurrencyUpperFunction createUpperFunction(String className) {
        ICurrencyUpperFunction func = null;
        try {
            func = (ICurrencyUpperFunction)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002 " + className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002 " + className), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002 " + className), (Throwable)e);
        }
        catch (ClassCastException e) {
            log.error((Object)("\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002 " + className), (Throwable)e);
        }
        return func;
    }

    public String getSymbol(String code) {
        CurrencyFormatInfo info = (CurrencyFormatInfo)this.getInfos().get(code);
        if (info != null) {
            return info.getSymbol();
        }
        return "";
    }

    public ICurrencyUpperFunction getUpperFunction(String code) {
        CurrencyFormatInfo info = (CurrencyFormatInfo)this.getInfos().get(code);
        if (info != null) {
            return info.getUpperFunction();
        }
        return new DefaultUpperFunction();
    }

    public String upperFomat(String code, Locale locale, Variant value, boolean isAddPrefix) {
        return this.getUpperFunction(code).format(locale, value, isAddPrefix);
    }

    public String[] getAllCodes() {
        TreeSet set = new TreeSet(this.getInfos().keySet());
        return set.toArray(new String[0]);
    }

    static class DefaultUpperFunction
    implements ICurrencyUpperFunction {
        DefaultUpperFunction() {
        }

        public String format(Locale locale, Variant variant, boolean isAddPrefix) {
            return variant.toString();
        }
    }
}

