/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.R1DesignerRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractHExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import java.math.BigDecimal;

public class VExpr
extends AbstractExpr {
    public static final int TYPE_SUM = 16;
    public static final int TYPE_AVG = 32;
    public static final int TYPE_MAX = 64;
    public static final int TYPE_MIN = 128;
    public static final int TYPE_COUNT = 256;
    public static final int RANGE_GROUP = 1;
    public static final int RANGE_AREA = 2;
    public static final int RANGE_ADD = 4;
    public static final int RANGE_AREA_GROUP = 8;
    private static Variant SYS_MIN = new Variant(-1.7976931348623157E308);
    private static Variant SYS_MAX = new Variant(Double.MAX_VALUE);
    private boolean _showGroupStatLast = false;
    private int _level;
    private int _type;
    private int _range;
    private AbstractHExpr _hExpr;
    private int _hashCode;
    private int _count;
    private Variant _runtimeValue;
    private Variant _runtimeValue2;

    public VExpr(int type, int range, int level, AbstractHExpr hExpr) {
        this._type = type;
        this._range = range;
        this._level = level;
        this._hExpr = hExpr;
    }

    public int getType() {
        return this._type;
    }

    public int getRange() {
        return this._range;
    }

    public int getLevel() {
        return this._level;
    }

    public AbstractHExpr getTargetExpr() {
        return this._hExpr;
    }

    public boolean isShowGroupStatLast() {
        return this._showGroupStatLast;
    }

    public void setShowGroupStatLast(boolean showGroupStatLast) {
        this._showGroupStatLast = showGroupStatLast;
    }

    @Override
    public String getExprString() {
        StringBuffer result = new StringBuffer();
        result.append(VExpr.typeToString(this.getType()));
        result.append("(");
        result.append('\"');
        result.append(VExpr.rangeToString(this.getRange()));
        result.append('\"');
        result.append(", ");
        result.append("\"level" + this._level + '\"');
        result.append(", ");
        result.append(this._hExpr.getExprString());
        result.append(")");
        return result.toString();
    }

    public static String typeToString(int type) {
        switch (type) {
            case 16: {
                return "sum";
            }
            case 32: {
                return "avg";
            }
            case 64: {
                return "max";
            }
            case 128: {
                return "min";
            }
            case 256: {
                return "count";
            }
        }
        throw new R1DesignerRuntimeException("\u4e0d\u652f\u6301\u7684\u8fd0\u7b97\u7c7b\u578b");
    }

    public static int typeFromString(String strType) {
        if ("sum".equalsIgnoreCase(strType)) {
            return 16;
        }
        if ("avg".equalsIgnoreCase(strType)) {
            return 32;
        }
        if ("max".equalsIgnoreCase(strType)) {
            return 64;
        }
        if ("min".equalsIgnoreCase(strType)) {
            return 128;
        }
        if ("count".equalsIgnoreCase(strType)) {
            return 256;
        }
        throw new R1DesignerRuntimeException("\u4e0d\u652f\u6301\u7684\u8fd0\u7b97\u7c7b\u578b");
    }

    public static String rangeToString(int range) {
        switch (range) {
            case 1: {
                return "group";
            }
            case 2: {
                return "area";
            }
            case 4: {
                return "add";
            }
            case 8: {
                return "mix";
            }
        }
        throw new R1DesignerRuntimeException("\u4e0d\u652f\u6301\u7684\u8fd0\u7b97\u8303\u56f4");
    }

    public static int rangeFromString(String strRange) {
        if ("group".equalsIgnoreCase(strRange)) {
            return 1;
        }
        if ("area".equalsIgnoreCase(strRange)) {
            return 2;
        }
        if ("add".equalsIgnoreCase(strRange)) {
            return 4;
        }
        if ("mix".equalsIgnoreCase(strRange)) {
            return 8;
        }
        throw new R1DesignerRuntimeException("\u4e0d\u652f\u6301\u7684\u8fd0\u7b97\u8303\u56f4");
    }

    @Override
    public AbstractExpr runtimeClone() {
        AbstractHExpr hExpr = (AbstractHExpr)this._hExpr.runtimeClone();
        VExpr vExpr = new VExpr(this._type, this._range, this._level, hExpr);
        vExpr._count = this._count;
        vExpr._runtimeValue = new Variant(this._runtimeValue);
        vExpr._runtimeValue2 = new Variant(this._runtimeValue2);
        return vExpr;
    }

    private void stat(IWidgetExecuteHelper helper, String ds) throws SyntaxErrorException {
        Variant value = this._hExpr.getReturnValue();
        boolean isNullValue = value.isNull() || value.getValue() == null;
        switch (this.getType()) {
            case 16: {
                if (isNullValue) break;
                this.getSum().add(value);
                this.getSum2().add(value);
                break;
            }
            case 32: {
                if (!isNullValue) {
                    this.getSum().add(value);
                }
                ++this._count;
                break;
            }
            case 256: {
                ++this._count;
                break;
            }
            case 64: {
                if (isNullValue || !this.getExtremum().lessThan(value)) break;
                this._runtimeValue = value;
                break;
            }
            case 128: {
                if (isNullValue || !this.getExtremum().greaterThan(value)) break;
                this._runtimeValue = value;
                break;
            }
        }
    }

    private Variant getAvg() throws SyntaxErrorException {
        if (this.getCount() == 0) {
            return new Variant(0);
        }
        return new Variant(this.getSum()).divide(new Variant(this.getCount()));
    }

    private int getCount() {
        return this._count;
    }

    private Variant getSum() {
        if (this._runtimeValue == null || this._runtimeValue.isNull()) {
            this._runtimeValue = new Variant((Object)new BigDecimal("0"));
        }
        return this._runtimeValue;
    }

    private Variant getSum2() {
        if (this._runtimeValue2 == null || this._runtimeValue2.isNull()) {
            this._runtimeValue2 = new Variant((Object)new BigDecimal("0"));
        }
        return this._runtimeValue2;
    }

    private Variant getMax() {
        if (this.getExtremum() == SYS_MIN) {
            return null;
        }
        return this.getExtremum();
    }

    private Variant getMin() {
        if (this.getExtremum() == SYS_MAX) {
            return null;
        }
        return this.getExtremum();
    }

    private Variant getExtremum() {
        if (this._runtimeValue == null) {
            this._runtimeValue = this.getType() == 64 ? SYS_MIN : SYS_MAX;
        }
        return this._runtimeValue;
    }

    private Variant getValue() throws SyntaxErrorException {
        switch (this.getType()) {
            case 16: {
                return this.getSum();
            }
            case 32: {
                return this.getAvg();
            }
            case 256: {
                return new Variant(this.getCount());
            }
            case 64: {
                return this.getMax();
            }
            case 128: {
                return this.getMin();
            }
        }
        return null;
    }

    @Override
    public void computing(IWidgetExecuteHelper helper, String ds) throws SyntaxErrorException {
        this._hExpr.computing(helper, ds);
        this.stat(helper, ds);
    }

    @Override
    public void clearStat(int level) {
        if (level == -1) {
            if (this.getRange() == 2) {
                this.clearValue();
            } else if (this.getRange() == 8) {
                this._runtimeValue2 = null;
                this._returnValue = null;
            }
        } else if (level <= this._level) {
            this.clearValue();
        }
    }

    private void clearValue() {
        this._count = 0;
        this._runtimeValue = null;
        this._runtimeValue2 = null;
        this._returnValue = null;
    }

    @Override
    public void confirmReturnValue(int level) throws SyntaxErrorException {
        if (level == -1) {
            if ((this.getRange() == 2 || this.getRange() == 4) && this._runtimeValue != null) {
                this._returnValue = new Variant(this.getValue());
            } else if (this.getRange() == 8 && this._runtimeValue2 != null) {
                this._returnValue = new Variant(this._runtimeValue2);
            }
        } else if (level == this._level) {
            this._returnValue = new Variant(this.getValue());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VExpr) {
            VExpr another = (VExpr)obj;
            return this._level == another.getLevel() && this._type == another.getType() && this._range == another.getRange() && this._hExpr.equals(another);
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this._hExpr.hashCode();
            this._hashCode = this._hashCode * 21 + this._level;
            this._hashCode = this._hashCode * 21 + this._range;
            this._hashCode = this._hashCode * 21 + this._type;
        }
        return this._hashCode;
    }
}

