/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.TableView;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.Oper;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.Bintree2Plain;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.Bracket;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.Plain2Bintree;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.SingleExprEditorOwner;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.UIWrapper_Expr;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class ExprsEditor {
    private final int COL_OPER = 0;
    private final int COL_LEFT_BRACKET = 1;
    private final int COL_EXPR = 2;
    private final int COL_RIGHT_BRACKET = 3;
    private KDPanel _panOwner;
    private CustomTableView _tableView;
    private KDTextArea _txaExprShower;
    private MetaClass _metaClass;
    protected R1DataGridGroup[] _groups;
    protected int _currentLevel;

    public ExprsEditor(boolean isCompositeSupport) {
        this.init(isCompositeSupport);
    }

    private void init(boolean isCompositeSupport) {
        this.initTable(isCompositeSupport);
        this._txaExprShower = new KDTextArea();
        this._txaExprShower.setEnabled(false);
        TableLayout tl = TableLayout.splitRow((int)2);
        tl.rowStyle(0).setHeight(-62);
        tl.rowStyle(0).setMargin(2);
        tl.rowStyle(1).setHeight(-38);
        this._panOwner = new KDPanel((LayoutManager)tl);
        this._panOwner.add((Component)this._tableView.getPanel(), (Object)tl.cell(0));
        this._panOwner.add((Component)new KDScrollPane((Component)this._txaExprShower), (Object)tl.cell(1));
    }

    private void initTable(boolean isCompositeSupport) {
        this._tableView = new CustomTableView();
        this.setTableViewTitle(MultiLanguageUtil.getMLS("compute.ExprsEditor.gridCompute", ""));
        KDTable table = this._tableView.getTable();
        table.addHeadRow();
        table.addColumns(4);
        table.getColumn(0).setWidth(50);
        table.getColumn(1).setWidth(50);
        table.getColumn(2).setWidth(300);
        table.getColumn(3).setWidth(50);
        String exprTitle = isCompositeSupport ? MultiLanguageUtil.getMLS("compute.ExprsEditor.compositeExpr", "") : MultiLanguageUtil.getMLS("compute.ExprsEditor.unitExpr", "");
        IRow row = table.getHeadRow(0);
        row.getCell(0).setValue((Object)MultiLanguageUtil.getMLS("compute.ExprsEditor.operater", ""));
        row.getCell(1).setValue((Object)MultiLanguageUtil.getMLS("compute.ExprsEditor.leftBracket", ""));
        row.getCell(2).setValue((Object)exprTitle);
        row.getCell(3).setValue((Object)MultiLanguageUtil.getMLS("compute.ExprsEditor.rightBracket", ""));
        KDComboBox cmbOper = new KDComboBox(new Object[]{null, Oper.ADD, Oper.MINUS, Oper.MULTIPLY, Oper.DIVIDE});
        KDTDefaultCellEditor ceType = new KDTDefaultCellEditor((JComboBox)cmbOper);
        table.getColumn(0).setEditor((ICellEditor)ceType);
        KDComboBox cmbLB = new KDComboBox(new Object[]{null, Bracket.createLeft(), Bracket.createLeft(2), Bracket.createLeft(3), Bracket.createLeft(4), Bracket.createLeft(5)});
        KDTDefaultCellEditor ceLB = new KDTDefaultCellEditor((JComboBox)cmbLB);
        table.getColumn(1).setEditor((ICellEditor)ceLB);
        KDComboBox cmbRB = new KDComboBox(new Object[]{null, Bracket.createRight(), Bracket.createRight(2), Bracket.createRight(3), Bracket.createRight(4), Bracket.createRight(5)});
        KDTDefaultCellEditor ceRB = new KDTDefaultCellEditor((JComboBox)cmbRB);
        table.getColumn(3).setEditor((ICellEditor)ceRB);
        KDPromptBox f7Expr = new KDPromptBox();
        f7Expr.setEditable(false);
        f7Expr.setSelector((KDPromptSelector)new F7Popup(isCompositeSupport));
        KDTDefaultCellEditor ceExpr = new KDTDefaultCellEditor((IKDEditor)f7Expr);
        table.getColumn(2).setEditor((ICellEditor)ceExpr);
        EditedCheckHandler editedCheckHandler = new EditedCheckHandler();
        cmbOper.addActionListener((ActionListener)editedCheckHandler);
        cmbLB.addActionListener((ActionListener)editedCheckHandler);
        cmbRB.addActionListener((ActionListener)editedCheckHandler);
        f7Expr.addDataChangeListener((DataChangeListener)editedCheckHandler);
    }

    public JComponent getCtrl() {
        return this._panOwner;
    }

    void setTableViewTitle(String title) {
        this._tableView.setTitle(title);
    }

    void setPreferredWidth(int width) {
        KDTable table = this._tableView.getTable();
        int others = table.getColumn(0).getWidth() + table.getColumn(1).getWidth() + table.getColumn(3).getWidth() + 100;
        if ((width -= others) > 0) {
            table.getColumn(2).setWidth(width);
        }
    }

    public void setSupply(MetaClass mc, R1DataGridGroup[] groups, int currentLevel) {
        this._metaClass = mc;
        this._groups = groups;
        this._currentLevel = currentLevel;
    }

    public void setExpr(AbstractExpr expr) {
        KDTable table = this._tableView.getTable();
        table.removeRows();
        if (expr != null) {
            IRow currentRow = null;
            ArrayList plain = Bintree2Plain.parse(expr);
            Iterator it = plain.iterator();
            if (it.hasNext()) {
                currentRow = table.addRow();
            }
            while (it.hasNext()) {
                Object unit = it.next();
                if (unit instanceof Oper) {
                    currentRow = table.addRow();
                    currentRow.getCell(0).setValue(unit);
                    continue;
                }
                if (unit instanceof Bracket) {
                    if (((Bracket)unit).isLeft()) {
                        currentRow.getCell(1).setValue(unit);
                        continue;
                    }
                    currentRow.getCell(3).setValue(unit);
                    continue;
                }
                if (!(unit instanceof AbstractExpr)) continue;
                UIWrapper_Expr uiExpr = new UIWrapper_Expr((AbstractExpr)unit);
                currentRow.getCell(2).setValue((Object)uiExpr);
            }
        }
        this.check(-1, null);
    }

    public AbstractExpr getExpr() {
        return this.innerGetExpr(-1, null);
    }

    private AbstractExpr innerGetExpr(int insteadRowIdx, Object insteadValue) {
        ArrayList<Object> plain = new ArrayList<Object>();
        KDTable table = this._tableView.getTable();
        int rc = table.getRowCount();
        for (int i = 0; i < rc; ++i) {
            IRow row = table.getRow(i);
            int cc = table.getColumnCount();
            for (int j = 0; j < cc; ++j) {
                Object value;
                if (i == 0 && j == 0 || (value = i == insteadRowIdx && j == 2 ? insteadValue : row.getCell(j).getValue()) == null) continue;
                if (value instanceof UIWrapper_Expr) {
                    value = ((UIWrapper_Expr)value).getExpr();
                }
                plain.add(value);
            }
        }
        if (plain.size() == 0) {
            return null;
        }
        try {
            return Plain2Bintree.parse(plain);
        }
        catch (R1PrintException ex) {
            return null;
        }
    }

    public boolean verify() {
        return this.verifySyntax(new StringBuffer(), -1, null);
    }

    private void check(int insteadRowIdx, Object insteadValue) {
        StringBuffer sb = new StringBuffer();
        if (this.verifySyntax(sb, insteadRowIdx, insteadValue)) {
            sb = new StringBuffer();
            sb.append(this._tableView.getTitle());
            sb.append(MultiLanguageUtil.getMLS("compute.ExprsEditor.exprIs", ""));
            sb.append("\r\n= ");
            sb.append(this.innerGetExpr(insteadRowIdx, insteadValue).getExprString());
            this._txaExprShower.setText(sb.toString());
        } else {
            this._txaExprShower.setText(MultiLanguageUtil.getMLS("compute.ExprsEditor.prompt", "") + sb.toString());
        }
    }

    private boolean verifySyntax(StringBuffer prompt, int insteadRowIdx, Object insteadValue) {
        KDTable table = this._tableView.getTable();
        int rc = table.getRowCount();
        if (rc == 0) {
            prompt.append(MultiLanguageUtil.getMLS("compute.ExprsEditor.errInfo_NonDefExpr", ""));
            return false;
        }
        Stack<Bracket> stack = new Stack<Bracket>();
        for (int i = 0; i < rc; ++i) {
            Bracket rb;
            int rowNum = i + 1;
            IRow row = table.getRow(i);
            if (i > 0 && row.getCell(0).getValue() == null) {
                prompt.append(MultiLanguageUtil.getMLS("compute.ExprsEditor.errInfo_Num", ""));
                prompt.append(rowNum);
                prompt.append(MultiLanguageUtil.getMLS("compute.ExprsEditor.errInfo_RowMissOp", ""));
                return false;
            }
            Object expr = null;
            expr = i == insteadRowIdx ? insteadValue : row.getCell(2).getValue();
            if (expr == null) {
                prompt.append(MultiLanguageUtil.getMLS("compute.ExprsEditor.errInfo_Num", ""));
                prompt.append(rowNum);
                prompt.append(MultiLanguageUtil.getMLS("compute.ExprsEditor.errInfo_RowMissExpr", ""));
                return false;
            }
            Bracket lb = (Bracket)row.getCell(1).getValue();
            if (lb != null) {
                for (int k = 0; k < lb.getCount(); ++k) {
                    stack.push(Bracket.createLeft());
                }
            }
            if ((rb = (Bracket)row.getCell(3).getValue()) == null) continue;
            for (int k = 0; k < rb.getCount(); ++k) {
                if (stack.isEmpty()) {
                    prompt.append(MultiLanguageUtil.getMLS("compute.ExprsEditor.errInfo_MissBracket", ""));
                    return false;
                }
                stack.pop();
            }
        }
        if (!stack.isEmpty()) {
            prompt.append(MultiLanguageUtil.getMLS("compute.ExprsEditor.errInfo_MissBracket", ""));
            return false;
        }
        return true;
    }

    private class F7Popup
    implements KDPromptSelector {
        private SingleExprEditorOwner seeo;
        private boolean isCanceled;

        public F7Popup(boolean isCompositeSupport) {
            this.seeo = new SingleExprEditorOwner(isCompositeSupport);
        }

        public void show() {
            KDTable table = ExprsEditor.this._tableView.getTable();
            KDPromptBox ctrl = (KDPromptBox)table.getColumn(2).getEditor().getComponent();
            UIWrapper_Expr uiExpr = (UIWrapper_Expr)ctrl.getValue();
            this.seeo.setSupply(ExprsEditor.this._metaClass, ExprsEditor.this._groups, ExprsEditor.this._currentLevel);
            this.seeo.setExpr(uiExpr == null ? null : uiExpr.getExpr());
            SimpleDialog dlg = SimpleDialog.create((Component)ExprsEditor.this.getCtrl());
            dlg.setTitle(this.seeo.isCompositeSupport() ? MultiLanguageUtil.getMLS("compute.ExprsEditor.editCompositeExpr", "") : MultiLanguageUtil.getMLS("compute.ExprsEditor.editUnitExpr", ""));
            dlg.setComponent((Component)this.seeo.getCtrl());
            this.seeo.setDialogWidth(dlg.getWidth());
            this.isCanceled = !dlg.showDialog();
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public Object getData() {
            AbstractExpr expr = this.seeo.getExpr();
            return expr == null ? null : new UIWrapper_Expr(expr);
        }
    }

    private class EditedCheckHandler
    implements ActionListener,
    DataChangeListener {
        private EditedCheckHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExprsEditor.this.check(-1, null);
        }

        public void dataChanged(DataChangeEvent eventObj) {
            KDTable table = ExprsEditor.this._tableView.getTable();
            int insteadRowIdx = table.getEditManager().getEditRowIndex();
            Object insteadValue = eventObj.getNewValue();
            ExprsEditor.this.check(insteadRowIdx, insteadValue);
        }
    }

    private class CustomTableView
    extends TableView {
        private String title;

        private CustomTableView() {
        }

        @Override
        protected void actionPerformedMoveUp() {
            super.actionPerformedMoveUp();
            ExprsEditor.this.check(-1, null);
        }

        @Override
        protected void actionPerformedMoveDown() {
            super.actionPerformedMoveDown();
            ExprsEditor.this.check(-1, null);
        }

        @Override
        protected void actionPerformedAddRow() {
            super.actionPerformedAddRow();
            ExprsEditor.this.check(-1, null);
        }

        @Override
        protected void actionPerformedRemoveRow() {
            super.actionPerformedRemoveRow();
            ExprsEditor.this.check(-1, null);
        }

        @Override
        public void setTitle(String title) {
            this.title = title;
            super.setTitle(title + ":");
        }

        public String getTitle() {
            return this.title;
        }
    }
}

