/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.common.RadioButtonGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.common.StatTypeUI;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell.ACellPane;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell.PanelDGridCell;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class StatPane
extends ACellPane {
    private KDComboBox _cmbField = new KDComboBox();
    private StatTypeUI _statTypeUi;
    private RadioButtonGroup _statRangeGroup;
    private KDCheckBox _groupStatLast;

    public StatPane() {
        KDLabelContainer lbcField = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbField, (String)MultiLanguageUtil.getMLS("cell.StatPane.goalField", ""), (int)80);
        this._statTypeUi = new StatTypeUI();
        KDPanel panType = PanelDGridCell.createTitlePane(this._statTypeUi.getRadioButtonGroup(), MultiLanguageUtil.getMLS("cell.StatPane.statType", ""));
        this._statTypeUi.setSelectedStatType(1);
        this._statRangeGroup = new RadioButtonGroup();
        this.initRadioButton(MultiLanguageUtil.getMLS("cell.StatPane.rangGroup", ""), 18);
        this.initRadioButton(MultiLanguageUtil.getMLS("cell.StatPane.rangeArea", ""), 17);
        this.initRadioButton(MultiLanguageUtil.getMLS("cell.StatPane.cumulation", ""), 16);
        this.initRadioButton(MultiLanguageUtil.getMLS("cell.StatPane.mix", ""), 19);
        this._groupStatLast = new KDCheckBox(MultiLanguageUtil.getMLS("cell.StatPane.groupStatLast", ""));
        KDPanel panRange = this.createRangePane();
        this._statRangeGroup.setSelectedValue(new Integer(18));
        TableLayout tl = TableLayout.splitRow((int)4);
        tl.rowStyle(0).setHeight(20);
        tl.rowStyle(1).setMarginTop(6);
        tl.rowStyle(1).setHeight(66);
        tl.rowStyle(2).setMarginTop(6);
        tl.rowStyle(2).setHeight(99);
        tl.rowStyle(3).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)lbcField, tl.cell(0));
        this.add((Component)panType, tl.cell(1));
        this.add((Component)panRange, tl.cell(2));
    }

    private void initRadioButton(String text, int value) {
        KDRadioButton rad = new KDRadioButton(text);
        rad.setUserObject((Object)new Integer(value));
        if (value == 18) {
            rad.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    StatPane.this._groupStatLast.setEnabled(((KDRadioButton)e.getSource()).isSelected());
                }
            });
        }
        this._statRangeGroup.add(rad);
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        if (this._supplyValuePrepared) {
            return;
        }
        DataGrid grid = (DataGrid)eles[0].getRootPathComponent();
        String ds = grid.getDataSource().getDs();
        MetaClass mc = (MetaClass)core.getModel().getDataManager().getObject(ds);
        this.prepareFieldSupplyValue(mc);
        this._supplyValuePrepared = true;
    }

    private void prepareFieldSupplyValue(MetaClass mc) {
        this._cmbField.removeAllItems();
        if (mc != null) {
            for (MetaField mf : mc.getFields()) {
                Field field = Field.fromMetaField(mf);
                this._cmbField.addItem((Object)field);
            }
        }
        this._cmbField.setSelectedIndex(-1);
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        DataGridCell cell = (DataGridCell)eps[0].getLastPathComponent();
        StatField stat = (StatField)cell.getValue();
        Field field = stat.getField();
        int type = stat.getType();
        int range = stat.getRange();
        boolean isFieldUnsure = false;
        boolean isTypeUnsure = false;
        boolean isRangeUnsure = false;
        for (int i = 1; i < eps.length; ++i) {
            cell = (DataGridCell)eps[i].getLastPathComponent();
            stat = (StatField)cell.getValue();
            if (!isFieldUnsure && !Field.equals(field, stat.getField())) {
                isFieldUnsure = true;
            }
            if (!isTypeUnsure && type != stat.getType()) {
                isTypeUnsure = true;
            }
            if (isRangeUnsure || range == stat.getRange()) continue;
            isRangeUnsure = true;
        }
        if (isFieldUnsure) {
            this._cmbField.setSelectedIndex(-1);
        } else {
            this._cmbField.setSelectedItem((Object)field);
        }
        if (isTypeUnsure) {
            this._statTypeUi.setSelectedStatType(-1);
        } else {
            this._statTypeUi.setSelectedStatType(type);
        }
        if (isRangeUnsure) {
            this._statRangeGroup.setSelectedValueUnsure();
        } else {
            this._statRangeGroup.setSelectedValue(new Integer(range));
        }
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        boolean showGroupStatLast;
        int type;
        DataGridCell cell = (DataGridCell)elePath.getLastPathComponent();
        if (this._cmbField.getSelectedIndex() != -1) {
            this.getStat(cell).setField((Field)this._cmbField.getSelectedItem());
        }
        if ((type = this._statTypeUi.getSelectedStatType()) != -1) {
            this.getStat(cell).setType(type);
        }
        Object range = this._statRangeGroup.getSelectedValue();
        boolean bl = showGroupStatLast = this._groupStatLast.isSelected() && (Integer)range == 18;
        if (range != null) {
            this.getStat(cell).setRange((Integer)range);
            this.getStat(cell).setShowGroupStatLast(showGroupStatLast);
        }
    }

    private StatField getStat(DataGridCell cell) {
        ICellValue cellValue = cell.getValue();
        if (cellValue instanceof StatField) {
            return (StatField)cellValue;
        }
        StatField stat = new StatField();
        cell.setValue(stat);
        return stat;
    }

    @Override
    public void initCtrlValue() {
        super.initCtrlValue();
        this._statTypeUi.setSelectedStatType(1);
        this._statRangeGroup.setSelectedValue(new Integer(18));
    }

    private KDPanel createRangePane() {
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.style().setMargin(10, 26, 10, 10);
        Table row1 = tl.cell(0).splitCol(4);
        row1.colStyle(0).setWidth(-20);
        row1.colStyle(1).setWidth(-20);
        row1.colStyle(2).setWidth(-20);
        row1.colStyle(3).setWidth(-40);
        KDPanel pan = new KDPanel((LayoutManager)tl);
        pan.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("cell.StatPane.statArea", "")));
        Enumeration enumeration = this._statRangeGroup.getButtons();
        for (int i = 0; i < 4; ++i) {
            pan.add((Component)((KDRadioButton)enumeration.nextElement()), (Object)row1.cell(i));
        }
        pan.add((Component)this._groupStatLast, (Object)tl.cell(1));
        return pan;
    }
}

