/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.AbstractR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.upgrade.IR1XmlUpgradeChain;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.HeaderOrFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.LongPageModeHeadFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.data.R1PrintDataManager;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io.VersionInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.upgrade.R1PrintXmlUpgradeChain;
import org.jdom2.Element;

public class R1PrintXmlReader
extends AbstractR1XmlReader {
    @Override
    public IR1Page createPage() {
        R1PrintPage page = new R1PrintPage();
        page.setWidthLom(1720);
        page.setHeightLom(2470);
        page.setExtendProperty("pi", new R1PrintInfo());
        return page;
    }

    @Override
    public IR1DataManager createDataManager() {
        return new R1PrintDataManager();
    }

    @Override
    protected void parseModel(Element xmlRoot, ReportModel model) throws R1Exception {
        Element nodeReport = xmlRoot.getChild("Report");
        String type = nodeReport.getAttributeValue("type");
        if (type != null && !type.equals("r1-print")) {
            throw new R1Exception(MultiLanguageUtil.getMLS("io.R1PrintXmlReader.typeWrong", ""));
        }
        Element nodePage = nodeReport.getChild("Page");
        IR1Page page = this.parsePage(nodePage);
        model.setPage(page);
        if (!((R1PrintPage)page).isHeightSyncFromPaper()) {
            HeaderOrFooterModel headerModel = this.loadHeaderOrFooterModel(nodeReport, "Header");
            HeaderOrFooterModel footerModel = this.loadHeaderOrFooterModel(nodeReport, "Footer");
            if (!headerModel.isEmpty() || !footerModel.isEmpty()) {
                LongPageModeHeadFooterModel headerFootermodel = new LongPageModeHeadFooterModel();
                headerFootermodel.setHeader(headerModel);
                headerFootermodel.setFooter(footerModel);
                R1PrintModelHelper.setHeadFooterOfLongPageMode(page, headerFootermodel);
            }
        }
    }

    private IR1Page parsePage(Element nodePage) throws R1Exception {
        String content;
        Element bgNode;
        R1PrintPage page = (R1PrintPage)this.createPage();
        page.setId(nodePage.getAttributeValue("id"));
        page.setWidthLom(Integer.parseInt(nodePage.getAttributeValue("width")));
        page.setHeightLom(Integer.parseInt(nodePage.getAttributeValue("height")));
        if ("false".equals(nodePage.getAttributeValue("widthSyncFromPaper"))) {
            page.setWidthSyncFromPaper(false);
        }
        if ("false".equals(nodePage.getAttributeValue("heightSyncFromPaper"))) {
            page.setHeightSyncFromPaper(false);
        }
        String styleKey = nodePage.getAttributeValue("styleId");
        StyleAttributes sa = this.getStyleCache().getStyle(styleKey);
        if (sa != null) {
            page.setStyleAttribute(sa);
        }
        if ((bgNode = nodePage.getChild("Background")) != null && !StringUtil.isEmptyString((String)(content = bgNode.getText()))) {
            R1PrintPage printPage = page;
            printPage.setImageContent(Base64.decode((String)content));
            printPage.setPictureOffSetY(Integer.parseInt(bgNode.getAttributeValue("offSetY")));
            printPage.setPictureOffSetX(Integer.parseInt(bgNode.getAttributeValue("offSetX")));
            printPage.setConsultPage("true".equalsIgnoreCase(bgNode.getAttributeValue("isConsultPage")));
            printPage.setPrintBackground("true".equalsIgnoreCase(bgNode.getAttributeValue("isPrintBackground")));
        }
        this.loadContainer(this, nodePage, null, page);
        return page;
    }

    @Override
    protected void parseOthers(ReportModel model, Element xmlRoot) throws R1Exception {
        Element xmlPrintInfo = xmlRoot.getChild("PrintInfo");
        R1PrintInfo info = R1PrintInfo.fromXml(xmlPrintInfo);
        R1PrintModelHelper.setPrintInfo(model, info);
    }

    @Override
    public void loadContainer(IR1XmlRecursiveReader reader, Element node, ICompositeContainer compositeContainer, IContainer container) throws R1Exception {
        Element nodeSubs = node.getChild("Sub-objects");
        if (nodeSubs != null) {
            for (Element nodeChild : nodeSubs.getChildren()) {
                IReportObject ro = this.parseObject(reader, nodeChild, this.getStyleCache());
                if (ro == null) continue;
                if (compositeContainer == null) {
                    container.addChild(ro, null);
                    continue;
                }
                compositeContainer.addChild(container, ro);
            }
        }
    }

    private HeaderOrFooterModel loadHeaderOrFooterModel(Element nodeParent, String name) {
        HeaderOrFooterModel model = new HeaderOrFooterModel();
        Element element = nodeParent.getChild(name);
        if (element != null) {
            model.setHeightLom(Integer.parseInt(element.getAttributeValue("height")));
            model.setLeft(element.getChild("Left").getTextTrim());
            model.setCenter(element.getChild("Center").getTextTrim());
            model.setRight(element.getChild("Right").getTextTrim());
        }
        return model;
    }

    @Override
    public IR1XmlUpgradeChain createUpgradeChain() {
        return new R1PrintXmlUpgradeChain();
    }

    @Override
    public String checkVersionTooMordern(Element root) {
        String fileVersion;
        Element nodeReport = root.getChild("Report");
        String fileVersionAddInfo = null;
        String envVersion = VersionInfo.getCurrentEnvVersion();
        boolean isTooMordern = false;
        if (nodeReport == null) {
            fileVersion = MultiLanguageUtil.getMLS("io.R1PrintXmlReader.unkown", "");
            isTooMordern = true;
        } else {
            fileVersion = nodeReport.getAttributeValue("version");
            String[] vs_file = fileVersion.split("\\.");
            if (vs_file.length != 3) {
                fileVersionAddInfo = MultiLanguageUtil.getMLS("io.R1PrintXmlReader.unRecognise", "");
                isTooMordern = true;
            } else {
                String[] vs_env = envVersion.split("\\.");
                for (int i = 0; i < 3; ++i) {
                    int vf = 0;
                    try {
                        vf = Integer.parseInt(vs_file[i]);
                    }
                    catch (NumberFormatException ex) {
                        fileVersionAddInfo = MultiLanguageUtil.getMLS("io.R1PrintXmlReader.unRecognise", "");
                        isTooMordern = true;
                        break;
                    }
                    int ve = Integer.parseInt(vs_env[i]);
                    if (vf > ve) {
                        isTooMordern = true;
                        break;
                    }
                    if (vf >= ve) continue;
                    isTooMordern = false;
                    break;
                }
            }
        }
        if (isTooMordern) {
            StringBuffer sb = new StringBuffer();
            sb.append(MultiLanguageUtil.getMLS("io.R1PrintXmlReader.vision", ""));
            sb.append(fileVersion);
            if (fileVersionAddInfo != null) {
                sb.append(fileVersionAddInfo);
            }
            sb.append(StringUtil.RETURN);
            sb.append(MultiLanguageUtil.getMLS("io.R1PrintXmlReader.environment", ""));
            sb.append(envVersion);
            return sb.toString();
        }
        return null;
    }
}

