/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.DivideModel;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridNormalRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDisplayEveryPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid.GridXmlTransUtil;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class PrintDataGridXmlTrans
extends AbstractR1PrintXmlTrans {
    public PrintDataGridXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return StringUtil.equals((String)"PrintDataGrid", (String)node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        DataGrid grid = new DataGrid();
        this.loadObjectCommon(node, grid);
        List listCol = node.getChildren("Col");
        for (Element nodeCol : listCol) {
            this.loadColumn(nodeCol, grid);
        }
        GridXmlTransUtil.GroupsLoader groupsLoader = new GridXmlTransUtil.GroupsLoader();
        groupsLoader.loadGroups(node);
        List listRow = node.getChildren("TR");
        for (Element nodeRow : listRow) {
            this.loadRow(nodeRow, grid, node, groupsLoader);
        }
        GridXmlTransUtil.MergeBlocksLoader.loadMergeBlock(node, grid);
        return grid;
    }

    private void loadColumn(Element nodeCol, AbstractGrid grid) {
        AbstractColumn column = grid.addColumn();
        this.loadElementCommon(nodeCol, column);
        column.setWidthLom(PrintDataGridXmlTrans.getIntAttr(nodeCol, "width"));
    }

    private void loadRow(Element nodeRow, DataGrid grid, Element nodeGrid, GridXmlTransUtil.GroupsLoader groupsLoader) throws R1Exception {
        AbstractRow row;
        String rowType = nodeRow.getAttributeValue("type");
        if (StringUtil.equals((String)"detail", (String)rowType)) {
            row = grid.addRow(2);
            String strRepeatTimes = nodeRow.getAttributeValue("repeatTimes");
            if (strRepeatTimes != null) {
                ((DataGridDetailRow)row).setRepeatTimes(Integer.parseInt(strRepeatTimes));
            }
            if ("true".equals(nodeRow.getAttributeValue("dealPrintBlankLine"))) {
                ((DataGridDetailRow)row).setDealPrintBlankLine(true);
            }
            if ("true".equals(nodeRow.getAttributeValue("autoAdjustHeight"))) {
                row.setFixedHeight(false);
            }
        } else if (StringUtil.equals((String)"group", (String)rowType)) {
            row = grid.addRow(3);
            groupsLoader.supplyGroup(nodeRow, (DataGridGroupRow)row);
            this.loadRowCommon(nodeRow, (DataGridGroupRow)row);
        } else {
            row = grid.addRow(1);
            this.loadRowCommon(nodeRow, (DataGridNormalRow)row);
        }
        this.loadElementCommon(nodeRow, row);
        row.setHeightLom(PrintDataGridXmlTrans.getIntAttr(nodeRow, "height"));
        if (StringUtil.equals((String)nodeRow.getAttributeValue("isBackwardForward"), (String)"true")) {
            ((IDataGridRow)((Object)row)).setBackwardForward(true);
        }
        List listCell = nodeRow.getChildren("TD");
        int c = listCell.size();
        for (int i = 0; i < c; ++i) {
            Element nodeCell = (Element)listCell.get(i);
            DataGridCell cell = (DataGridCell)row.getCell(i);
            this.loadCell(nodeCell, grid, cell);
        }
    }

    private void loadRowCommon(Element nodeRow, IDisplayEveryPage row) {
        if ("true".equals(nodeRow.getAttributeValue("displayEveryPage"))) {
            row.setDisplayEveryPage(true);
        }
    }

    private void loadCell(Element nodeCell, DataGrid grid, DataGridCell cell) throws R1Exception {
        this.loadElementCommon(nodeCell, cell);
        GridXmlTransUtil.loadCellValue(nodeCell, cell);
        if (!StringUtil.isEmptyString((String)nodeCell.getAttributeValue("divideChar"))) {
            cell.setDivideCharNums(Integer.parseInt(nodeCell.getAttributeValue("divideChar")));
        }
        if (!StringUtil.isEmptyString((String)nodeCell.getAttributeValue("showDivideLine"))) {
            DivideModel model = new DivideModel();
            model.setShowLine(Boolean.valueOf(nodeCell.getAttributeValue("showDivideLine")).booleanValue());
            if (!StringUtil.isEmptyString((String)nodeCell.getAttributeValue("divideLineId"))) {
                StyleAttributes ssa = this._styleCache.getStyle(nodeCell.getAttributeValue("divideLineId"));
                model.upDataDivideLine(ssa);
            }
            cell.setDivideModel(model);
        }
        this._r1Reader.loadContainer(this._r1Reader, nodeCell, grid, cell);
    }

    @Override
    protected void loadObjectLocation(Element nodeRo, IReportObject ro) {
        ro.setXLom(Integer.parseInt(nodeRo.getAttributeValue("x")));
        ro.setYLom(Integer.parseInt(nodeRo.getAttributeValue("y")));
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof DataGrid;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element nodeGrid = new Element("PrintDataGrid");
        this.saveObjectCommon(ro, nodeGrid);
        DataGrid grid = (DataGrid)ro;
        int c = grid.getColumnsCount();
        for (int j = 0; j < c; ++j) {
            nodeGrid.addContent((Content)this.saveColumn(grid.getColumn(j)));
        }
        GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver = new GridXmlTransUtil.MergeBlocksSaver();
        GridXmlTransUtil.GroupsSaver groupsSaver = new GridXmlTransUtil.GroupsSaver();
        int c2 = grid.getRowsCount();
        for (int i = 0; i < c2; ++i) {
            nodeGrid.addContent((Content)this.saveRow(grid.getRow(i), grid, mergeBlocksSaver, groupsSaver));
        }
        mergeBlocksSaver.saveMergeBlocks(nodeGrid);
        groupsSaver.saveGroups(nodeGrid);
        return nodeGrid;
    }

    private Element saveColumn(AbstractColumn column) {
        Element nodeColumn = new Element("Col");
        PrintDataGridXmlTrans.setIntAttr(nodeColumn, "width", column.getWidthLom());
        this.saveElementCommon(column, nodeColumn);
        return nodeColumn;
    }

    private Element saveRow(AbstractRow row, DataGrid grid, GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver, GridXmlTransUtil.GroupsSaver groupsSaver) {
        Element nodeRow = new Element("TR");
        PrintDataGridXmlTrans.setIntAttr(nodeRow, "height", row.getHeightLom());
        if (row instanceof AbstractDetailRow) {
            nodeRow.setAttribute("type", "detail");
            int repeatTimes = ((DataGridDetailRow)row).getRepeatTimes();
            if (repeatTimes > 0) {
                nodeRow.setAttribute("repeatTimes", Integer.toString(repeatTimes));
            }
            if (((DataGridDetailRow)row).isDealPrintBlankLine()) {
                nodeRow.setAttribute("dealPrintBlankLine", "true");
            }
            if (!row.isFixedHeight()) {
                nodeRow.setAttribute("autoAdjustHeight", "true");
            }
        } else if (row instanceof AbstractGroupRow) {
            nodeRow.setAttribute("type", "group");
            groupsSaver.storeGroup((DataGridGroupRow)row, nodeRow);
            this.saveRowCommon((DataGridGroupRow)row, nodeRow);
        } else {
            nodeRow.setAttribute("type", "normal");
            this.saveRowCommon((IDisplayEveryPage)((Object)row), nodeRow);
        }
        this.saveElementCommon(row, nodeRow);
        if (((IDataGridRow)((Object)row)).isBackwardForward()) {
            nodeRow.setAttribute("isBackwardForward", "true");
        }
        int c = row.getCellCount();
        for (int i = 0; i < c; ++i) {
            DataGridCell cell = (DataGridCell)row.getCell(i);
            nodeRow.addContent((Content)this.saveCell(grid, cell));
            mergeBlocksSaver.storeMergeBlock(grid, cell);
        }
        return nodeRow;
    }

    private void saveRowCommon(IDisplayEveryPage row, Element nodeRow) {
        if (row.isDisplayEveryPage()) {
            nodeRow.setAttribute("displayEveryPage", "true");
        }
    }

    private Element saveCell(DataGrid grid, DataGridCell cell) {
        Element nodeCell = new Element("TD");
        this.saveElementCommon(cell, nodeCell);
        GridXmlTransUtil.saveCellValue(cell, nodeCell);
        if (cell.getDivideCharNums() > 0) {
            nodeCell.setAttribute("divideChar", Integer.toString(cell.getDivideCharNums()));
            if (cell.getDivideModel().isShowLine()) {
                nodeCell.setAttribute("showDivideLine", Boolean.toString(cell.getDivideModel().isShowLine()));
                String linesStyleId = this._styleCache.cacheStyle(cell.getDivideModel().getSSA());
                nodeCell.setAttribute("divideLineId", linesStyleId);
            }
        }
        if (cell.getChildrenCount() > 0) {
            this._r1Writer.saveContainer(this._r1Writer, cell, nodeCell);
        }
        return nodeCell;
    }

    @Override
    protected void saveObjectLocation(IReportObject ro, Element node) {
        node.setAttribute("x", Integer.toString(ro.getXLom()));
        node.setAttribute("y", Integer.toString(ro.getYLom()));
    }
}

