/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer;

import com.kingdee.bos.ctrl.kdf.util.render.IBorderHolder;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.AbstractObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintStringRender;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.cellvalue.GridCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer.RendererUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;

public class DataGridRenderer
extends AbstractObjectRenderer
implements IBorderHolder {
    private DataGrid _grid;
    private Style _style4InvlidValue;
    private Style _style4Hide;
    private Style _style4RepeatRows;
    private Style _style4StatRange;
    private Color _color4RepeatRows;

    private Style getStyle4InvalidValue() {
        if (this._style4InvlidValue == null) {
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setFontColor(Color.RED);
            this._style4InvlidValue = Styles.getStyle((ShareStyleAttributes)sa);
        }
        return this._style4InvlidValue;
    }

    private Style getStyle4Hide() {
        if (this._style4Hide == null) {
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setBackground(new Color(0, 0, 0, 10));
            sa.setPattern(Pattern.Percent5);
            this._style4Hide = Styles.getStyle((ShareStyleAttributes)sa);
        }
        return this._style4Hide;
    }

    private Style getStyle4RepeatRows() {
        if (this._style4RepeatRows == null) {
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setFontColor(Color.LIGHT_GRAY);
            sa.setFontSize(32);
            sa.setItalic(true);
            sa.setShrinkText(true);
            RendererUtil.initBorder(sa, LineStyle.SINGLE_LINE, PenStyle.PS_DOT, Color.LIGHT_GRAY);
            this._style4RepeatRows = Styles.getStyle((ShareStyleAttributes)sa);
        }
        return this._style4RepeatRows;
    }

    private Style getStyle4StatRange() {
        if (this._style4StatRange == null) {
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            sa.setVerticalAlign(Styles.VerticalAlignment.TOP);
            sa.setFontColor(Color.LIGHT_GRAY);
            this._style4StatRange = Styles.getStyle((ShareStyleAttributes)sa);
        }
        return this._style4StatRange;
    }

    @Override
    public void setReportObject(IReportObject obj) {
        this._grid = (DataGrid)obj;
    }

    @Override
    public void draw(Graphics g, PageContainer c) {
        int y = this._grid.getY();
        int repeatRowsY = -1;
        int repeatRowsHeight = 0;
        int rowCnt = this._grid.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            AbstractRow row = this._grid.getRow(i);
            int drawingTimes = this._grid.getRowDrawingTimes(row);
            for (int k = 0; k < drawingTimes; ++k) {
                int x = this._grid.getX();
                int h = row.getFeatHeight();
                int colCnt = this._grid.getColumnsCount();
                for (int j = 0; j < colCnt; ++j) {
                    boolean toDraw = true;
                    int w = this._grid.getColumn(j).getFeatWidth();
                    DataGridCell cell = (DataGridCell)row.getCell(j);
                    int width = 0;
                    int height = 0;
                    MergeBlock mergeBlock = cell.getMergeBlock();
                    if (mergeBlock == null) {
                        width = w;
                        height = h;
                    } else if (mergeBlock.isFirstCell(i, j)) {
                        width = mergeBlock.getBlockWidth(this._grid);
                        height = mergeBlock.getBlockHeight(this._grid);
                    } else {
                        toDraw = false;
                    }
                    if (toDraw) {
                        BORDER_INFO.setRowCol(i, j);
                        Style style = this.getCellStyle(cell);
                        Rectangle rect = new Rectangle(x, y, width + 1, height + 1);
                        if (k > 0) {
                            if (h == height) {
                                if (this._color4RepeatRows == null) {
                                    this._color4RepeatRows = new Color(100, 100, 100, 30);
                                }
                                this.drawBackground(g, rect, this._color4RepeatRows);
                                this.drawBorder(g, rect, style, this);
                            }
                        } else {
                            this.drawBackground(g, rect, style);
                            this.drawBorder(g, rect, style, this);
                            this.drawText(g, cell.getValue(), rect, style, cell);
                        }
                    }
                    x += w;
                }
                if (row.isHide()) {
                    Rectangle rect = new Rectangle(this._grid.getX(), y, x - this._grid.getX(), row.getFeatHeight());
                    this.drawHideBackground((Graphics2D)g, rect);
                }
                if (k > 0) {
                    if (repeatRowsY == -1) {
                        repeatRowsY = y;
                    }
                    repeatRowsHeight += h;
                }
                y += h;
            }
        }
        if (repeatRowsY != -1) {
            Rectangle rect = new Rectangle(this._grid.getX() + 1, repeatRowsY + 1, this._grid.getWidth() - 2, repeatRowsHeight - 2);
            this.drawBorder(g, rect, this.getStyle4RepeatRows());
            this.drawText(g, new Text(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.repeatDataRow", "")), rect, this.getStyle4RepeatRows(), null);
        }
    }

    private void drawHideBackground(Graphics2D g, Rectangle rect) {
        Paint oriPaint = g.getPaint();
        g.setPaint(this.getStyle4Hide().getFillPaint());
        g.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g.setPaint(oriPaint);
    }

    private void drawText(Graphics g, ICellValue value, Rectangle rect, Style style, Object target) {
        if (value != null) {
            R1PrintStringRender r1TextRender = R1PrintStringRender.getKeepClipInstance();
            rect = new Rectangle(rect.x + 2, rect.y + 2, rect.width - 4, rect.height - 4);
            if (value.isInvalid()) {
                style = this.getStyle4InvalidValue();
            } else {
                if (style == null) {
                    style = Styles.getDefaultStyle();
                }
                if (value instanceof StatField) {
                    StringBuffer range = new StringBuffer("[");
                    switch (((StatField)value).getRange()) {
                        case 17: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.area", ""));
                            break;
                        }
                        case 16: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.cumulation", ""));
                            break;
                        }
                        case 18: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.group", ""));
                            break;
                        }
                        case 19: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.areaAndGroup", ""));
                            break;
                        }
                    }
                    range.append("]");
                    switch (((StatField)value).getType()) {
                        case 1: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.sum", ""));
                            break;
                        }
                        case 2: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.avg", ""));
                            break;
                        }
                        case 3: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.max", ""));
                            break;
                        }
                        case 4: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.min", ""));
                            break;
                        }
                        case 5: {
                            range.append(MultiLanguageUtil.getMLS("renderer.DataGridRenderer.count", ""));
                            break;
                        }
                    }
                    r1TextRender.drawText(g, new Rectangle(rect), range.toString(), this.getStyle4StatRange(), target);
                }
            }
            if (value instanceof GridCompute) {
                r1TextRender.drawText(g, rect, MultiLanguageUtil.getMLS("renderer.DataGridRenderer.operation", ""), this.getStyle4StatRange(), target);
            }
            r1TextRender.drawText(g, rect, value.getDrawString(), style, target);
        }
    }

    private Style getCellStyle(AbstractCell cell) {
        StyleAttributes sa = cell.getStyleAttribute();
        sa = sa == null ? Styles.getDefaultSA() : Styles.getSA((StyleAttributes)sa);
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.LEFT))) {
            RendererUtil.initBorder(sa, Styles.Position.LEFT, LineStyle.SINGLE_LINE, PenStyle.PS_DASHDOT, Color.LIGHT_GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.RIGHT))) {
            RendererUtil.initBorder(sa, Styles.Position.RIGHT, LineStyle.SINGLE_LINE, PenStyle.PS_DASHDOT, Color.LIGHT_GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.TOP))) {
            RendererUtil.initBorder(sa, Styles.Position.TOP, LineStyle.SINGLE_LINE, PenStyle.PS_DASHDOT, Color.LIGHT_GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.BOTTOM))) {
            RendererUtil.initBorder(sa, Styles.Position.BOTTOM, LineStyle.SINGLE_LINE, PenStyle.PS_DASHDOT, Color.LIGHT_GRAY);
        }
        return Styles.getStyle((ShareStyleAttributes)sa);
    }

    public Style getCellStyle(int row, int col) {
        return this.getCellStyle(this._grid.getCell(row, col));
    }

    public Style getVirtualCellStyle(int row, int col, Styles.Dir dir) {
        if (dir.isNorth()) {
            --row;
        } else if (dir.isSouth()) {
            ++row;
        }
        if (dir.isWest()) {
            --col;
        } else if (dir.isEast()) {
            ++col;
        }
        if (row == -1 || col == -1 || row == this._grid.getRowsCount() || col == this._grid.getColumnsCount()) {
            return null;
        }
        return this.getCellStyle(row, col);
    }
}

