/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.stat;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueStat;

public class StatRuntimeValue {
    private int _level;
    private CellValueStat _designInfo;
    private int _count;
    private Variant _value;
    private Variant _value2;

    public StatRuntimeValue(int level, CellValueStat designInfo) {
        this._level = level;
        this._designInfo = designInfo;
        this.clearValue(level);
    }

    public int getLevel() {
        return this._level;
    }

    public CellValueStat getDesignInfo() {
        return this._designInfo;
    }

    public void clearValue(int level) {
        if (level == this._level) {
            this._value2 = null;
        }
        this._count = 0;
        this._value = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatRuntimeValue)) {
            return false;
        }
        StatRuntimeValue another = (StatRuntimeValue)obj;
        return this._level == another.getLevel() && this._designInfo.equals(another.getDesignInfo());
    }

    public int hashCode() {
        int result = 7;
        result = 21 * result + this._level;
        result = 21 * result + this._designInfo.hashCode();
        return result;
    }

    public void stat(IWidgetExecuteHelper helper, String ds) throws SyntaxErrorException {
        Variant value = null;
        boolean isNullValue = true;
        if (!this.getDesignInfo().isContain(256)) {
            value = helper.getDataHelper().getFieldValue(ds, this.getDesignInfo().getStatField());
            boolean bl = isNullValue = value.isNull() || value.getValue() == null;
        }
        if (this.getDesignInfo().isContain(16)) {
            if (!isNullValue) {
                this.getSum().add(value);
                this.getSum2().add(value);
            }
        } else if (this.getDesignInfo().isContain(32)) {
            if (!isNullValue) {
                this.getSum().add(value);
            }
            ++this._count;
        } else if (this.getDesignInfo().isContain(256)) {
            ++this._count;
        } else if (this.getDesignInfo().isContain(64)) {
            if (!isNullValue && this.getExtremum().lessThan(value)) {
                this._value = value;
            }
        } else if (this.getDesignInfo().isContain(128) && !isNullValue && this.getExtremum().greaterThan(value)) {
            this._value = value;
        }
    }

    public Variant getValue() throws SyntaxErrorException {
        if (this.getDesignInfo().isContain(16)) {
            return this.getSum();
        }
        if (this.getDesignInfo().isContain(32)) {
            return this.getAvg();
        }
        if (this.getDesignInfo().isContain(256)) {
            return new Variant(this.getCount());
        }
        if (this.getDesignInfo().isContain(64)) {
            return this.getMax();
        }
        if (this.getDesignInfo().isContain(128)) {
            return this.getMin();
        }
        return null;
    }

    private Variant getAvg() throws SyntaxErrorException {
        if (this.getCount() == 0) {
            return new Variant(0);
        }
        return new Variant(this.getSum()).divide(new Variant(this.getCount()));
    }

    int getCount() {
        return this._count;
    }

    private Variant getSum() {
        if (this._value == null) {
            this._value = new Variant(0);
        }
        return this._value;
    }

    public Variant getSum2() {
        if (this._value2 == null) {
            this._value2 = new Variant(0);
        }
        return this._value2;
    }

    private Variant getMax() {
        if (this.getExtremum().equals(new Variant(-1.7976931348623157E308))) {
            return null;
        }
        return this.getExtremum();
    }

    private Variant getMin() {
        if (this.getExtremum().equals(new Variant(Double.MAX_VALUE))) {
            return null;
        }
        return this.getExtremum();
    }

    private Variant getExtremum() {
        if (this._value == null) {
            this._value = this.getDesignInfo().isContain(64) ? new Variant(-1.7976931348623157E308) : new Variant(Double.MAX_VALUE);
        }
        return this._value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(this.getLevel());
        sb.append("|");
        sb.append(this.getDesignInfo().getStatField());
        sb.append("|");
        sb.append(this.getDesignInfo().getStatType());
        sb.append(")=(");
        sb.append(this.getCount());
        sb.append("|");
        sb.append(this._value == null ? "null" : this._value.getValue());
        sb.append(")");
        return sb.toString();
    }

    public void confirmReturnValue() {
        if (this._value2 != null) {
            this._value = this._value2;
        }
    }
}

