/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.r1form;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.bos.ctrl.print.printjob.IPageProvider;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.R1FormModelLoader;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.form.export.R1FormWidgetExportContext;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.form.io.design.R1FormDesign2Widget;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.form.model.R1ModelManager;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.form.view.R1FormViewEventHandler;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.ExportException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.NameIndex;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.model.ParametersModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.model.SimpleRowsModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.widget.AWidget;
import com.kingdee.bos.ctrl.reportone.reportframework.IContext;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.AReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.BindingData;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.IR1FormRptExecutor;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.IR1Model;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.R1CrosstabModel;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.R1CubeModel;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.R1FormPrnitPageProvider;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.R1TableModel_st;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.VariableFormula;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class R1FormRptBrowser
extends AReportBrowser {
    private static final Logger log = LogUtil.getPackageLogger(R1FormRptBrowser.class);
    private static final String CONTEXT_ARGS = "context";
    private static final String REPORT_ARGS = "report";
    private Component r1form;
    private AWidget widget;
    private ASwingView view;

    public R1FormRptBrowser(Component owner) {
        super(owner);
    }

    @Override
    public void close() throws ReportException {
        if (this.r1form == null) {
            return;
        }
        super.close();
        this.r1form = null;
        this.widget = null;
        this.view = null;
    }

    @Override
    public Component getComponent() {
        return this.r1form;
    }

    @Override
    public void browse(HashMap args) throws ReportException {
        ByteArrayInputStream tpl;
        this.getReportExecutor().execute(args);
        if (this.r1form != null) {
            return;
        }
        long l0 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Load R1Form template ...read template");
        }
        try {
            tpl = new ByteArrayInputStream(((IR1FormRptExecutor)this.getReportExecutor()).readTemplate());
        }
        catch (ReportException ex) {
            throw ReportException.makeException(ex);
        }
        try {
            IContext pubEnv;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Load R1Form template ...load model");
            }
            ReportModel rm = R1FormModelLoader.loadReportModel(tpl);
            R1ModelManager mm = new R1ModelManager();
            if (this.getReportEnv() != null && (pubEnv = this.getReportEnv().getContext()) != null) {
                SimpleRowsModel ctx = new SimpleRowsModel(pubEnv.getValues());
                mm.setModel(CONTEXT_ARGS, ctx);
            }
            mm.setModel(REPORT_ARGS, new ParametersModel(rm.getDataManager().getReportParams(), args));
            this.parseModels(rm, mm);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load model/data, completed,token:" + (System.currentTimeMillis() - l0) + " ms!"));
            }
            this.r1form = this.exportMVC(rm, mm).getComponent();
        }
        catch (Exception ex) {
            throw ReportException.makeException(ex);
        }
    }

    private void parseModels(ReportModel rm, R1ModelManager mm) {
        DataExtend[] dsgModels = rm.getDataManager().getDataExtends();
        for (int i = 0; i < dsgModels.length; ++i) {
            AModel m = this.parseModel(dsgModels[i]);
            mm.setModel(m.getName(), m);
        }
        this.parseBindingArgs(mm);
    }

    private void parseBindingArgs(R1ModelManager mm) {
        Iterator i = mm.iterateModels();
        while (i.hasNext()) {
            IR1Model m;
            Map args;
            Object item = i.next();
            if (!(item instanceof IR1Model) || (args = (m = (IR1Model)item).getArgs()) == null) continue;
            for (Map.Entry entry : args.entrySet()) {
                DataParamSource dsgArg = (DataParamSource)((Object)entry.getValue());
                String refModelName = dsgArg.getReferenceDataName();
                if (!StringUtil.isEmptyString((String)refModelName)) {
                    AModel refModel = mm.getModel(refModelName);
                    ((AModel)((Object)m)).setPrepNode(refModel);
                    BindingData md = new BindingData();
                    md.setModel(refModel);
                    md.setField(NameIndex.valueOf(dsgArg.getValue()));
                    entry.setValue(md);
                    continue;
                }
                String expr = dsgArg.getValue();
                if (expr == null || -1 == expr.indexOf(64)) {
                    entry.setValue(expr);
                    continue;
                }
                VariableFormula vf = new VariableFormula(expr);
                HashMap vars = new HashMap();
                for (Map.Entry entObj : vf.getDetail().entrySet()) {
                    AModel refModel = mm.getModel((String)entObj.getKey());
                    ((AModel)((Object)m)).setPrepNode(refModel);
                    for (Map.Entry entFld : ((Map)entObj.getValue()).entrySet()) {
                        BindingData md = new BindingData();
                        md.setModel(refModel);
                        md.setField(NameIndex.valueOf((String)entFld.getKey()));
                        vars.put(entFld.getValue(), md);
                    }
                }
                vf.setVariables(vars);
                entry.setValue(vf);
            }
        }
    }

    private AModel parseModel(DataExtend dsgModel) {
        IR1FormRptExecutor rptExec = (IR1FormRptExecutor)this.getReportExecutor();
        HashMap<String, DataParamSource> args = new HashMap<String, DataParamSource>();
        for (DataParamSource dsgArg : dsgModel.getParamSources()) {
            args.put(dsgArg.getParamName(), dsgArg);
        }
        String fpText = dsgModel.getInfo();
        FullPath fp = FullPath.parse((String)dsgModel.getInfo());
        String category = fp.getCategory();
        if (DataDefType.KDRS_CROSSTAB.getName().equals(category)) {
            R1CrosstabModel rptModel = new R1CrosstabModel(rptExec);
            rptModel.setName(dsgModel.getName());
            rptModel.setFullPath(fp);
            rptModel.setArgs(args);
            return rptModel;
        }
        if (DataDefType.KDRS_CUBEMODEL.getName().equals(category)) {
            R1CubeModel rptModel = new R1CubeModel(rptExec);
            rptModel.setName(dsgModel.getName());
            rptModel.setFullPath(fp);
            rptModel.setArgs(args);
            return rptModel;
        }
        R1TableModel_st rptModel = new R1TableModel_st(rptExec);
        rptModel.setName(dsgModel.getName());
        rptModel.setFullPath(fp);
        rptModel.setArgs(args);
        return rptModel;
    }

    public ASwingView exportMVC(ReportModel rm, R1ModelManager mm) throws ExportException {
        R1FormDesign2Widget exporter = new R1FormDesign2Widget();
        this.widget = exporter.export(rm.getPage());
        R1FormWidgetExportContext exp = new R1FormWidgetExportContext();
        exp.setModelManager(mm);
        exp.setEventHandler(new R1FormViewEventHandler(mm));
        this.view = (ASwingView)exp.exportNode(this.widget);
        mm.changeAll();
        return this.view;
    }

    @Override
    public void print() throws ReportException {
        Element e;
        KDPrinter ctrlPrint = new KDPrinter();
        BufferPrintJob prtJob = new BufferPrintJob();
        prtJob.setPageProvider((IPageProvider)new R1FormPrnitPageProvider(this.widget, this.view));
        ctrlPrint.addPrintJob((IPrintJob)prtJob);
        Element element = e = this.getPrntConfigSerializer() != null ? this.getPrntConfigSerializer().load() : null;
        if (e != null) {
            ctrlPrint.getPrintConfig().fromXmlElement(e);
        }
        ctrlPrint.print();
        e = ctrlPrint.getPrintConfig().toXmlElement();
        if (e != null && this.getPrntConfigSerializer() != null) {
            this.getPrntConfigSerializer().save(e);
        }
    }

    @Override
    public void printPreview() throws ReportException {
        Element e;
        KDPrinter ctrlPrint = new KDPrinter();
        BufferPrintJob prtJob = new BufferPrintJob();
        prtJob.setPageProvider((IPageProvider)new R1FormPrnitPageProvider(this.widget, this.view));
        ctrlPrint.addPrintJob((IPrintJob)prtJob);
        ctrlPrint.setPreviewWindowType(0);
        ctrlPrint.setParentWindow(this.owner);
        Element element = e = this.getPrntConfigSerializer() != null ? this.getPrntConfigSerializer().load() : null;
        if (e != null) {
            ctrlPrint.getPrintConfig().fromXmlElement(e);
        }
        ctrlPrint.printPreview();
        e = ctrlPrint.getPrintConfig().toXmlElement();
        if (e != null && this.getPrntConfigSerializer() != null) {
            this.getPrntConfigSerializer().save(e);
        }
    }
}

