/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IBoundLabelControl;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.TextLengthVerifier;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoManager;

public class KDFilterTextField
extends BasicFormattedTextField
implements IKDComponent,
IBoundLabelControl {
    private static final long serialVersionUID = -6009682852663558284L;
    public static final String undoAction = "undo-FilterTextField";
    public static final String redoAction = "redo-FilterTextField";
    public UndoManager manager = null;
    private String validCharacters = "";
    private String invalidCharacters = "";
    protected KDLabelContainer kdLabelContainer;
    private Object userObject = null;
    private int maxLength = -1;
    private int minLength = 0;
    protected TextLengthVerifier verifier = null;
    public static final int NULL = 0;
    public static final int NUMBER = 1;
    public static final int CHARACTER = 2;
    public static final int NUMBERORCHARACTER = 4;
    public static final int ANYTHING = -1;
    public static final int ENGLISH_LETTER = 24;
    public static final int LOWERCASE_LETTER = 8;
    public static final int UPPERCASE_LETTER = 16;
    private int filterType = 0;
    private Insets customInsets;

    public KDFilterTextField() {
        this.init();
    }

    private void init() {
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, undoAction);
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, redoAction);
        actionMap.put(undoAction, new UndoAction());
        actionMap.put(redoAction, new RedoAction());
    }

    public void setValidCharacters(String validCharacters) {
        if (validCharacters == null) {
            validCharacters = "";
        }
        this.validCharacters = validCharacters;
    }

    public String getValidCharacters() {
        return this.validCharacters;
    }

    public void setInvalidCharacters(String invalidCharacters) {
        if (invalidCharacters == null) {
            invalidCharacters = "";
        }
        this.invalidCharacters = invalidCharacters;
    }

    public String getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public String getStringValue() {
        Object val = this.getValue();
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public void setStringValue(String val) {
        this.setValue(val);
    }

    @Override
    public Object getValue() {
        String str = this.getText();
        if (StringUtil.isEmptyString((String)str)) {
            return null;
        }
        if (str.length() < this.getMinLength()) {
            return null;
        }
        return str;
    }

    @Override
    public void setValue(Object val) {
        String str = "";
        if (val != null) {
            str = val.toString();
        }
        String old = this.getText();
        this.setText("");
        if (this.isContentOk(str)) {
            this.setText(str);
        } else {
            this.setText(old);
        }
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    @Override
    public void setUserObject(Object newUserObject) {
        this.userObject = newUserObject;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    public void setMaxLength(int len) {
        if (len >= -1) {
            this.maxLength = len;
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMinLength(int len) {
        if (len >= 0) {
            this.minLength = len;
            this.getTextLengthVerifier().setMinLength(len);
        }
    }

    public int getMinLength() {
        return this.minLength;
    }

    protected TextLengthVerifier getTextLengthVerifier() {
        if (this.verifier == null) {
            this.verifier = new TextLengthVerifier();
            this.setInputVerifier(this.verifier);
        }
        return this.verifier;
    }

    @Override
    public void replaceSelection(String content) {
        if (this.isContentOk(content)) {
            super.replaceSelection(content);
        }
    }

    private boolean isContentOk(String content) {
        if (!StringUtil.isEmptyString((String)content)) {
            return this.isInMaskOrValid(content) && !this.hasInvalid(content) && this.isLengthOk(content);
        }
        return true;
    }

    private boolean isInMaskOrValid(String content) {
        boolean ret = true;
        for (int i = 0; i < content.length(); ++i) {
            char aChar = content.charAt(i);
            if (this.isInMask(aChar) || this.isValid(aChar)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private boolean isValid(char test) {
        return this.validCharacters.indexOf(test) != -1;
    }

    private boolean isInValid(char test) {
        return this.invalidCharacters.indexOf(test) != -1;
    }

    private boolean isInMask(char test) {
        int type = this.getFilterType();
        if (type == 0) {
            return false;
        }
        if (type == -1) {
            return true;
        }
        boolean ret = false;
        if (!ret && KDFilterTextField.isIncludeType(type, 1)) {
            ret = Character.isDigit(test);
        }
        if (!ret && KDFilterTextField.isIncludeType(type, 2)) {
            ret = Character.isLetter(test);
        }
        if (!ret && KDFilterTextField.isIncludeType(type, 4)) {
            ret = Character.isLetterOrDigit(test);
        }
        if (!ret && KDFilterTextField.isIncludeType(type, 8)) {
            ret = Character.isLowerCase(test);
        }
        if (!ret && KDFilterTextField.isIncludeType(type, 16)) {
            ret = Character.isUpperCase(test);
        }
        return ret;
    }

    private boolean hasInvalid(String content) {
        boolean ret = false;
        for (int i = 0; i < content.length(); ++i) {
            char aChar = content.charAt(i);
            if (!this.isInValid(aChar)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean isLengthOk(String content) {
        boolean ret = true;
        String cur = this.getText();
        int total = cur == null ? 0 : cur.length();
        int selection = this.getSelectionEnd() - this.getSelectionStart();
        int result = total - selection + content.length();
        int max = this.getMaxLength();
        if (max != -1 && result > max) {
            ret = false;
        }
        return ret;
    }

    public static boolean isIncludeType(int t, int T) {
        return (t & T) != 0;
    }

    public void setFilterType(int type) {
        this.filterType = type;
    }

    public int getFilterType() {
        return this.filterType;
    }

    @Override
    public void commitEdit() throws ParseException {
        String str = this.getText();
        this.setText("");
        boolean ok = this.isContentOk(str);
        this.setText(str);
        if (!ok) {
            throw new ParseException("parse exception: content error", 0);
        }
        if (this.verifier != null && !this.verifier.verify(this)) {
            throw new ParseException("parse exception: verify error", 0);
        }
    }

    @Override
    public void setText(String t) {
        super.setText(t);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public void setEditingText(String t) {
        this.setText("");
        if (this.isContentOk(t)) {
            super.setText(t);
        }
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -634535188915531678L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDFilterTextField.this.manager.canRedo()) {
                    KDFilterTextField.this.manager.redo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2130980195631652314L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDFilterTextField.this.manager.canUndo()) {
                    KDFilterTextField.this.manager.undo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

