/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.model.CheckBoxModel;
import com.kingdee.bos.ctrl.swing.plaf.ButtonStatesUtil;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeUtils;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class KingdeeIconFactory
implements Serializable {
    private static final long serialVersionUID = 5246104344749317707L;
    private static Icon radioButtonIcon;
    private static Icon checkBoxIcon;
    private static final Dimension menuArrowIconSize;
    private static Icon menuArrowIcon;

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    static {
        menuArrowIconSize = new Dimension(4, 8);
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = -239453743219344509L;

        private MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            g.translate(x, y);
            if (!model.isEnabled()) {
                g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLACK);
            }
            if (KingdeeUtils.isLeftToRight(b)) {
                g.drawLine(0, 0, 0, 7);
                g.drawLine(1, 1, 1, 6);
                g.drawLine(2, 2, 2, 5);
                g.drawLine(3, 3, 3, 4);
            } else {
                g.drawLine(4, 0, 4, 7);
                g.drawLine(3, 1, 3, 6);
                g.drawLine(2, 2, 2, 5);
                g.drawLine(1, 3, 1, 4);
            }
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        @Override
        public int getIconHeight() {
            return menuArrowIconSize.height;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 5000432542876005162L;
        protected static final int CHECKBOXSIZE = 16;
        protected static Image[] images;

        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel m = cb.getModel();
            if (!(m instanceof CheckBoxModel)) {
                this.paintIconDefault(c, g, x, y);
                return;
            }
            CheckBoxModel model = (CheckBoxModel)m;
            int selected = model.getSelected();
            int state = 1;
            Image image = images[0];
            if (!model.isEnabled()) {
                state = 8;
            } else if (model.isPressed() && model.isArmed()) {
                state = 4;
            } else if (cb.isRolloverEnabled() && model.isRollover()) {
                state = 2;
            }
            image = images[this.getImageIndex(selected, state)];
            g.translate(x, y);
            g.drawImage(image, 0, 0, c);
            g.translate(-x, -y);
        }

        public void paintIconDefault(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            int selected = model.isSelected() ? 32 : 16;
            int state = 1;
            Image image = images[0];
            if (!model.isEnabled()) {
                state = 8;
            } else if (model.isPressed() && model.isArmed()) {
                state = 4;
            } else if (cb.isRolloverEnabled() && model.isRollover()) {
                state = 2;
            }
            image = images[this.getImageIndex(selected, state)];
            g.translate(x, y);
            g.drawImage(image, 0, 0, c);
            g.translate(-x, -y);
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect(x + 3, y + 5, 2, controlSize - 8);
            g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
            g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
        }

        private int getImageIndex(int selected, int state) {
            int mousseStates = 4;
            int i = 0;
            int j = 0;
            switch (selected) {
                case 16: {
                    i = 0;
                    break;
                }
                case 32: {
                    i = 1;
                    break;
                }
                case 64: {
                    i = 2;
                    break;
                }
                default: {
                    i = 0;
                }
            }
            switch (state) {
                case 1: {
                    j = 0;
                    break;
                }
                case 2: {
                    j = 1;
                    break;
                }
                case 4: {
                    j = 2;
                    break;
                }
                case 8: {
                    j = 3;
                    break;
                }
                default: {
                    j = 0;
                }
            }
            return i * 4 + j;
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }

        static {
            String compStr = "checkbox";
            String[] selectedStrs = new String[]{"_unselected", "_selected", "_partselected"};
            String[] mouseStrs = new String[]{"_off", "_on", "_down", "_disable"};
            String ext = ".gif";
            int index = 0;
            images = new Image[selectedStrs.length * mouseStrs.length];
            for (int i = 0; i < selectedStrs.length; ++i) {
                for (int j = 0; j < mouseStrs.length; ++j) {
                    CheckBoxIcon.images[index] = KDResourceManager.getImageOfRapid(compStr + selectedStrs[i] + mouseStrs[j] + ext);
                    ++index;
                }
            }
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = -903780166787596111L;
        protected static Image unselect_off = ((ImageIcon)UIManager.get("RadioButton.initIcon")).getImage();
        protected static Image unselect_on = ((ImageIcon)UIManager.get("RadioButton.initIcon")).getImage();
        protected static Image unselect_down = ((ImageIcon)UIManager.get("RadioButton.clickIcon")).getImage();
        protected static Image unselect_disable = ((ImageIcon)UIManager.get("RadioButton.disableIcon")).getImage();
        protected static Image selected_off = ((ImageIcon)UIManager.get("RadioButton.selectedIcon")).getImage();
        protected static Image selected_on = ((ImageIcon)UIManager.get("RadioButton.selectedIcon")).getImage();
        protected static Image selected_down = ((ImageIcon)UIManager.get("RadioButton.selectedClickIcon")).getImage();
        protected static Image selected_disable = ((ImageIcon)UIManager.get("RadioButton.selectedDisableIcon")).getImage();
        private static final int RADIOICONWIDTH = 16;
        private static final int RADIOICONHEIGHT = 16;

        private RadioButtonIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JRadioButton rb = (JRadioButton)c;
            ButtonModel model = rb.getModel();
            int selected = model.isSelected() ? 32 : 16;
            int state = 1;
            Image image = unselect_off;
            if (!model.isEnabled()) {
                state = 8;
            } else if (model.isPressed() && model.isArmed()) {
                state = 4;
            } else if (rb.isRolloverEnabled() && model.isRollover()) {
                state = 2;
            }
            switch (ButtonStatesUtil.getState(selected, state)) {
                case 17: {
                    image = unselect_off;
                    break;
                }
                case 18: {
                    image = unselect_on;
                    break;
                }
                case 20: {
                    image = unselect_down;
                    break;
                }
                case 24: {
                    image = unselect_disable;
                    break;
                }
                case 33: {
                    image = selected_off;
                    break;
                }
                case 34: {
                    image = selected_on;
                    break;
                }
                case 36: {
                    image = selected_down;
                    break;
                }
                case 40: {
                    image = selected_disable;
                    break;
                }
            }
            g.translate(x, y);
            g.drawImage(image, 0, 0, c);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

