/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.splash;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

class ColorTintFilter
implements BufferedImageOp {
    private final Color mixColor;
    private final float mixValue;

    public ColorTintFilter(Color mixColor, float mixValue) {
        this.mixColor = mixColor;
        if (mixValue < 0.0f) {
            mixValue = 0.0f;
        } else if (mixValue > 1.0f) {
            mixValue = 1.0f;
        }
        this.mixValue = mixValue;
    }

    public float getMixValue() {
        return this.mixValue;
    }

    public Color getMixColor() {
        return this.mixColor;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), destCM.isAlphaPremultiplied(), null);
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        this.mixColor(pixels);
        this.setPixels(dest, 0, 0, width, height, pixels);
        return dest;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return (Point2D)srcPt.clone();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    private int[] getPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (w == 0 || h == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w * h];
        } else if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels.length >= w * h");
        }
        int imageType = img.getType();
        if (imageType == 1 || imageType == 2) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h, pixels);
        }
        return img.getRGB(x, y, w, h, pixels, 0, w);
    }

    private void setPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (pixels == null || w == 0 || h == 0) {
            return;
        }
        if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels.length >= w * h");
        }
        int imageType = img.getType();
        if (imageType == 1 || imageType == 2) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h, pixels);
        } else {
            img.setRGB(x, y, w, h, pixels, 0, w);
        }
    }

    private void mixColor(int[] pixels) {
        int mix_r = this.mixColor.getRed();
        int mix_g = this.mixColor.getGreen();
        int mix_b = this.mixColor.getBlue();
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            int a = argb & 0xFF000000;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            r = (int)((float)r * (1.0f - this.mixValue) + (float)mix_r * this.mixValue);
            g = (int)((float)g * (1.0f - this.mixValue) + (float)mix_g * this.mixValue);
            b = (int)((float)b * (1.0f - this.mixValue) + (float)mix_b * this.mixValue);
            pixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }
}

