/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.easprogressbar.plaf;

import com.kingdee.bos.ctrl.easprogressbar.plaf.KingdeeUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class KingdeeProgressBarUI
extends BasicProgressBarUI {
    private static final Color CellsShadowColor = new Color(6998008);
    private static final Color CellsDarkShadowColor = new Color(57, 166, 222);
    private static final Color BACKSTART = new Color(4025763);
    private static final Color BACKEND = new Color(5145274);

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeProgressBarUI();
    }

    protected Color getCellsShadow() {
        return CellsShadowColor;
    }

    protected Color getCellsDarkShadow() {
        return CellsDarkShadowColor;
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int cellLength = this.getCellLength();
        int cellSpacing = this.getCellSpacing();
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        BasicStroke cellsStrock = null;
        BasicStroke shadowStrock = null;
        if (this.progressBar.getOrientation() == 0) {
            if (cellSpacing == 0 && amountFull > 0) {
                cellsStrock = new BasicStroke(barRectHeight, 0, 2);
                shadowStrock = new BasicStroke(1.0f, 0, 2);
            } else {
                cellsStrock = new BasicStroke(barRectHeight, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f);
                shadowStrock = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f);
            }
            GradientPaint bkpaint = new GradientPaint(b.left, b.top, BACKSTART, b.left, b.top + barRectHeight, BACKEND);
            g2.setPaint(bkpaint);
            g2.fillRect(b.left, b.top, barRectWidth, barRectHeight);
            if (KingdeeUtils.isLeftToRight(c)) {
                g2.setStroke(cellsStrock);
                g2.setColor(this.progressBar.getForeground());
                g2.drawLine(b.left, barRectHeight / 2 + b.top, amountFull + b.left, barRectHeight / 2 + b.top);
                g2.setStroke(shadowStrock);
                g2.setColor(this.getCellsShadow());
                g2.drawLine(b.left, b.top, amountFull + b.left - 1, b.top);
                g2.setColor(this.getCellsDarkShadow());
                g2.drawLine(b.left, barRectHeight + b.top - 1, amountFull + b.left - 1, barRectHeight + b.top - 1);
            } else {
                g2.setStroke(cellsStrock);
                g2.setColor(this.progressBar.getForeground());
                g2.drawLine(barRectWidth + b.left, barRectHeight / 2 + b.top, barRectWidth + b.left - amountFull, barRectHeight / 2 + b.top);
                g2.setStroke(shadowStrock);
                g2.setColor(this.getCellsShadow());
                g2.drawLine(barRectWidth + b.left, b.top, barRectWidth + b.left - amountFull, b.top);
                g2.setColor(this.getCellsDarkShadow());
                g2.drawLine(barRectWidth + b.left, barRectHeight + b.top - 1, barRectWidth + b.left - amountFull, barRectHeight + b.top - 1);
            }
        } else {
            if (cellSpacing == 0 && amountFull > 0) {
                cellsStrock = new BasicStroke(barRectWidth, 0, 2);
                shadowStrock = new BasicStroke(1.0f, 0, 2);
            } else {
                cellsStrock = new BasicStroke(barRectWidth, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f);
                shadowStrock = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f);
            }
            GradientPaint bkpaint = new GradientPaint(b.left, b.top, BACKSTART, b.left + barRectWidth, b.top, BACKEND);
            g2.setPaint(bkpaint);
            g2.fillRect(b.left, b.top, barRectWidth, barRectHeight);
            g2.setStroke(cellsStrock);
            g2.setColor(this.progressBar.getForeground());
            g2.drawLine(barRectWidth / 2 + b.left, b.top + barRectHeight, barRectWidth / 2 + b.left, b.top + barRectHeight - amountFull);
            g2.setStroke(shadowStrock);
            g2.setColor(this.getCellsShadow());
            g2.drawLine(b.left, b.top + barRectHeight, b.left, b.top + barRectHeight - amountFull);
            g2.setColor(this.getCellsDarkShadow());
            g2.drawLine(b.left + barRectWidth - 1, b.top + barRectHeight, b.left + barRectWidth - 1, b.top + barRectHeight - amountFull);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        GradientPaint bkpaint;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g2 = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            bkpaint = new GradientPaint(b.left, b.top, BACKSTART, b.left, b.top + barRectHeight, BACKEND);
            g2.setPaint(bkpaint);
            g2.fillRect(b.left, b.top, barRectWidth, barRectHeight);
        } else {
            bkpaint = new GradientPaint(b.left, b.top, BACKSTART, b.left + barRectWidth, b.top, BACKEND);
            g2.setPaint(bkpaint);
            g2.fillRect(b.left, b.top, barRectWidth, barRectHeight);
        }
        Rectangle r = null;
        r = this.getBox(r);
        if (r != null) {
            g2.setColor(this.progressBar.getForeground());
            g2.fillRect(r.x, r.y, r.width, r.height);
            g2.setColor(this.getCellsShadow());
            g2.drawLine(r.x, r.y, r.x + r.width - 1, r.y);
            g2.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
            g2.setColor(this.getCellsDarkShadow());
            g2.drawLine(r.x + r.width - 1, r.y + 1, r.x + r.width - 1, r.y + r.height - 1);
            g2.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, r.x, r.width, b);
            } else {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, r.y, r.height, b);
            }
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, height);
            g.drawString(progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, width, amountFull);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }

    protected Color getSelectionForeground() {
        return new Color(2902393);
    }

    protected Color getSelectionBackground() {
        return Color.WHITE;
    }
}

