/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.eas.base.permission.service.helper.ekey.NativeTool;
import java.io.File;
import java.io.IOException;

public class LoadNativeDllHelper {
    public static boolean checkHaveFile(String fullFileName) throws IOException {
        File file = new File(fullFileName);
        boolean hasFile = file.exists();
        if (!hasFile) {
            throw new IOException("filename not found!");
        }
        return hasFile;
    }

    public static boolean checkHaveDll(String dllName) throws IOException {
        if (dllName == null || dllName.trim().length() == 0) {
            return false;
        }
        String fullDllName = LoadNativeDllHelper.getSystemRoot() + File.separator + dllName;
        return LoadNativeDllHelper.checkHaveFile(fullDllName);
    }

    public static void ensureFileExist(String dllName) throws IOException {
        if (!LoadNativeDllHelper.checkHaveDll(dllName)) {
            throw new IOException("dllName is not found!");
        }
    }

    public static void loadFile(String filename) throws IOException {
        LoadNativeDllHelper.checkHaveFile(filename);
        System.load(filename);
    }

    public static String getSystemRoot() throws IOException {
        NativeTool tool = new NativeTool();
        return tool.getSystemPath();
    }
}

