/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.eas.webutil.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class SmartClassLoader
extends SecureClassLoader {
    protected Hashtable classCache = new Hashtable();
    protected Hashtable resCache = new Hashtable();
    protected Hashtable packageCache = new Hashtable();
    protected Hashtable jarFileCache = new Hashtable();
    protected boolean debug = false;
    protected Properties packageToJarMap = new Properties();
    protected ClassLoaderListener listener = null;
    protected boolean hasCheckClassPath = false;
    protected boolean firstCall = true;
    protected ClassLoader currentClassLoader = null;

    public SmartClassLoader(ClassLoader loader) {
        super(loader);
    }

    public void setClassLoaderListener(ClassLoaderListener cll) {
        if (this.listener != null) {
            return;
        }
        this.listener = cll;
        ConsoleLogger.info("[CL_INFO]  SmartClassLoader Listener register successful!");
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    public URL getResource(String name) {
        if (name == null) {
            return null;
        }
        if (this.debug) {
            ConsoleLogger.info("[CL_DEBUG] Trying to load resource[" + name + "]...");
        }
        URL url = null;
        url = (URL)this.resCache.get(name);
        if (url != null) {
            if (this.debug) {
                ConsoleLogger.info("[CL_DEBUG] Resource[" + name + "] was loaded from cache!");
            }
        } else {
            if (this.debug) {
                ConsoleLogger.info("[CL_DEBUG] Resource[" + name + "] is not loaded yet, try to load it from parent ...");
            }
            if ((url = this.getParent().getResource(name)) != null) {
                this.resCache.put(name, url);
                if (this.debug) {
                    ConsoleLogger.info("[CL_DEBUG] Resource[" + name + "] was loaded from parent!");
                }
            } else if (this.listener != null) {
                this.checkFirstCall();
                if (this.debug) {
                    ConsoleLogger.info("[CL_DEBUG] Resource[" + name + "] not found in parent, try to load it from classes directory ...");
                }
                if ((url = (URL)this.loadFromClassesDir(null, name)) != null) {
                    this.resCache.put(name, url);
                    if (this.debug) {
                        ConsoleLogger.info("[CL_DEBUG] Resource[" + name + "] was loaded from classes directory!");
                    }
                } else {
                    if (this.debug) {
                        ConsoleLogger.info("[CL_DEBUG] Resource[" + name + "] not found in classes dir, try to load it from jars ...");
                    }
                    if ((url = (URL)this.loadFromJarList(null, name)) != null) {
                        if (this.debug) {
                            ConsoleLogger.info("[CL_DEBUG] Resource[" + name + "] was loaded from Jar!");
                        }
                        this.resCache.put(name, url);
                    }
                }
            }
        }
        if (url != null) {
            if (this.debug) {
                ConsoleLogger.info("[CL_DEBUG] Resource[" + name + "] was loaded in SmartClassLoader!");
            }
        } else if (this.debug) {
            ConsoleLogger.info("[CL_WARN]  Resource[" + name + "] not found in SmartClassLoader!");
        }
        return url;
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class c = null;
        if (className == null) {
            return null;
        }
        if (this.debug) {
            ConsoleLogger.info("[CL_DEBUG] Trying to load class[" + className + "]...");
        }
        if ((c = this.findLoadedClass(className)) != null) {
            if (this.debug) {
                ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] is already loaded!");
            }
        } else {
            c = (Class)this.classCache.get(className);
            if (c != null) {
                if (this.debug) {
                    ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] was loaded from smartclassloader's cache!");
                }
            } else {
                block26: {
                    if (this.debug) {
                        ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] is not loaded yet, try to load it from parent ...");
                    }
                    try {
                        c = this.getParent().loadClass(className);
                    }
                    catch (ClassNotFoundException cnfex) {
                        if (!this.debug) break block26;
                        ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] is not found in parent classloader!");
                        if (this.listener != null) break block26;
                        throw cnfex;
                    }
                }
                if (c != null) {
                    if (this.debug) {
                        ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] was loaded from parent classloader!");
                    }
                    this.classCache.put(className, c);
                } else if (this.listener != null) {
                    this.checkFirstCall();
                    String clsName = className.replace('.', '/') + ".class";
                    if (this.debug) {
                        ConsoleLogger.info("[CL_DEBUG] Try to load class[" + className + "] from classes directory ...");
                    }
                    if ((c = (Class)this.loadFromClassesDir(className, clsName)) != null) {
                        if (this.debug) {
                            ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] was loaded from classes directory!");
                        }
                        this.classCache.put(className, c);
                    } else {
                        if (this.debug) {
                            ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] is not found in classes directory, try to load it from jars ...");
                        }
                        if ((c = (Class)this.loadFromJarList(className, clsName)) != null) {
                            if (this.debug) {
                                ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] was loaded from jar[" + c.getProtectionDomain().getCodeSource() + "]!");
                            }
                            this.classCache.put(className, c);
                        }
                    }
                }
            }
        }
        if (c != null) {
            if (this.debug) {
                ConsoleLogger.info("[CL_DEBUG] Class[" + className + "] was loaded in SmartClassLoader!");
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (this.debug) {
            ConsoleLogger.info("[CL_WARN]  Class[" + className + "] not found in SmartClassLoader!");
        }
        throw new ClassNotFoundException("Class[" + className + "] not found in SmartClassLoader!");
    }

    private void checkFirstCall() {
        if (this.firstCall) {
            this.debug = Boolean.getBoolean("SmartClassLoader.debug");
            System.out.println();
            System.out.println("===============================================================");
            System.out.println("                Kingdee EAS Class Loader                       ");
            System.out.println();
            System.out.println("                   Copyright (c) 2007                          ");
            System.out.println("             Kingdee Software (China) Co., Ltd.                ");
            System.out.println("===============================================================");
            System.out.println();
            ConsoleLogger.info("Parent classloader: " + this.getParent());
            try {
                Properties temp = new Properties();
                FileInputStream input = new FileInputStream(this.listener.getLocalPath() + "/classloader/pkmap.lst");
                temp.load(input);
                input.close();
                this.packageToJarMap.putAll((Map<?, ?>)temp);
            }
            catch (Exception e) {
                System.err.println("[CL_ERR]   Check package.lst error[" + e.getMessage() + "]!");
                e.printStackTrace();
            }
            this.firstCall = false;
        }
    }

    protected Object loadFromJarList(String className, String resName) {
        String libList;
        String packageName = resName;
        if (resName.indexOf(47) > 0) {
            packageName = resName.substring(0, resName.lastIndexOf(47));
        }
        if (this.debug) {
            ConsoleLogger.info("[CL_DEBUG] Begin check package [" + packageName + "] .....");
        }
        if ((libList = this.packageToJarMap.getProperty(packageName, "")).length() > 0) {
            String[] libs = libList.split(";");
            for (int i = 0; i < libs.length; ++i) {
                try {
                    ZipEntry clsEntry;
                    File jarUrl = (File)this.packageCache.get(libs[i]);
                    if (jarUrl == null) {
                        if (this.debug) {
                            ConsoleLogger.info("[CL_DEBUG] Check remote package[" + this.listener.getRemoteServer() + libs[i] + "] ...");
                        }
                        jarUrl = (File)this.updateResource(libs[i]);
                    }
                    if (jarUrl == null) {
                        System.err.println("[CL_ERR]   Jar file[" + libs[i] + "] not found!");
                        continue;
                    }
                    Serializable res = null;
                    JarFile jarFile = (JarFile)this.jarFileCache.get(libs[i]);
                    if (jarFile == null) {
                        try {
                            jarFile = new JarFile(jarUrl);
                            this.jarFileCache.put(libs[i], jarFile);
                        }
                        catch (ZipException e) {
                            System.err.println("[CL_ERR]   Error in opening zip file[" + libs[i] + "], download again!");
                            if (jarUrl.delete()) {
                                jarUrl = (File)this.updateResource(libs[i]);
                                jarFile = new JarFile(jarUrl);
                            }
                            System.err.println("[CL_ERR]   Error in delete zip file[" + libs[i] + "]!");
                            throw new RuntimeException("Class can load from jarfile[" + libs[i] + "], is not a jar file!", e);
                        }
                    }
                    if ((clsEntry = jarFile.getEntry(resName)) != null) {
                        if (className != null) {
                            InputStream clsInputStream = jarFile.getInputStream(clsEntry);
                            byte[] resBytes = this.readBytesFromInputStream(clsInputStream);
                            clsInputStream.close();
                            try {
                                this.definePackage(className, jarFile.getManifest());
                                res = this.defineClass(className, resBytes, 0, resBytes.length);
                            }
                            catch (ClassFormatError e) {
                                e.printStackTrace();
                                System.err.println("[CL_ERR]   Error in define class[" + className + "] from jar[" + libs[i] + "]!");
                            }
                        } else {
                            res = new URL("jar:file:" + jarUrl.getCanonicalPath() + "!/" + resName);
                        }
                        if (res != null && this.debug) {
                            ConsoleLogger.info("[CL_INFO]  Resource[" + resName + "] has loaded from jar[" + jarUrl.getCanonicalPath() + "]!");
                        }
                        return res;
                    }
                    if (!this.debug) continue;
                    ConsoleLogger.info("[CL_TRACE] Resource[" + resName + "] not found jar[" + jarUrl.getCanonicalPath() + "]!");
                    continue;
                }
                catch (Throwable e) {
                    System.err.println("[CL_ERR]   Load resource[" + resName + "] from jars error[" + e.getMessage() + "]!");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected Object loadFromClassesDir(String className, String resName) {
        resName = "/classes/" + resName;
        try {
            Object resResult = this.updateResource(resName);
            Serializable res = null;
            if (className != null) {
                byte[] resBytes = (byte[])resResult;
                if (resBytes != null) {
                    this.definePackage(className, null);
                    res = this.defineClass(className, resBytes, 0, resBytes.length);
                }
            } else {
                res = (URL)resResult;
            }
            if (res != null && this.debug) {
                ConsoleLogger.info("[CL_INFO]  Resource[" + resName + "] has loaded from classes directory!");
            }
            return res;
        }
        catch (Throwable e) {
            System.err.println("[CL_ERR]   Load resource[" + resName + "] from classes directory error[" + e.getMessage() + "]!");
            e.printStackTrace();
            return null;
        }
    }

    protected Object updateResource(String resRelativePath) {
        File localRes = new File(this.listener.getLocalPath() + resRelativePath);
        try {
            boolean needUpdate;
            if (this.debug) {
                ConsoleLogger.info("[CL_DEBUG] Check remote resource[" + this.listener.getRemoteServer() + resRelativePath + "] ...");
            }
            if (needUpdate = this.listener.updateResource(resRelativePath)) {
                if (this.debug) {
                    ConsoleLogger.info("[CL_INFO]  Remote resource is newer, download resource[" + resRelativePath + "]...");
                }
                Object res = null;
                if (resRelativePath.toLowerCase().endsWith(".class")) {
                    res = this.loadLocalResource(localRes);
                } else if (resRelativePath.toLowerCase().endsWith(".jar") || resRelativePath.toLowerCase().endsWith(".zip")) {
                    res = localRes;
                    this.packageCache.put(resRelativePath, res);
                } else {
                    res = localRes.toURL();
                }
                if (this.debug) {
                    ConsoleLogger.info("[CL_INFO]  Remote resource[" + resRelativePath + "] download finished and loaded!");
                }
                return res;
            }
            if (localRes.exists()) {
                if (this.debug) {
                    ConsoleLogger.info("[CL_DEBUG] Try to load resource [" + resRelativePath + "] from local cache...");
                }
                Object res = null;
                if (resRelativePath.endsWith(".class")) {
                    FileInputStream input = new FileInputStream(localRes);
                    byte[] clsBytes = this.readBytesFromInputStream(input);
                    input.close();
                    res = clsBytes;
                    if (this.debug) {
                        ConsoleLogger.info("[CL_DEBUG] Class[" + resRelativePath + "] has loaded from local cache!");
                    }
                } else if (resRelativePath.toLowerCase().endsWith(".jar") || resRelativePath.toLowerCase().endsWith(".zip")) {
                    res = localRes;
                    this.packageCache.put(resRelativePath, res);
                    if (this.debug) {
                        ConsoleLogger.info("[CL_DEBUG] Jar[" + resRelativePath + "] has loaded from local cache!");
                    }
                } else {
                    res = localRes.toURL();
                    if (this.debug) {
                        ConsoleLogger.info("[CL_DEBUG] Resource[" + resRelativePath + "] has loaded from local cache!");
                    }
                }
                return res;
            }
        }
        catch (Throwable e) {
            if (e instanceof ClassCircularityError) {
                System.err.println("[CL_ERR]   java.lang.ClassCircularityError: [" + e.getMessage() + "]!");
            }
            if (e instanceof LinkageError) {
                System.err.println("[CL_ERR]   java.lang.LinkageError: [" + e.getMessage() + "]!");
            }
            System.err.println("[CL_ERR]   Update resource[" + resRelativePath + "]  error[" + e.getMessage() + "]!");
            e.printStackTrace();
        }
        return null;
    }

    private byte[] loadLocalResource(File localRes) {
        try {
            FileInputStream input = new FileInputStream(localRes);
            byte[] resource = this.readBytesFromInputStream(input);
            ((InputStream)input).close();
            return resource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] readBytesFromInputStream(InputStream input) throws IOException {
        int j;
        int l = 0;
        byte[] resBytes = new byte[1024];
        while ((j = input.read(resBytes, l, resBytes.length - l)) != -1) {
            if ((l += j) < resBytes.length) continue;
            byte[] abyte1 = new byte[l * 2];
            System.arraycopy(resBytes, 0, abyte1, 0, l);
            resBytes = abyte1;
        }
        if (l != resBytes.length) {
            byte[] abyte2 = new byte[l];
            System.arraycopy(resBytes, 0, abyte2, 0, l);
            resBytes = abyte2;
        }
        return resBytes;
    }

    protected void definePackage(String className, Manifest manifest) {
        int lastDot = className.lastIndexOf(46);
        String pkName = className;
        if (lastDot != -1) {
            pkName = className.substring(0, lastDot);
        }
        if (manifest == null || this.getPackage(pkName) != null) {
            return;
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        Attributes attrs = manifest.getMainAttributes();
        if (attrs != null) {
            specTitle = attrs.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attrs.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attrs.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attrs.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attrs.getValue(Attributes.Name.SPECIFICATION_VERSION);
            implVendor = attrs.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }
        this.definePackage(pkName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    public ClassLoader getCurrentClassLoader() {
        return this.currentClassLoader;
    }

    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        this.currentClassLoader = currentClassLoader;
    }

    public static interface ClassLoaderListener {
        public boolean updateResource(String var1);

        public String getRemoteServer();

        public String getLocalPath();

        public HashMap getResourceMap();
    }
}

