/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.autoupdate;

import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.dl.DownloadException;
import com.kingdee.bos.autoupdate.jnl.ParseException;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.eas.applet.EASCacheEntryInfo;
import com.kingdee.eas.applet.autoupdate.AbstractCacheStateImpl;
import com.kingdee.eas.applet.autoupdate.CacheStateFactory;
import com.kingdee.eas.applet.autoupdate.ICacheState;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FullDLCacheStateImplWrapper
extends AbstractCacheStateImpl {
    private ICacheState baseCacheState = null;
    private ICacheState onDemandCacheState = null;
    private String onDemandJnlpRelativeUrl = "resource.lst";
    private String onDemandTraceFileName = "onDemandTrace.properties";

    public FullDLCacheStateImplWrapper(String jnlpUrl, String localPath, String modifyFileName, String ondemandjnlpF, String fulljnlpF) throws CacheException, DownloadException, ParseException {
        super(jnlpUrl, localPath);
        jnlpUrl = this.constructNewVerJnlpUrl(jnlpUrl);
        this.baseCacheState = CacheStateFactory.createRawCacheState(jnlpUrl, localPath, modifyFileName, ondemandjnlpF, fulljnlpF);
        String onDemandJnlpUrl = this.constructOnDemandJnlpUrl(jnlpUrl, this.onDemandJnlpRelativeUrl);
        this.onDemandCacheState = CacheStateFactory.createOnDemandDLCacheState(onDemandJnlpUrl, localPath, this.onDemandTraceFileName, ondemandjnlpF, fulljnlpF);
        this.merge();
    }

    private String constructNewVerJnlpUrl(String jnlpUrl) {
        if ((jnlpUrl = jnlpUrl.replaceAll("autoDownload=false", "autoDownload=true")).indexOf("autoDownload=true") < 0) {
            jnlpUrl = jnlpUrl.indexOf("?") > -1 ? jnlpUrl + "&autoDownload=true" : jnlpUrl + "?autoDownload=true";
        }
        return jnlpUrl;
    }

    private String constructOnDemandJnlpUrl(String jnlpUrl, String relativeUrl) {
        String result = null;
        try {
            URL jnlpURL = new URL(jnlpUrl);
            URL resultURL = new URL(jnlpURL, relativeUrl);
            result = resultURL.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void merge() {
        this.init();
        this.removeOldVerResx();
        this.mergeNewVerResx();
    }

    private void mergeNewVerResx() {
        this.dirtyResources.addAll(this.onDemandCacheState.getUpdatedResources());
        this.deletedResources.addAll(this.onDemandCacheState.getDeletedResources());
        this.pack200Resources.addAll(this.onDemandCacheState.getPack200Resources());
        if (this.localCache != null && this.onDemandCacheState.getLocalCacheEntryInfo() != null) {
            this.localCache.getCacheEntries().addAll(this.onDemandCacheState.getLocalCacheEntryInfo().getCacheEntries());
        }
        if (this.serverCache != null && this.onDemandCacheState.getServerCacheEntryInfo() != null) {
            this.serverCache.getCacheEntries().addAll(this.onDemandCacheState.getServerCacheEntryInfo().getCacheEntries());
        }
        this.isLocalNoCache = this.baseCacheState.isLocalNoCache() && this.onDemandCacheState.isLocalNoCache();
        this.isNeedUpdate = this.baseCacheState.isNeedUpdate() || this.onDemandCacheState.isNeedUpdate();
        this.isNeedDelete = this.baseCacheState.isNeedDelete() || this.onDemandCacheState.isNeedDelete();
    }

    private void removeOldVerResx() {
        this.removeDeletedResources();
        this.removeLocalCache();
    }

    private void removeLocalCache() {
        if (this.localCache != null && this.baseCacheState.getServerCacheEntryInfo() != null && this.onDemandCacheState.getLocalCacheEntryInfo() != null) {
            List resx = this.getSameResources(this.baseCacheState.getCodebase(), this.localCache.getCacheEntries(), this.toMap(this.onDemandCacheState.getLocalCacheEntryInfo()));
            this.localCache.getCacheEntries().removeAll(resx);
        }
    }

    private void removeDeletedResources() {
        if (this.baseCacheState.getServerCacheEntryInfo() != null && this.onDemandCacheState.getLocalCacheEntryInfo() != null) {
            List resx = this.getSameResources(this.baseCacheState.getCodebase(), this.deletedResources, this.toMap(this.onDemandCacheState.getLocalCacheEntryInfo()));
            this.deletedResources.removeAll(resx);
        }
    }

    private List getSameResources(URL codebase, List firstResx, Map secondResx) {
        ArrayList<EASCacheEntryInfo> sameResx = new ArrayList<EASCacheEntryInfo>();
        Iterator ite = firstResx.iterator();
        EASCacheEntryInfo entryInfo = null;
        String relativePath = null;
        while (ite.hasNext()) {
            entryInfo = (EASCacheEntryInfo)((Object)ite.next());
            relativePath = URLUtil.getRelativePath((URL)codebase, (URL)entryInfo.getHref());
            if (!secondResx.containsKey(relativePath)) continue;
            sameResx.add(entryInfo);
        }
        return sameResx;
    }

    private void init() {
        this.dirtyResources = this.baseCacheState.getUpdatedResources();
        this.deletedResources = this.baseCacheState.getDeletedResources();
        this.pack200Resources = this.baseCacheState.getPack200Resources();
        this.localCache = this.baseCacheState.getLocalCacheEntryInfo();
        this.serverCache = this.baseCacheState.getServerCacheEntryInfo();
        this.isLocalNoCache = this.baseCacheState.isLocalNoCache();
        this.isNeedUpdate = this.baseCacheState.isNeedUpdate();
        this.isNeedDelete = this.baseCacheState.isNeedDelete();
    }

    public void storeCacheState(HashMap exculdedMap) throws CacheException {
        this.baseCacheState.storeCacheState(exculdedMap);
        this.onDemandCacheState.storeCacheState(exculdedMap);
    }

    public void startTrace() {
        this.baseCacheState.startTrace();
        this.onDemandCacheState.startTrace();
    }
}

