/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.autoupdate;

import com.kingdee.eas.applet.autoupdate.JnlpServerCtrlParameter;
import com.kingdee.eas.webutil.URLUtils;
import java.net.URL;

public class JnlpServerCtrlParamsUtils {
    public static final String AUTO_UPDATE = "autoUpdate";
    public static final String JNLP_VERSION = "jnlpVersion";
    public static final String MAX_VER_COPY_COUNT = "maxVerCopyCount";
    public static final String ENABLE_VER_SWITCH = "enableVerSwitch";
    public static final String RES_PATHS = "resPaths";
    public static final String RES_ITEMS_EXCLUDED = "resItemsExcluded";

    public static JnlpServerCtrlParameter parse(URL serverCacheUrl) {
        JnlpServerCtrlParameter params = new JnlpServerCtrlParameter();
        boolean enableVerSwitch = true;
        int maxVerCopyCount = 2;
        String serverCacheJnlpName = JnlpServerCtrlParamsUtils.extractFileNameFromUrlPath(serverCacheUrl.getPath());
        params.setServerCacheJnlpName(serverCacheJnlpName);
        String srvCacheUrlStr = serverCacheUrl.getQuery();
        enableVerSwitch = new Boolean(URLUtils.getParameter(srvCacheUrlStr, ENABLE_VER_SWITCH));
        params.setEnableVerSwitch(enableVerSwitch);
        try {
            maxVerCopyCount = new Integer(URLUtils.getParameter(srvCacheUrlStr, MAX_VER_COPY_COUNT));
        }
        catch (NumberFormatException e) {
            maxVerCopyCount = 2;
        }
        String serverJnlpVersion = URLUtils.getParameter(srvCacheUrlStr, JNLP_VERSION);
        params.setJnlpVersion(serverJnlpVersion);
        String autoUpdateStr = URLUtils.getParameter(srvCacheUrlStr, AUTO_UPDATE);
        boolean autoUpdate = autoUpdateStr == null || !"false".equalsIgnoreCase(autoUpdateStr);
        params.setAutoUpdate(autoUpdate);
        String resItemsExcluded = URLUtils.getParameter(srvCacheUrlStr, RES_ITEMS_EXCLUDED);
        params.setResItemsExcluded(resItemsExcluded);
        String resPaths = URLUtils.getParameter(srvCacheUrlStr, RES_PATHS);
        params.setResPaths(resPaths);
        return params;
    }

    private static String extractFileNameFromUrlPath(String urlPath) {
        int index = urlPath.lastIndexOf("/");
        int length = urlPath.length();
        return urlPath.substring(index + 1, length);
    }
}

