/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.framework;

import com.kingdee.eas.applet.IJSParameterProvider;
import com.kingdee.eas.applet.JSParameterProviderFactory;
import com.kingdee.eas.applet.framework.AppletRuningException;
import com.kingdee.eas.applet.framework.AppletThreadServiceAdapter;
import com.kingdee.eas.applet.framework.BizServiceProviderProxy;
import com.kingdee.eas.applet.framework.EmbedUIAppletContainer;
import com.kingdee.eas.applet.framework.NoIdleThreadException;
import com.kingdee.eas.applet.framework.ThreadManager;
import com.kingdee.eas.applet.framework.ThreadService;
import com.kingdee.eas.applet.resource.ResourceHelper;
import java.lang.reflect.Method;
import javax.swing.JApplet;

public class AppletThreadServiceImpl
extends AppletThreadServiceAdapter {
    private int maxThreadCount = 1;
    private ClassLoader cl = this.getClass().getClassLoader();
    private EmbedUIAppletContainer container = null;
    private BizServiceProviderProxy proxy = null;
    private Class serviceProviderClass = null;
    private Object serviceProvider = null;
    private IJSParameterProvider paramProvider = null;
    private boolean repaint = false;
    private Thread serviceThread = null;

    public AppletThreadServiceImpl(EmbedUIAppletContainer container) throws AppletRuningException {
        this(container, false, null);
    }

    public AppletThreadServiceImpl(EmbedUIAppletContainer container, boolean repaint) throws AppletRuningException {
        this(container, repaint, null);
    }

    public AppletThreadServiceImpl(EmbedUIAppletContainer container, boolean repaint, IJSParameterProvider paramProviderProxy) throws AppletRuningException {
        this(container, repaint, paramProviderProxy, null);
    }

    public AppletThreadServiceImpl(EmbedUIAppletContainer container, boolean repaint, IJSParameterProvider paramProviderProxy, BizServiceProviderProxy proxy) throws AppletRuningException {
        this.container = container;
        this.proxy = proxy;
        this.paramProvider = paramProviderProxy;
        this.repaint = repaint;
        try {
            this.serviceThread = ThreadManager.getInstance(this);
        }
        catch (NoIdleThreadException e) {
            e.printStackTrace();
            throw new AppletRuningException(AppletRuningException.APPLET_INIT_FAILS, e);
        }
    }

    public void invokeService() {
        try {
            this.serviceThread = ThreadManager.getInstance(this);
            System.out.println("start biz service thread:" + ((ThreadService)this.serviceThread).getCurrentThreadKey());
            this.serviceThread.start();
        }
        catch (NoIdleThreadException e1) {
            System.out.println(e1.toString());
        }
        catch (IllegalThreadStateException e) {
            System.out.println("biz service thread[" + ((ThreadService)this.serviceThread).getCurrentThreadKey() + "] is started.");
            throw e;
        }
    }

    public void run() {
        long start = System.currentTimeMillis();
        try {
            this.loadServiceProvider();
            String invokeMethod = this.paramProvider.getInvokeMethod();
            if (invokeMethod != null && !"".equals(invokeMethod)) {
                Object result = this.invokeService(invokeMethod, this.paramProvider.getInvokeParameterTypes(), this.paramProvider.getInvokeParameterValues());
                this.paramProvider.setReturnValue(result);
                this.paramProvider.consume();
            }
            this.repaint();
            this.container.guiHandleStatus(ResourceHelper.getString("taskEnd"));
            long cost = System.currentTimeMillis() - start;
            System.out.println(" finished invoking biz service [" + this.paramProvider.getInvokeClassName() + "." + invokeMethod + "],spent " + cost + " ms.");
        }
        catch (Throwable e) {
            this.container.guiHandleStatus(ResourceHelper.getString("taskError"));
            this.serviceProviderClass = null;
            e.printStackTrace();
        }
    }

    private void repaint() {
        if (this.isRepaint()) {
            this.container.validateComponentTree();
            this.container.repaint();
        }
    }

    private boolean isRepaint() {
        return this.repaint;
    }

    Object invokeService(String methodName, Class[] paramTypes, Object[] paramValues) throws Exception {
        long start = System.currentTimeMillis();
        Method method = this.serviceProviderClass.getMethod(methodName, paramTypes);
        Object result = method.invoke(this.serviceProvider, paramValues);
        long cost = System.currentTimeMillis() - start;
        System.out.println("Invoke service " + methodName + " : " + cost + "ms!");
        return result;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void destory() {
    }

    public void setParamProvider(IJSParameterProvider paramProvider) {
        this.paramProvider = paramProvider;
    }

    public IJSParameterProvider getParamProvider() {
        return this.paramProvider;
    }

    public void loadServiceProvider() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        System.out.println("Init service provider start ");
        long start = System.currentTimeMillis();
        String invokeClassName = this.paramProvider.getInvokeClassName();
        if (this.proxy != null && invokeClassName == null || "".equals(invokeClassName)) {
            this.serviceProviderClass = this.proxy.getServiceProxyClass();
            this.serviceProvider = this.proxy.getServiceProxy();
            return;
        }
        if (this.serviceProviderClass != null && this.serviceProviderClass.getName().equals(invokeClassName)) {
            return;
        }
        this.serviceProviderClass = this.container.getClassLoader().loadClass(invokeClassName);
        System.out.println("LoadClass serviceProvider " + invokeClassName + " :" + (System.currentTimeMillis() - start) + "ms");
        long start2 = System.currentTimeMillis();
        this.serviceProvider = this.serviceProviderClass.newInstance();
        System.out.println("NewInstance serviceProvider " + invokeClassName + " :" + (System.currentTimeMillis() - start2) + "ms");
        long cost = System.currentTimeMillis() - start;
        System.out.println("Init service provider end : " + cost + "ms!");
    }

    private IJSParameterProvider createDefaultJSParameterProvider() {
        long start = System.currentTimeMillis();
        IJSParameterProvider result = JSParameterProviderFactory.createJSParameterProvider((String)"com.kingdee.eas.cp.eip.applet.EASJSParameterProviderProxy", (JApplet)this.container.getApplet());
        long cost = System.currentTimeMillis() - start;
        System.out.println("Init js parameter provider : " + cost + "ms!");
        return result;
    }
}

