/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.framework;

import com.kingdee.eas.applet.IJSParameterProvider;
import com.kingdee.eas.applet.JSParameterProviderFactory;
import com.kingdee.eas.applet.autoupdate.Logger;
import com.kingdee.eas.applet.framework.AppletRuningException;
import com.kingdee.eas.applet.framework.AppletThreadServiceAdapter;
import com.kingdee.eas.applet.framework.AppletThreadServiceImpl;
import com.kingdee.eas.applet.framework.EmbedUIAppletContainer;
import com.kingdee.eas.applet.framework.IAppletThreadService;
import com.kingdee.eas.applet.framework.NoIdleThreadException;
import com.kingdee.eas.applet.framework.ThreadManager;
import com.kingdee.eas.applet.framework.ThreadService;
import com.kingdee.eas.applet.resource.ResourceHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JPanel;

public class BizServiceProviderProxy
extends AppletThreadServiceAdapter {
    private Thread serviceThread = null;
    private Map services = new HashMap();
    private EmbedUIAppletContainer container = null;
    JPanel selfContentPane = new JPanel();
    boolean initedUI = false;
    private final String PARAM_SEPERATOR = ",";
    private Object serviceProxy = null;
    private Class serviceProxyClass = null;
    private IJSParameterProvider paramProviderImpl = null;
    private AppletThreadServiceImpl appletThread = null;

    public Object getServiceProxy() {
        return this.serviceProxy;
    }

    public Class getServiceProxyClass() {
        return this.serviceProxyClass;
    }

    public BizServiceProviderProxy(EmbedUIAppletContainer container) throws AppletRuningException {
        this.container = container;
        this.initServiceProxy();
        this.loadSysServices();
        this.loadAppServices();
        try {
            this.serviceThread = ThreadManager.getInstance(this);
        }
        catch (NoIdleThreadException e) {
            e.printStackTrace();
            throw new AppletRuningException(AppletRuningException.APPLET_INIT_FAILS, e);
        }
        this.appletThread = new AppletThreadServiceImpl(container);
    }

    private void initServiceProxy() throws AppletRuningException {
        Logger.getInstance().debug("Init service proxy start ");
        System.out.println("Init service proxy start ");
        long start = System.currentTimeMillis();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.serviceProxyClass = this.container.getClassLoader().loadClass("com.kingdee.eas.base.uiframe.client.AppletManagerProxy");
            Logger.getInstance().info("LoadClass serviceProvider :" + (System.currentTimeMillis() - start));
            System.out.println("LoadClass serviceProvider :" + (System.currentTimeMillis() - start));
            long start2 = System.currentTimeMillis();
            this.serviceProxy = this.serviceProxyClass.newInstance();
            Logger.getInstance().info("NewInstance serviceProvider :" + (System.currentTimeMillis() - start2));
            System.out.println("NewInstance serviceProvider :" + (System.currentTimeMillis() - start2));
            this.invokeService("init", new Class[]{JApplet.class, String.class}, new Object[]{this.container.getApplet(), this.container.getApplet().getParameter("appserver")});
        }
        catch (ClassNotFoundException e) {
            throw new AppletRuningException(AppletRuningException.INVALID_SERVICE_PROVIDER, e);
        }
        catch (InstantiationException e) {
            throw new AppletRuningException(AppletRuningException.INVALID_SERVICE_PROVIDER, e);
        }
        catch (IllegalAccessException e) {
            throw new AppletRuningException(AppletRuningException.INVALID_SERVICE_PROVIDER, e);
        }
        long cost = System.currentTimeMillis() - start;
        Logger.getInstance().debug("Init service provider end : " + cost + "ms!");
    }

    private Object invokeService(String methodName, Class[] paramTypes, Object[] paramValues) throws AppletRuningException {
        try {
            Method method = this.serviceProxyClass.getMethod(methodName, paramTypes);
            Object result = method.invoke(this.serviceProxy, paramValues);
            return result;
        }
        catch (SecurityException e) {
            throw new AppletRuningException(AppletRuningException.ACTION_PEFORM_FAILS, e);
        }
        catch (IllegalArgumentException e) {
            throw new AppletRuningException(AppletRuningException.ACTION_PEFORM_FAILS, e);
        }
        catch (NoSuchMethodException e) {
            throw new AppletRuningException(AppletRuningException.ACTION_PEFORM_FAILS, e);
        }
        catch (IllegalAccessException e) {
            throw new AppletRuningException(AppletRuningException.ACTION_PEFORM_FAILS, e);
        }
        catch (InvocationTargetException e) {
            throw new AppletRuningException(AppletRuningException.ACTION_PEFORM_FAILS, e);
        }
        catch (Throwable e) {
            throw new AppletRuningException(AppletRuningException.ACTION_PEFORM_FAILS, e);
        }
    }

    private void loadAppServices() {
    }

    private void loadSysServices() {
    }

    private IJSParameterProvider createParamProvider(String paramProvider, String bizServiceProvider, String bizServiceMethod, Class[] paramTypes, Object[] paramValues, String webEvent) {
        Object[] cstParamValues = new Object[]{paramProvider, this.container.getApplet()};
        IJSParameterProvider paramProviderProxy = JSParameterProviderFactory.createParamProviderProxy((String)"com.kingdee.eas.cp.eip.applet.EASJSParameterProviderProxy", (JApplet)this.container.getApplet(), (Object[])cstParamValues);
        paramProviderProxy.setInvokeClassName(bizServiceProvider);
        paramProviderProxy.setInvokeMethod(bizServiceMethod);
        paramProviderProxy.setInvokeParameterTypes(paramTypes);
        paramProviderProxy.setInvokeParameterValues(paramValues);
        paramProviderProxy.setEventBinding(webEvent);
        return paramProviderProxy;
    }

    protected IJSParameterProvider createParamProvider(HashMap params) {
        String paramProvider = (String)params.get("JSParameterProviderClassName");
        String bizServiceMethod = (String)params.get("invokeMethod");
        String bizServiceProvider = (String)params.get("invokeClassName");
        String webEvent = (String)params.get("returnEvent");
        Class[] paramTypes = (Class[])params.get("invokeParemterTypes");
        Object[] paramValues = (Class[])params.get("invokeParemterValues");
        IJSParameterProvider paramProviderProxy = this.createParamProvider(paramProvider, bizServiceProvider, bizServiceMethod, paramTypes, paramValues, webEvent);
        paramProviderProxy.setParams(params);
        return paramProviderProxy;
    }

    protected HashMap decodeOldJSParameter(String keysStr, String valuesStr) {
        String[] keys = keysStr.split(",");
        String[] values = valuesStr.split(",");
        if (keys.length < 1) {
            System.err.println("please set biz parameters(key & value pairs).");
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String val = "";
        for (int i = 0; i < keys.length; ++i) {
            val = i > values.length - 1 ? "" : values[i];
            params.put(keys[i], val);
        }
        return params;
    }

    public void invokeBizService(String keysStr, String valuesStr) {
        HashMap params = this.decodeOldJSParameter(keysStr, valuesStr);
        if (params == null) {
            return;
        }
        String type = (String)params.get("type");
        this.paramProviderImpl = this.createParamProvider(params);
        String className = this.paramProviderImpl.getInvokeClassName();
        if ("new".equals(type)) {
            this.run(this);
        } else {
            if (className == null) {
                this.paramProviderImpl.setInvokeClassName("com.kingdee.eas.base.uiframe.client.ServiceProvider");
            }
            this.appletThread.setParamProvider(this.paramProviderImpl);
            this.appletThread.invokeService();
        }
    }

    public void invokeClassUI(String uiClass, String uiClassParam, String uiOprt, String openMethod) throws AppletRuningException {
        this.invokeService("createUI", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{uiClass, uiClassParam, uiOprt, openMethod});
    }

    public void destoryApplet() throws AppletRuningException {
        this.invokeService("destory", new Class[0], new Object[0]);
    }

    private void run(IAppletThreadService threadServiceImpl) {
        try {
            this.serviceThread = ThreadManager.getInstance(threadServiceImpl);
            System.out.println("start biz service thread:" + ((ThreadService)this.serviceThread).getCurrentThreadKey());
            this.serviceThread.start();
        }
        catch (NoIdleThreadException e1) {
            System.out.println(e1.toString());
        }
        catch (IllegalThreadStateException e) {
            System.out.println("biz service thread[" + ((ThreadService)this.serviceThread).getCurrentThreadKey() + "] is started.");
            throw e;
        }
    }

    public void run() {
        long start = System.currentTimeMillis();
        String invokeMethod = this.paramProviderImpl.getInvokeMethod();
        try {
            if (invokeMethod != null && !"".equals(invokeMethod)) {
                Object result = this.invokeService(invokeMethod, this.paramProviderImpl.getInvokeParameterTypes(), this.paramProviderImpl.getInvokeParameterValues());
                this.paramProviderImpl.setReturnValue(result);
                this.paramProviderImpl.consume();
                this.container.guiHandleStatus(ResourceHelper.getString("taskEnd"));
            }
        }
        catch (AppletRuningException e) {
            this.container.guiHandleStatus(ResourceHelper.getString("taskError"));
            e.printStackTrace();
        }
        long cost = System.currentTimeMillis() - start;
        System.out.println(" finished invoking biz service [" + this.paramProviderImpl.getInvokeClassName() + "." + invokeMethod + "],spent " + cost + " ms.");
    }
}

