/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.webutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FileManager {
    public static void copyDir(String sourcedir, String destdir) throws Exception {
        File dest = new File(destdir);
        File source = new File(sourcedir);
        FileManager.copyDir(source, dest);
    }

    public static void copyDir(File source, File dest) throws Exception {
        String[] files = source.list();
        try {
            if (!dest.exists()) {
                dest.mkdirs();
            }
        }
        catch (Exception ex) {
            throw new Exception("CopyDir:" + ex.getMessage());
        }
        for (int i = 0; i < files.length; ++i) {
            String sourcefile = source + File.separator + files[i];
            String destfile = dest + File.separator + files[i];
            File temp = new File(sourcefile);
            if (temp.isFile()) {
                try {
                    FileManager.copy(sourcefile, destfile);
                    continue;
                }
                catch (Exception ex) {
                    throw new Exception("CopyDir:" + ex.getMessage());
                }
            }
            if (!temp.isDirectory()) continue;
            FileManager.copyDir(sourcefile, destfile);
        }
    }

    public static boolean copy(String input, String output) throws Exception {
        int BUFSIZE = 65536;
        try {
            int s;
            FileInputStream fis = new FileInputStream(input);
            FileOutputStream fos = new FileOutputStream(output);
            byte[] buf = new byte[BUFSIZE];
            while ((s = fis.read(buf)) > -1) {
                fos.write(buf, 0, s);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }
}

