/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.webutil;

import com.kingdee.eas.webutil.PropertiesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;

public class VMoptions {
    private Properties loadVMOptions() {
        Properties vmprops = new Properties();
        File vmPropsFile = new File(System.getProperty("EAS_HOME") + "/client/deploy/client/vmoptions.properties");
        if (vmPropsFile.exists()) {
            try {
                FileInputStream input = new FileInputStream(vmPropsFile);
                PropertiesUtils.load(vmprops, input);
                input.close();
            }
            catch (Exception e) {
                System.err.println("Load vmoptions error!");
                throw new RuntimeException("Load vmoptions error!");
            }
        }
        return vmprops;
    }

    public void initSystemPor() {
        Properties vmprops = this.loadVMOptions();
        if (vmprops.size() == 0) {
            return;
        }
        String argValue = "EAS_HOME;UPDATE_SERVER;EAS_SERVER";
        String[] args = new String[]{System.getProperty("EAS_HOME", ""), System.getProperty("UPDATE_SERVER", ""), System.getProperty("EAS_SERVER", "")};
        if (argValue != null && argValue.trim().length() > 0) {
            String[] argRefs = argValue.split(";");
            if (argRefs.length > args.length) {
                System.err.println("Command line args less than vmboot.argValue in vmoptions!");
                System.exit(-1);
            }
            for (int i = 0; i < argRefs.length; ++i) {
                if (args[i] == null) continue;
                vmprops.setProperty(argRefs[i], PropertiesUtils.unescape(args[i]));
            }
        }
        PropertiesUtils.expandProperties(vmprops);
        System.getProperties().putAll((Map<?, ?>)vmprops);
    }
}

