/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.DB;

import com.kingdee.bos.bi.model.DB.Field;
import com.kingdee.bos.bi.model.DB.SQLInfo;
import com.kingdee.bos.bi.model.rt.dim.IDManager;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBUtil {
    private static Map mapIDManager = new HashMap();
    public static final String SEQ_PREFIX = "S";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Object[] params, Connection cn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i <= params.length - 1; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
    }

    public static int executeUpdate(String sql, Connection cn) throws SQLException {
        return DBUtil.executeUpdate(sql, null, cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existRecord(String sql, Connection cn) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            boolean bl;
            stmt = null;
            rs = null;
            try {
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return bl;
        }
        boolean bl = false;
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getRecord(String sql, Connection cn) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            Object object;
            stmt = null;
            rs = null;
            try {
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                object = rs.getObject(1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return object;
        }
        Object var4_5 = null;
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return var4_5;
    }

    public static void createTable(String tablename, String viewid, List fields, boolean createInnerID, Connection cn) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + tablename);
        sb.append("(");
        if (createInnerID) {
            if (DBUtil.isMSSQL(cn)) {
                sb.append("FID int identity(1,1) not null,");
            } else if (DBUtil.isDB2(cn)) {
                sb.append("FID int identity(1,1) not null,");
            } else if (DBUtil.isOracle(cn)) {
                sb.append("FID int not null,");
            } else {
                throw new SQLException("\u672a\u77e5\u6570\u636e\u5e93\u7c7b\u578b!");
            }
        }
        int len = fields.size();
        for (int i = 0; i < len; ++i) {
            Field f = (Field)fields.get(i);
            sb.append(f.name);
            sb.append(" ");
            sb.append(f.type);
            sb.append(" ");
            sb.append(f.isnull ? "" : "not null");
            sb.append(f.defaultValue != null ? " default " + f.defaultValue : "");
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        if (createInnerID && DBUtil.isDB2(cn)) {
            try {
                String sqlDB2 = TransUtil.Translate((String)sb.toString(), (int)1);
                int start = sqlDB2.indexOf("FID");
                String replace = "FID INTEGER GENERATED ALWAYS AS IDENTITY NOT NULL";
                int end = sqlDB2.indexOf(",");
                sqlDB2 = "/*dialect*/" + sqlDB2.substring(0, start) + replace + sqlDB2.substring(end);
                DBUtil.executeUpdate("/*dialect*/" + sqlDB2, cn);
            }
            catch (SqlTranslateException e) {
                throw new SQLException(e.getMessage());
            }
        } else {
            DBUtil.executeUpdate(sb.toString(), cn);
        }
        if (createInnerID && DBUtil.isOracle(cn)) {
            StringBuffer sbSeq = new StringBuffer();
            sbSeq.append("/*dialect*/create sequence ").append(DBUtil.createSequenceName(tablename));
            sbSeq.append(" increment by 1 ");
            sbSeq.append(" start with 1 ");
            sbSeq.append(" nomaxvalue ");
            sbSeq.append(" nocache ");
            DBUtil.executeUpdate(sbSeq.toString(), cn);
        }
    }

    public static String createSequenceName(String tableName) {
        int tableNameLength;
        if (StringUtil.isEmpty(tableName)) {
            return "";
        }
        StringBuffer sequenceName = new StringBuffer();
        int seqPrefixLength = SEQ_PREFIX.length();
        if (seqPrefixLength + (tableNameLength = tableName.length()) > 30) {
            sequenceName.append(SEQ_PREFIX).append(tableName.substring(tableNameLength - (30 - seqPrefixLength), tableNameLength));
        } else {
            sequenceName.append(SEQ_PREFIX).append(tableName.trim());
        }
        return sequenceName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertIntoSelect(String tablename, boolean createInnerID, List fields, String view_table, String viewid, String where, Connection cn) throws SQLException {
        PreparedStatement stmt;
        block8: {
            stmt = null;
            if (view_table != null) break block8;
            SQLUtils.cleanup(stmt);
            return;
        }
        try {
            Field f;
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("insert into " + tablename);
            int len = fields.size();
            sb.append("(");
            if (createInnerID && DBUtil.isOracle(cn)) {
                sb.append("fid");
                sb.append(",");
            }
            for (i = 0; i < len; ++i) {
                f = (Field)fields.get(i);
                sb.append(f.name);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            sb.append(" select ");
            if (createInnerID && DBUtil.isOracle(cn)) {
                sb.append(DBUtil.createSequenceName(tablename) + ".NextVal");
                sb.append(",");
            }
            for (i = 0; i < len; ++i) {
                f = (Field)fields.get(i);
                if (f.value == null) {
                    sb.append(f.name);
                    sb.append(",");
                    continue;
                }
                sb.append(f.value);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" from ");
            sb.append(view_table);
            sb.append(" where FVIEWID='" + viewid + "'");
            sb.append(where == null ? "" : " and " + where);
            stmt = cn.prepareStatement(sb.toString());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertIntoSelect2(String tablename, List fields, String view_table, String viewid, String where, Connection cn) throws SQLException {
        PreparedStatement stmt;
        block9: {
            stmt = null;
            if (view_table != null) break block9;
            SQLUtils.cleanup(stmt);
            return;
        }
        try {
            boolean viewHasData;
            StringBuffer sbInsert = new StringBuffer();
            StringBuffer sbSelecetView = new StringBuffer();
            sbInsert.append("insert into " + tablename);
            sbInsert.append(" values(");
            sbSelecetView.append("select ");
            int len = fields.size();
            sbInsert.append("?");
            for (int i = 0; i < len; ++i) {
                sbInsert.append(",");
                sbInsert.append("?");
                if (i > 0) {
                    sbSelecetView.append(",");
                }
                sbSelecetView.append(((Field)fields.get((int)i)).name);
            }
            sbInsert.append(")");
            sbSelecetView.append(" from " + view_table);
            sbSelecetView.append(" where FViewID = '");
            sbSelecetView.append(viewid + "'");
            stmt = cn.prepareStatement(sbInsert.toString());
            RDRowSet rs = DBUtil.executeQuery(sbSelecetView.toString(), cn);
            IDManager idManager = (IDManager)mapIDManager.get(tablename);
            boolean bl = viewHasData = rs.getRowCount() > 0;
            while (rs.next()) {
                stmt.setInt(1, idManager.getIdentityID(cn));
                for (int i = 0; i < len; ++i) {
                    Field f = (Field)fields.get(i);
                    if (f.value == null) {
                        stmt.setObject(i + 2, rs.getObject(i + 1));
                        continue;
                    }
                    stmt.setObject(i + 2, f.value);
                }
                stmt.addBatch();
            }
            if (viewHasData) {
                stmt.executeBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    public static void dropSequence(String seqname, Connection cn) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("/*dialect*/DROP Sequence ");
        sb.append(seqname);
        DBUtil.executeUpdate(sb.toString(), cn);
    }

    public static void dropTable(boolean createInnerID, String tablename, Connection cn) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("DROP TABLE ");
        sb.append(tablename);
        DBUtil.executeUpdate(sb.toString(), cn);
        if (createInnerID && DBUtil.isOracle(cn)) {
            DBUtil.dropSequence(SEQ_PREFIX + tablename, cn);
        }
    }

    public static void dropIndex(String tablename, String indexname, Connection cn) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("drop index ");
        sb.append(tablename);
        sb.append(".");
        sb.append(indexname);
        DBUtil.executeUpdate(sb.toString(), cn);
    }

    public static void createPK(String tablename, String pkfield, String pkname, Connection cn) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(tablename);
        sb.append(" ADD CONSTRAINT ");
        sb.append(pkname);
        sb.append(" PRIMARY KEY (");
        sb.append(pkfield);
        sb.append(")");
        DBUtil.executeUpdate(sb.toString(), cn);
    }

    public static void dropPK(String tablename, String pkname, Connection cn) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(tablename);
        sb.append(" DROP CONSTRAINT ");
        sb.append(pkname);
        DBUtil.executeUpdate(sb.toString(), cn);
    }

    public static void createIndex(String tablename, String indexfield, String indexname, Connection cn) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("create index ");
        sb.append(indexname);
        sb.append(" ON ");
        sb.append(tablename);
        sb.append("(" + indexfield + ")");
        DBUtil.executeUpdate(sb.toString(), cn);
    }

    public static RDRowSet executeQuery(String sql, Connection cn) throws SQLException {
        return DBUtil.executeQuery(sql, 0, -1, cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDRowSet executeQuery(String sql, int from, int len, Connection cn) throws SQLException {
        RDRowSet rDRowSet;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            RDRowSet dbrs;
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery(sql);
            rDRowSet = dbrs = RDRowSet.parse((ResultSet)rs, (int)from, (int)len);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return rDRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDRowSet executeQuery(String sql, Object[] params, Connection cn) throws SQLException {
        RDRowSet rDRowSet;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            RDRowSet dbrs;
            stmt = cn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            rs = stmt.executeQuery();
            rDRowSet = dbrs = RDRowSet.parse((ResultSet)rs, (int)0, (int)-1);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return rDRowSet;
    }

    public static boolean isMSSQL(Connection cn) throws SQLException {
        String productName = cn.getMetaData().getDatabaseProductName();
        return productName.toUpperCase().indexOf("SQL SERVER") >= 0;
    }

    public static boolean isOracle(Connection cn) throws SQLException {
        String productName = cn.getMetaData().getDatabaseProductName();
        return productName.equals("Oracle");
    }

    public static boolean isDB2(Connection cn) throws SQLException {
        String productName = cn.getMetaData().getDatabaseProductName();
        return productName.startsWith("DB2");
    }

    public static String getDBType(Connection con) throws SQLException {
        try {
            if (DBUtil.isMSSQL(con)) {
                String string = "sqlServer";
                return string;
            }
            if (DBUtil.isOracle(con)) {
                String string = "oracle";
                return string;
            }
            if (DBUtil.isDB2(con)) {
                String string = "db2";
                return string;
            }
            throw new SQLException("\u672a\u77e5\u6570\u636e\u5e93\u7c7b\u578b");
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatchStatement(Map mapStatement, StringBuffer sbError, boolean ignoreError) {
        block8: {
            Statement stmt;
            Iterator it = mapStatement.keySet().iterator();
            block5: while (true) {
                while (it.hasNext()) {
                    String key = (String)it.next();
                    stmt = (Statement)mapStatement.get(key);
                    try {
                        stmt.executeBatch();
                        continue block5;
                    }
                    catch (SQLException e) {
                        String error = "\u6279\u91cf\u63d2\u5165\u6570\u636e\u65f6\uff0c\u6279\u91cf\u66f4\u65b0\u5931\u8d25\uff01" + e.getMessage();
                        sbError.append(error);
                        sbError.append("\n\r");
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                for (String key : mapStatement.keySet()) {
                    stmt = (Statement)mapStatement.get(key);
                    SQLUtils.cleanup((Statement)stmt);
                }
            }
        }
    }

    public static void executeDifferBatchUpdate(Connection cn, SQLInfo[] sqlInfos) throws SQLException {
        for (SQLInfo sqlInfo : sqlInfos) {
            String sql = sqlInfo.getSql();
            Object[] params = sqlInfo.getParams();
            if (params != null) {
                DBUtil.executeBatchUpdate(cn, sql, Arrays.asList(new Object[]{params}));
                continue;
            }
            DBUtil.executeBatch(cn, new String[]{sql});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatchUpdate(Connection cn, String sql, List paramList) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            if (paramList != null) {
                Object[] param = null;
                int m = paramList.size();
                for (int r = 0; r < m; ++r) {
                    param = (Object[])paramList.get(r);
                    int n = param.length;
                    for (int i = 0; i < n; ++i) {
                        stmt.setObject(i + 1, param[i]);
                    }
                    stmt.addBatch();
                }
            }
            int[] nArray = stmt.executeBatch();
            return nArray;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection cn, String sql, Object[] params) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(Connection cn, String[] sqls) throws SQLException {
        Statement stmt = null;
        try {
            stmt = cn.createStatement();
            int n = sqls.length;
            for (int i = 0; i < n; ++i) {
                stmt.addBatch(sqls[i]);
            }
            int[] nArray = stmt.executeBatch();
            return nArray;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }
}

