/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport.layout;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.bireport.CellElementBuilder;
import com.kingdee.bos.bi.model.common.bireport.DimensionMember;
import com.kingdee.bos.bi.model.common.bireport.DimensionSet;
import com.kingdee.bos.bi.model.common.bireport.ICellElement;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class RCell
implements Serializable {
    private List cellElements;
    private DimensionType dimType;
    private static final long serialVersionUID = 3389910095344031502L;

    public RCell(DimensionType dimType, List cellElements) {
        this.cellElements = cellElements;
        this.dimType = dimType;
    }

    public DimensionType getDimensionType() {
        return this.dimType;
    }

    public List getCellElements() {
        return this.cellElements;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cell dim=\"" + this.getDimensionType().getName() + "\">");
        int len = this.cellElements.size();
        for (int i = 0; i < len; ++i) {
            ICellElement ele = (ICellElement)this.cellElements.get(i);
            sb.append(ele.toXML());
        }
        sb.append("</Cell>");
        return sb.toString();
    }

    public String toMDX(Context ctx) {
        StringBuffer sb = new StringBuffer();
        int len = this.cellElements.size();
        if (len > 0) {
            if (len > 1) {
                sb.append("{");
            }
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                ICellElement ele = (ICellElement)this.cellElements.get(i);
                sb.append(ele.toMDX(ctx));
            }
            if (len > 1) {
                sb.append("}");
            }
        }
        return sb.toString();
    }

    public void getCalMembers(Context ctx, List lstRet) {
        int len = this.cellElements.size();
        for (int i = 0; i < len; ++i) {
            ICellElement ele = (ICellElement)this.cellElements.get(i);
            if (!(ele instanceof DimensionMember) || !((DimensionMember)ele).isCalculator()) continue;
            lstRet.add(ele);
        }
    }

    public void getSets(Context ctx, Set lstRet) {
        int len = this.cellElements.size();
        for (int i = 0; i < len; ++i) {
            ICellElement ele = (ICellElement)this.cellElements.get(i);
            if (!(ele instanceof DimensionSet)) continue;
            lstRet.add(ele);
        }
    }

    public static RCell fromElement(Element e, Context ctx, AppModel apm) throws SQLException {
        Dimension dim = apm.getDimension(e.attributeValue("dim"));
        ArrayList<ICellElement> cellElements = new ArrayList<ICellElement>();
        List cellElementNodes = e.selectNodes("Item");
        int len = cellElementNodes.size();
        for (int i = 0; i < len; ++i) {
            cellElements.add(CellElementBuilder.fromXml(dim, (Element)cellElementNodes.get(i)));
        }
        return new RCell(dim.getDimensionDef().getDimensionType(), cellElements);
    }
}

