/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport.property.bean;

import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.common.bireport.layout.ComponentProperty;
import com.kingdee.bos.bi.model.common.bireport.property.bean.BIReportBean;
import com.kingdee.bos.bi.model.common.bireport.property.config.factory.BIReportPropertyConfigFactory;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.BaseBeanInfo;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.ExtendedPropertyDescriptor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.editor.BooleanPropertyEditor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.editor.IntegerSpinnerPropertyEditor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.editor.StringPropertyEditor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.event.PropEditEvent;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.event.PropEditListener;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.renderer.BooleanCellRenderer;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.BooleanValue;
import com.kingdee.bos.bi.model.ui.dialog.bireport.property.editor.DynaComboBoxPropertyEditor;
import com.kingdee.bos.bi.model.util.StringUtil;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.jdom2.JDOMException;

public class BIReportBeanBeanInfo
extends BaseBeanInfo {
    private List biReportComponentPropertyList = new ArrayList();
    private Hashtable descriptorCache = new Hashtable();

    public BIReportBeanBeanInfo(String componentType) throws IntrospectionException, IOException, JDOMException {
        this.type = BIReportBean.class;
        this.getBIReportComponentPropertyList(componentType);
        this.createBIReportComponentPropertyDescriptor(componentType);
    }

    public List getBiReportComponentPropertyList() {
        return this.biReportComponentPropertyList;
    }

    private void createBIReportComponentPropertyDescriptor(String componentType) throws IntrospectionException {
        for (ComponentProperty componentProperty : this.biReportComponentPropertyList) {
            String key = componentProperty.getName();
            final ExtendedPropertyDescriptor descriptor = this.getBIReportComponentPropertyDescriptor(key, componentProperty);
            ComponentProperty.Listener[] ls = componentProperty.getListeners();
            if (ls == null || ls.length <= 0) continue;
            for (final ComponentProperty.Listener l : ls) {
                PropEditListener listener = new PropEditListener(){

                    @Override
                    public void valueChanged(PropEditEvent e) {
                        ExtendedPropertyDescriptor d = (ExtendedPropertyDescriptor)((Object)e.getSource());
                        BIReportBean b = (BIReportBean)e.getValue();
                        boolean v = false;
                        if (b.getProp(d.getKey()) != null) {
                            Object o = b.getProp(d.getKey());
                            if (o instanceof String) {
                                v = StringUtil.toBoolean((String)o);
                            } else if (o instanceof Boolean) {
                                v = (Boolean)o;
                            } else if (o instanceof BooleanValue) {
                                v = ((BooleanValue)b.getProp(d.getKey())).getPrimitiveValue();
                            }
                        }
                        if ("isEditable".equals(l.getAction())) {
                            descriptor.setEditable(v);
                        }
                    }
                };
                ExtendedPropertyDescriptor sourceDescriptor = this.getBIReportComponentPropertyDescriptor(l.getSource(), componentProperty);
                sourceDescriptor.addPropEditListener(listener);
            }
        }
    }

    private ExtendedPropertyDescriptor getBIReportComponentPropertyDescriptor(String key, ComponentProperty componentProperty) throws IntrospectionException {
        if (this.descriptorCache.containsKey(key)) {
            return (ExtendedPropertyDescriptor)((Object)this.descriptorCache.get(key));
        }
        ExtendedPropertyDescriptor descriptor = null;
        String category = componentProperty.getCategory().getName();
        String tempKey = componentProperty.getName();
        String editType = componentProperty.getEditType();
        EnumObj[] enums = componentProperty.getEnums();
        if (tempKey.equals(key)) {
            descriptor = this.addPropertyDescriptor(category, tempKey, "prop", enums, componentProperty.getVerifiers(), componentProperty.getDefaultValue());
            descriptor.setDisplayName(componentProperty.getCaption());
            descriptor.setShortDescription(componentProperty.getDescription());
            descriptor.setCategory(componentProperty.getCategory().getAlias());
            this.setPropertyEditorClass(editType, descriptor);
        }
        this.descriptorCache.put(key, descriptor);
        return descriptor;
    }

    private void setPropertyEditorClass(String editType, ExtendedPropertyDescriptor descriptor) {
        if ("textField".equalsIgnoreCase(editType)) {
            descriptor.setPropertyEditorClass(StringPropertyEditor.class);
        } else if ("comboBox".equalsIgnoreCase(editType)) {
            descriptor.setPropertyEditorClass(DynaComboBoxPropertyEditor.class);
        } else if ("checkBox".equalsIgnoreCase(editType)) {
            descriptor.setPropertyEditorClass(BooleanPropertyEditor.class);
            descriptor.setPropertyTableRendererClass(BooleanCellRenderer.class);
        } else if ("integerTextField".equalsIgnoreCase(editType)) {
            descriptor.setPropertyEditorClass(IntegerSpinnerPropertyEditor.class);
        } else {
            descriptor.setPropertyEditorClass(StringPropertyEditor.class);
        }
    }

    private void getBIReportComponentPropertyList(String componentType) throws IOException, JDOMException {
        this.biReportComponentPropertyList.clear();
        List cpList = BIReportPropertyConfigFactory.getBIReportPropertyList(componentType);
        this.biReportComponentPropertyList.addAll(cpList);
    }
}

