/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.customdim;

import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.list.ListUtil;
import com.kingdee.bos.bi.model.common.mm.customdim.AbstractCustomDimModel;
import com.kingdee.bos.bi.model.common.mm.customdim.GeneralDimModel;
import com.kingdee.bos.bi.model.common.mm.customdim.GeneralDimProperty;
import com.kingdee.bos.bi.model.common.mm.customdim.TimeDimModel;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public class CustomDimUtil {
    public static void deleteViewList(IManagementFacade facade, String customDimId) throws BIModelRemoteException {
        StringBuffer sb = new StringBuffer();
        sb.append("delete from T_BI_CSTM_List where FCSTMID='").append(customDimId).append("'");
        try {
            facade.executeUpdate(sb.toString());
        }
        catch (SQLException e) {
            throw new BIModelRemoteException("\u6570\u636e\u5e93\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38!", e);
        }
    }

    public static String save(IManagementFacade facade, String id, AbstractCustomDimModel m) throws BIModelRemoteException {
        StringBuffer sb = new StringBuffer();
        String attrs = "";
        if ("general".equalsIgnoreCase(m.getType())) {
            try {
                attrs = CustomDimUtil.toXml((GeneralDimModel)m);
            }
            catch (IOException e) {
                throw new BIModelRemoteException("\u8f6c\u6362xml\u51fa\u9519" + e);
            }
        }
        if (id == null) {
            id = com.kingdee.bos.bi.model.util.StringUtil.getUUID();
            sb.append("INSERT INTO T_BI_MM_CUSTOM ");
            sb.append("(FID,FNumber,FName,FType,FDiscription,FAttributes,FCreatorID,FLastUpdateUserID,FCreateTime,FLastUpdateTime)");
            sb.append("Values('").append(id).append("','").append(m.getNumber()).append("','").append(m.getName()).append("','");
            sb.append(m.getType()).append("','").append(m.getDescription()).append("','").append(attrs).append("','");
            sb.append(facade.getCurrentUser()).append("','").append(facade.getCurrentUser()).append("',getdate(),getdate())");
        } else {
            sb.append("update T_BI_MM_CUSTOM set ");
            sb.append("FName='").append(m.getName()).append("',");
            sb.append("FDiscription='").append(m.getDescription()).append("',");
            sb.append("FLastUpdateUserID='").append(facade.getCurrentUser()).append("',");
            sb.append("FLastUpdateTime=getdate()").append(",");
            sb.append("FAttributes='").append(attrs).append("'");
            sb.append(" where FID='").append(id).append("'");
        }
        try {
            facade.executeUpdate(sb.toString());
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        return id;
    }

    public static String toXml(GeneralDimModel generalDimModel) throws IOException {
        List propertyList = generalDimModel.getPropertyList();
        Element rootElement = new Element("customDim");
        rootElement.setAttribute("type", "general");
        Element parametersElement = new Element("parameters");
        Element parameterElement = new Element("parameter");
        parameterElement.setAttribute("numberLength", Integer.toString(generalDimModel.getNumberLength()));
        parameterElement.setAttribute("nameLength", Integer.toString(generalDimModel.getNameLength()));
        parametersElement.addContent((Content)parameterElement);
        Element propertiesElement = new Element("properties");
        Document doc = new Document(rootElement);
        Element propertyElement = null;
        GeneralDimProperty attr2 = null;
        for (GeneralDimProperty attr2 : propertyList) {
            propertyElement = new Element("property");
            propertyElement.setAttribute("number", attr2.getNumber());
            propertyElement.setAttribute("name", attr2.getName());
            propertyElement.setAttribute("type", attr2.getType());
            propertyElement.setAttribute("length", attr2.getLength() == null ? "" : attr2.getLength());
            propertyElement.setAttribute("precision", attr2.getPrecision() == null ? "" : attr2.getPrecision());
            propertyElement.setAttribute("fieldName", attr2.getFieldName() == null ? "" : attr2.getFieldName());
            propertiesElement.addContent((Content)propertyElement);
        }
        rootElement.addContent((Content)parametersElement);
        rootElement.addContent((Content)propertiesElement);
        Format format = Format.getPrettyFormat();
        format.setEncoding("GBK");
        XMLOutputter out = new XMLOutputter(format);
        ByteArrayOutputStream bop = new ByteArrayOutputStream();
        out.output(doc, (OutputStream)bop);
        return bop.toString();
    }

    public static void toModel(GeneralDimModel generalDimModel, String xml) throws JDOMException, IOException {
        ArrayList<GeneralDimProperty> attributeList = new ArrayList<GeneralDimProperty>();
        int numberLength = 80;
        int nameLength = 256;
        SAXBuilder sb = new SAXBuilder();
        Document doc = sb.build(new InputSource(new StringReader(xml)));
        Element rootElement = doc.getRootElement();
        Element parametersElement = rootElement.getChild("parameters");
        if (parametersElement != null) {
            Element parameterElement = parametersElement.getChild("parameter");
            numberLength = Integer.parseInt(parameterElement.getAttributeValue("numberLength"));
            nameLength = Integer.parseInt(parameterElement.getAttributeValue("nameLength"));
        }
        Element attributesElement = rootElement.getChild("properties");
        Element attributeElement = null;
        GeneralDimProperty attr = null;
        List attributesElementList = attributesElement.getChildren();
        int n = attributesElementList.size();
        for (int i = 0; i < n; ++i) {
            attributeElement = (Element)attributesElementList.get(i);
            attr = new GeneralDimProperty();
            String number = attributeElement.getAttributeValue("number");
            String name = attributeElement.getAttributeValue("name");
            String type = attributeElement.getAttributeValue("type");
            String length = attributeElement.getAttributeValue("length");
            String precision = attributeElement.getAttributeValue("precision");
            String fieldName = attributeElement.getAttributeValue("fieldName");
            attr.setNumber(number);
            attr.setName(name);
            attr.setType(type);
            attr.setLength(length);
            attr.setPrecision(precision);
            attr.setFieldName(fieldName);
            attributeList.add(attr);
        }
        generalDimModel.setPropertyList(attributeList);
        generalDimModel.setNumberLength(numberLength);
        generalDimModel.setNameLength(nameLength);
    }

    public static AbstractCustomDimModel createCustomDimInstance(String dimMetaType) {
        if ("time".equals(dimMetaType)) {
            return new TimeDimModel();
        }
        if ("general".equals(dimMetaType)) {
            return new GeneralDimModel();
        }
        return null;
    }

    public static AbstractCustomDimModel load(String dimMetaType, String dimNumber, IManagementFacade facade) throws BIModelRemoteException {
        AbstractCustomDimModel dimModel = CustomDimUtil.createCustomDimInstance(dimMetaType);
        StringBuffer sb = new StringBuffer();
        sb.append("select FID,FNumber,FName,FDiscription,FAttributes from T_BI_MM_CUSTOM where FType='");
        sb.append(dimMetaType).append("' and FNumber='").append(dimNumber).append("'");
        try {
            RDRowSet rs = facade.executeQuery(sb.toString());
            if (rs.next()) {
                dimModel.setId(rs.getString("FID"));
                dimModel.setNumber(rs.getString("FNumber"));
                dimModel.setName(rs.getString("FName"));
                dimModel.setDescription(rs.getString("FDiscription"));
                String xml = rs.getString("FAttributes");
                if (!StringUtil.isEmptyString((String)xml)) {
                    CustomDimUtil.toModel((GeneralDimModel)dimModel, xml);
                }
            }
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        catch (JDOMException e) {
            throw new BIModelRemoteException(e);
        }
        catch (IOException e) {
            throw new BIModelRemoteException(e);
        }
        return dimModel;
    }

    public static boolean checkCustomDefNumberExist(IManagementFacade facade, String viewType, String dimType, String dimNumber) throws BIModelRemoteException, SQLException {
        String tablename = ListUtil.getViewTablename(viewType);
        StringBuffer sb = new StringBuffer();
        sb.append("select FID from " + tablename);
        sb.append(" where FNumber='");
        sb.append(dimNumber + "'");
        RDRowSet rowSet = facade.executeQuery(sb.toString());
        return rowSet.getRowCount() > 0;
    }

    public static boolean checkCustomDefNumberDefault(String dimNumber) {
        return com.kingdee.bos.bi.model.util.StringUtil.equalsIgnoreCase("org", dimNumber) || com.kingdee.bos.bi.model.util.StringUtil.equalsIgnoreCase("metric", dimNumber) || com.kingdee.bos.bi.model.util.StringUtil.equalsIgnoreCase("period", dimNumber) || com.kingdee.bos.bi.model.util.StringUtil.equalsIgnoreCase("year", dimNumber) || com.kingdee.bos.bi.model.util.StringUtil.equalsIgnoreCase("measure", dimNumber);
    }

    public static boolean checkDimIdExist(IManagementFacade facade, String viewType, String viewId) throws BIModelRemoteException, SQLException {
        String tablename = ListUtil.getViewTablename(viewType);
        StringBuffer sb = new StringBuffer();
        sb.append("select FID from ").append(tablename).append(" where FID='").append(viewId).append("'");
        RDRowSet rowSet = facade.executeQuery(sb.toString());
        return rowSet.getRowCount() > 0;
    }

    public static String getTableName(String type, String number) {
        return ("T_BI_MM_" + type + "_" + number).toUpperCase();
    }

    public static String getPKName(String type, String number) {
        String tempPK = ("PK_" + type + number).toUpperCase();
        return tempPK.length() > 18 ? tempPK.substring(0, 18) : tempPK;
    }

    public static String getPK(String type) {
        if ("time".equalsIgnoreCase(type)) {
            return "FViewID";
        }
        if ("general".equalsIgnoreCase(type)) {
            return "FViewID,FNumber";
        }
        return "FID";
    }

    public static String getTableName(IManagementFacade facade, String dimId) throws SQLException {
        String sql = "select FNumber,FType from T_BI_MM_CUSTOM where FID='" + dimId + "'";
        RDRowSet rs = facade.executeQuery(sql);
        if (rs.next()) {
            return CustomDimUtil.getTableName(rs.getString("FType"), rs.getString("FNumber"));
        }
        return null;
    }

    public static boolean checkHasUsedView(IManagementFacade facade, String dimId) throws BIModelRemoteException, SQLException {
        String sql = "select * from T_BI_CSTM_List where FCSTMID='" + dimId + "' and FUSEFLAG=1";
        RDRowSet rs = facade.executeQuery(sql);
        return rs.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCustomDimType(Connection cn, String number) throws SQLException {
        String type = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "select FType from T_BI_MM_CUSTOM where FNumber='" + number + "'";
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                type = rs.getString("FType");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneralDimModel loadGeneralDimModel(Connection con, String number) throws SQLException, JDOMException, IOException {
        ResultSet rs;
        PreparedStatement stmt;
        GeneralDimModel m;
        block3: {
            m = new GeneralDimModel();
            StringBuffer sb = new StringBuffer();
            sb.append("select FID,FNumber,FName,FDiscription,FAttributes from T_BI_MM_CUSTOM where FType='");
            sb.append("general").append("' and FNumber='").append(number).append("'");
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(sb.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                m.setId(rs.getString("FID"));
                m.setNumber(rs.getString("FNumber"));
                m.setName(rs.getString("FName"));
                m.setDescription(rs.getString("FDiscription"));
                String xml = rs.getString("FAttributes");
                if (!StringUtil.isEmptyString((String)xml)) {
                    CustomDimUtil.toModel(m, xml);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return m;
    }

    public static GeneralDimModel loadGeneralDimModel(IManagementFacade facade, String number) throws SQLException, JDOMException, IOException {
        GeneralDimModel m = new GeneralDimModel();
        StringBuffer sb = new StringBuffer();
        sb.append("select FID,FNumber,FName,FDiscription,FAttributes from T_BI_MM_CUSTOM where FType='");
        sb.append("general").append("' and FNumber='").append(number).append("'");
        RDRowSet rs = facade.executeQuery(sb.toString());
        if (rs.next()) {
            m.setId(rs.getString("FID"));
            m.setNumber(rs.getString("FNumber"));
            m.setName(rs.getString("FName"));
            m.setDescription(rs.getString("FDiscription"));
            String xml = rs.getString("FAttributes");
            CustomDimUtil.toModel(m, xml);
        }
        return m;
    }

    public static List loadGeneralDimModelProperties(Connection con, String number) throws SQLException, JDOMException, IOException {
        return CustomDimUtil.loadGeneralDimModel(con, number).getPropertyList();
    }

    public static List loadGeneralDimModelProperties2(Connection cn, String number, String pubNumber) throws SQLException, JDOMException, IOException, ParseException {
        List properties = null;
        String sql = "select FDimMetaData from T_BI_AppModel A,T_BI_AM_MetaData M where A.FID=M.FAMID and A.FPublishNumber='" + pubNumber + "' and M.FDimType='" + number + "'";
        RDRowSet rs = DBUtil.executeQuery(sql, cn);
        if (rs.next()) {
            GeneralDimModel generalDimModel = new GeneralDimModel();
            CustomDimUtil.toModel(generalDimModel, rs.getString("FDimMetaData"));
            properties = generalDimModel.getPropertyList();
        }
        return properties;
    }

    public static List loadGeneralDimModelProperties3(IManagementFacade facade, String amId, String dimNumber) throws SQLException, JDOMException, IOException, ParseException {
        List properties = null;
        String sql = "select FDimMetaData from T_BI_AppModel A,T_BI_AM_MetaData M where A.FID=M.FAMID and A.FID='" + amId + "' and M.FDimType='" + dimNumber + "'";
        RDRowSet rs = facade.executeQuery(sql);
        if (rs.next()) {
            GeneralDimModel generalDimModel = new GeneralDimModel();
            CustomDimUtil.toModel(generalDimModel, rs.getString("FDimMetaData"));
            properties = generalDimModel.getPropertyList();
        }
        return properties;
    }
}

